/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.dialog;

import android.content.Context;
import android.content.Intent;
import android.os.CountDownTimer;
import android.view.View;
import android.widget.TextView;
import com.vhall.appui.baselib.R;
import com.vhall.appui.baselib.base.BaseActivity;
import com.vhall.appui.baselib.dialog.RtcRequestDialog;
import com.vhall.appui.baselib.utils.UserUtils;
import java.lang.ref.WeakReference;

public class RtcRequestDialogV2
extends BaseActivity
implements View.OnClickListener {
    private TextView user_name;
    private TextView reject_action;
    private TextView agree_action;
    private TextView header_icon;
    private CountDownTimer timer;
    private TextView dialog_title;
    private static WeakReference<RtcRequestDialog.RtcRequestListener> mListener;
    private UserUtils userUtils;
    private String agreeFormat;

    @Override
    protected int getLayoutId() {
        return R.layout.common_rtc_request_dialog_layout;
    }

    @Override
    protected void initView() {
        this.user_name = (TextView)this.findViewById(R.id.user_name);
        this.reject_action = (TextView)this.findViewById(R.id.reject_action);
        this.agree_action = (TextView)this.findViewById(R.id.agree_action);
        this.header_icon = (TextView)this.findViewById(R.id.header_icon);
        this.dialog_title = (TextView)this.findViewById(R.id.dialog_title);
        this.reject_action.setOnClickListener((View.OnClickListener)this);
        this.agree_action.setOnClickListener((View.OnClickListener)this);
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = new CountDownTimer(30000L, 1000L){

            public void onTick(long millisUntilFinished) {
                RtcRequestDialogV2.this.agree_action.setText((CharSequence)String.format(RtcRequestDialogV2.this.agreeFormat, millisUntilFinished / 1000L));
            }

            public void onFinish() {
                RtcRequestDialogV2.this.finish();
            }
        };
        this.timer.start();
    }

    @Override
    protected void initData() {
        this.userUtils = new UserUtils(this.getIntent().getStringExtra("userId"), this.getIntent().getStringExtra("userName"));
        this.dialog_title.setText((CharSequence)this.getIntent().getStringExtra("title"));
        this.user_name.setText((CharSequence)this.userUtils.nickname);
        this.agreeFormat = this.getIntent().getStringExtra("agreeTxtFormat");
        this.reject_action.setText((CharSequence)this.getIntent().getStringExtra("cancelTxt"));
        UserUtils.setAvatar(this.header_icon, this.userUtils.account_id, this.userUtils.nickname);
    }

    public static void startDialog(Context context, String userId, String userName, String title, String cancelTxt, String agreeTxtFormat) {
        Intent intent = new Intent(context, RtcRequestDialogV2.class);
        intent.putExtra("userId", userId);
        intent.putExtra("userName", userName);
        intent.putExtra("title", title);
        intent.putExtra("cancelTxt", cancelTxt);
        intent.putExtra("agreeTxtFormat", agreeTxtFormat);
    }

    public static void setListener(RtcRequestDialog.RtcRequestListener listener) {
        mListener = new WeakReference<RtcRequestDialog.RtcRequestListener>(listener);
    }

    public void onClick(View v) {
        if (v == this.reject_action) {
            if (mListener != null) {
                ((RtcRequestDialog.RtcRequestListener)mListener.get()).onReject(this.userUtils);
            }
            this.finish();
        } else if (v == this.agree_action) {
            if (mListener != null) {
                ((RtcRequestDialog.RtcRequestListener)mListener.get()).onAgree(this.userUtils);
            }
            this.finish();
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (this.timer != null) {
            this.timer.cancel();
        }
    }
}

