/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.dialog;

import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.text.TextUtils;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.TextView;
import com.vhall.appui.baselib.R;
import com.vhall.appui.baselib.base.BaseBottomDialog;
import com.vhall.appui.baselib.utils.UserUtils;
import com.vhall.appui.baselib.utils.VHToast;
import com.vhall.appui.baselib.vss.CallBack;
import com.vhall.appui.baselib.vss.module.rtc.VssRtcManager;

public class RtcRequestDialog
extends BaseBottomDialog
implements View.OnClickListener {
    private TextView user_name;
    private TextView reject_action;
    private TextView agree_action;
    private TextView header_icon;
    private CountDownTimer timer;
    private TextView dialog_title;
    private RtcRequestListener mListener;
    private UserUtils userUtils;
    private String agreeFormat;

    public RtcRequestDialog(Context context) {
        super(context);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.common_rtc_request_dialog_layout);
        this.setCancelable(true);
        this.setCanceledOnTouchOutside(false);
        this.initView();
        this.initListener();
        Window dialogWindow = this.getWindow();
        WindowManager.LayoutParams lp = dialogWindow.getAttributes();
        lp.height = -2;
        dialogWindow.setAttributes(lp);
    }

    private void initListener() {
        this.reject_action.setOnClickListener((View.OnClickListener)this);
        this.agree_action.setOnClickListener((View.OnClickListener)this);
        this.header_icon.setOnClickListener((View.OnClickListener)this);
    }

    private void initView() {
        this.user_name = (TextView)this.findViewById(R.id.user_name);
        this.reject_action = (TextView)this.findViewById(R.id.reject_action);
        this.agree_action = (TextView)this.findViewById(R.id.agree_action);
        this.header_icon = (TextView)this.findViewById(R.id.header_icon);
        this.dialog_title = (TextView)this.findViewById(R.id.dialog_title);
        this.dialog_title = (TextView)this.findViewById(R.id.dialog_title);
        if (TextUtils.equals((CharSequence)"PBEM00", (CharSequence)Build.MODEL)) {
            this.findViewById(R.id.oppo_place).setVisibility(0);
        } else {
            this.findViewById(R.id.oppo_place).setVisibility(8);
        }
    }

    public void onClick(View v) {
        if (v == this.reject_action) {
            if (this.mListener != null) {
                this.mListener.onReject(this.userUtils);
            }
        } else if (v == this.agree_action && this.mListener != null) {
            this.mListener.onAgree(this.userUtils);
        }
        this.dismiss();
    }

    @Override
    public void show() {
        super.show();
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = new CountDownTimer(30000L, 1000L){

            public void onTick(long millisUntilFinished) {
                RtcRequestDialog.this.agree_action.setText((CharSequence)String.format(RtcRequestDialog.this.agreeFormat, millisUntilFinished / 1000L));
            }

            public void onFinish() {
                RtcRequestDialog.this.dismiss();
                VssRtcManager.getInstance(RtcRequestDialog.this.getContext()).rejectInvite(new CallBack(){

                    public void onSuccess(Object result) {
                    }

                    @Override
                    public void onError(int eventCode, String msg) {
                        VHToast.showShortToast(msg);
                    }
                });
            }
        };
        this.timer.start();
    }

    @Override
    public void dismiss() {
        super.dismiss();
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    public void setData(UserUtils userUtils, String title, String cancelTxt, String agreeTxtFormat) {
        this.userUtils = userUtils;
        this.dialog_title.setText((CharSequence)title);
        this.user_name.setText((CharSequence)userUtils.nickname);
        this.agreeFormat = agreeTxtFormat;
        this.reject_action.setText((CharSequence)cancelTxt);
        UserUtils.setAvatar(this.header_icon, userUtils.account_id, userUtils.nickname);
    }

    public void setListener(RtcRequestListener mListener) {
        this.mListener = mListener;
    }

    public static interface RtcRequestListener {
        public void onReject(UserUtils var1);

        public void onAgree(UserUtils var1);
    }
}

