/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.dialog;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.FrameLayout;
import com.vhall.appui.baselib.R;
import com.vhall.appui.baselib.ServiceManager;
import com.vhall.appui.baselib.base.BaseBottomDialog;
import com.vhall.appui.baselib.service.rtcLive.IRtcLiveService;
import com.vhall.appui.baselib.utils.DensityUtils;
import com.vhall.appui.baselib.widget.RtcMenuWidget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class RtcMoreMenuDialog
extends BaseBottomDialog
implements View.OnClickListener {
    private FrameLayout menu_container;
    private static final String ROOM_INFO = "roomInfo";
    private static int showCount = 4;
    private List<RtcMenuWidget.IMenuInfo> menuInfos = new ArrayList<RtcMenuWidget.IMenuInfo>();
    private RtcMenuWidget.OnMenuClick mOnMenuClick = new RtcMenuWidget.OnMenuClick(){

        @Override
        public void onServiceClick(RtcMenuWidget.MenuInfo info) {
            if (TextUtils.equals((CharSequence)info.service, (CharSequence)RtcMoreMenuDialog.ROOM_INFO)) {
                RtcMoreMenuDialog.this.onClickRoomInfo();
            } else if (TextUtils.equals((CharSequence)info.service, (CharSequence)"interactive_manager")) {
                RtcMoreMenuDialog.this.onClickRtcManager();
            } else if (TextUtils.equals((CharSequence)info.service, (CharSequence)"exam")) {
                RtcMoreMenuDialog.this.onClickRtcExam();
            } else if (TextUtils.equals((CharSequence)info.service, (CharSequence)"question")) {
                RtcMoreMenuDialog.this.onClickRtcQuestion();
            } else {
                info.onMenuClick.onServiceClick(info);
            }
            RtcMoreMenuDialog.this.dismiss();
        }
    };

    public RtcMoreMenuDialog(Context context) {
        super(context);
        IRtcLiveService service = (IRtcLiveService)ServiceManager.getService("vertical_rtc_live_service");
        if (service != null) {
            this.menuInfos.addAll(service.getRtcMoreMenu());
        }
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.common_rtc_more_menu_dialog_layout);
        this.setCancelable(true);
        this.setCanceledOnTouchOutside(true);
        this.initView();
        this.initMenuInfos();
        Window dialogWindow = this.getWindow();
        WindowManager.LayoutParams lp = dialogWindow.getAttributes();
        lp.height = -2;
        dialogWindow.setAttributes(lp);
    }

    private void initMenuInfos() {
        this.menuInfos.add(new RtcMenuWidget.MenuInfo(R.string.base_room_info, ROOM_INFO, R.drawable.common_room_info));
        this.menuInfos.add(new RtcMenuWidget.MenuInfo(R.string.base_rtc_manager, "interactive_manager", R.drawable.common_rtc_manager));
        this.menuInfos.add(new RtcMenuWidget.MenuInfo(R.string.base_exam, "exam", R.drawable.common_rtc_exam));
        this.menuInfos.add(new RtcMenuWidget.MenuInfo(R.string.base_question, "question", R.drawable.common_rtc_question));
        Collections.sort(this.menuInfos, new Comparator<RtcMenuWidget.IMenuInfo>(){

            @Override
            public int compare(RtcMenuWidget.IMenuInfo o1, RtcMenuWidget.IMenuInfo o2) {
                if (o1.getPriority() < o2.getPriority()) {
                    return -1;
                }
                if (o1.getPriority() > o2.getPriority()) {
                    return 1;
                }
                return 0;
            }
        });
        this.menu_container.removeAllViews();
        int num = 0;
        for (int i = 0; i < this.menuInfos.size(); ++i) {
            RtcMenuWidget.MenuInfo info = (RtcMenuWidget.MenuInfo)this.menuInfos.get(i);
            if (!ServiceManager.isEnableService(info.service) && !TextUtils.equals((CharSequence)ROOM_INFO, (CharSequence)info.service)) continue;
            RtcMenuWidget menu = new RtcMenuWidget(this.getContext());
            menu.setData(info);
            menu.setMenuClick(this.mOnMenuClick);
            info.context = this.mContext;
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(DensityUtils.getScreenWidth() / showCount, -2);
            params.leftMargin = num % showCount * (DensityUtils.getScreenWidth() / showCount);
            params.topMargin = num / showCount * (DensityUtils.getScreenWidth() / showCount);
            this.menu_container.addView((View)menu, (ViewGroup.LayoutParams)params);
            ++num;
        }
    }

    private void initView() {
        this.menu_container = (FrameLayout)this.findViewById(R.id.menu_container);
    }

    public void onClick(View v) {
        this.dismiss();
    }

    public void onClickRoomInfo() {
    }

    public void onClickRtcManager() {
    }

    public void onClickRtcExam() {
    }

    public void onClickRtcQuestion() {
    }
}

