/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.dialog;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Color;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.TextView;
import com.vhall.appui.baselib.R;
import com.vhall.appui.baselib.utils.DensityUtils;
import com.vhall.appui.baselib.utils.DrawableUtils;

public class ExitDialog
extends Dialog {
    public static final int TYPE_OWNER = 0;
    public static final int TYPE_UPPER = 1;
    TextView mCancelBtn;
    TextView mCommitBtn;
    TextView mContentView;
    Context mContext;
    private OnCommitListener mListener;

    public void setListener(OnCommitListener listener) {
        this.mListener = listener;
    }

    public ExitDialog(Context context) {
        super(context);
        this.mContext = context;
        this.init();
    }

    public ExitDialog(Context context, boolean cancelable, DialogInterface.OnCancelListener cancelListener) {
        super(context, cancelable, cancelListener);
        this.mContext = context;
        this.init();
    }

    public ExitDialog(Context context, int themeResId) {
        super(context, themeResId);
        this.mContext = context;
        this.init();
    }

    private void init() {
        this.setContentView(R.layout.exit_login_dialog);
        this.mCancelBtn = (TextView)this.findViewById(R.id.cancel_action);
        this.mCommitBtn = (TextView)this.findViewById(R.id.confirm_action);
        float[] right = new float[]{0.0f, 0.0f, 0.0f, 0.0f, DensityUtils.dpToPx(this.getContext(), 15.0f), DensityUtils.dpToPx(this.getContext(), 15.0f), 0.0f, 0.0f};
        float[] left = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, DensityUtils.dpToPx(this.getContext(), 15.0f), DensityUtils.dpToPx(this.getContext(), 15.0f)};
        this.mCancelBtn.setBackground(DrawableUtils.getPressShape(0, 0, 0, left, Color.parseColor((String)"#EFEFEF")));
        this.mCommitBtn.setBackground(DrawableUtils.getPressShape(0, 0, 0, right, Color.parseColor((String)"#EFEFEF")));
        this.mContentView = (TextView)this.findViewById(R.id.tips);
        this.mCancelBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ExitDialog.this.dismiss();
            }
        });
        this.mCommitBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ExitDialog.this.mListener != null) {
                    ExitDialog.this.mListener.onCommit();
                }
                ExitDialog.this.dismiss();
            }
        });
        Window dialogWindow = this.getWindow();
        dialogWindow.setBackgroundDrawable(this.mContext.getResources().getDrawable(R.drawable.shape_dialog_window_bg));
        WindowManager.LayoutParams lp = dialogWindow.getAttributes();
        DisplayMetrics d = this.mContext.getResources().getDisplayMetrics();
        lp.width = d.widthPixels / 5 * 4;
        dialogWindow.setAttributes(lp);
    }

    public void setType(int type) {
        switch (type) {
            case 0: {
                this.mContentView.setText(R.string.base_confirm_exit_live);
                break;
            }
            case 1: {
                this.mContentView.setText(R.string.base_confirm_exit_room);
                break;
            }
        }
    }

    public static interface OnCommitListener {
        public void onCommit();
    }
}

