/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.core.rbac;

import com.vhall.appui.baselib.vss.data.EnumRoleName;
import java.util.HashMap;
import java.util.Map;

public class RBACManager {
    static Map<Integer, int[][]> menus = new HashMap<Integer, int[][]>();
    static Map<Integer, int[][]> interactiveMenus = new HashMap<Integer, int[][]>();

    public static int[] parseInteractiveMenuList(String operateRoleName, String operatedRoleName, boolean isManScreen) {
        EnumRoleName operateRole = EnumRoleName.getRole(operateRoleName);
        EnumRoleName operatedRole = EnumRoleName.getRole(operatedRoleName);
        if (operateRole != null && operatedRole != null) {
            int type = 0;
            switch (operateRole) {
                case host: {
                    if (operatedRole == EnumRoleName.host) {
                        type = 1;
                        break;
                    }
                    if (operatedRole == EnumRoleName.assistant) {
                        type = 2;
                        break;
                    }
                    if (operatedRole == EnumRoleName.guest) {
                        type = 3;
                        break;
                    }
                    if (operatedRole != EnumRoleName.viewer) break;
                    type = 4;
                }
            }
            if (type > 0 && type <= 4) {
                if (operatedRole == EnumRoleName.host) {
                    return interactiveMenus.get(type)[isManScreen ? 1 : 0];
                }
                return interactiveMenus.get(type)[1];
            }
        }
        return new int[0];
    }

    public static int[] parseMenuList(String operateRoleName, String operatedRoleName, boolean interactive) {
        EnumRoleName operateRole = EnumRoleName.getRole(operateRoleName);
        EnumRoleName operatedRole = EnumRoleName.getRole(operatedRoleName);
        if (operateRole != null && operatedRole != null) {
            int type = 0;
            switch (operateRole) {
                case host: {
                    if (operatedRole == EnumRoleName.host) {
                        type = 1;
                        break;
                    }
                    if (operatedRole == EnumRoleName.assistant) {
                        type = 2;
                        break;
                    }
                    if (operatedRole == EnumRoleName.guest) {
                        type = 3;
                        break;
                    }
                    if (operatedRole != EnumRoleName.viewer) break;
                    type = 4;
                    break;
                }
                case guest: {
                    if (operatedRole == EnumRoleName.host) {
                        type = 5;
                        break;
                    }
                    if (operatedRole == EnumRoleName.assistant) {
                        type = 6;
                        break;
                    }
                    if (operatedRole == EnumRoleName.guest) {
                        type = 7;
                        break;
                    }
                    if (operatedRole != EnumRoleName.viewer) break;
                    type = 8;
                    break;
                }
                case assistant: {
                    if (operatedRole == EnumRoleName.host) {
                        type = 9;
                        break;
                    }
                    if (operatedRole == EnumRoleName.assistant) {
                        type = 10;
                        break;
                    }
                    if (operatedRole == EnumRoleName.guest) {
                        type = 11;
                        break;
                    }
                    if (operatedRole != EnumRoleName.viewer) break;
                    type = 12;
                    break;
                }
                case viewer: {
                    if (operatedRole == EnumRoleName.host) {
                        type = 13;
                        break;
                    }
                    if (operatedRole == EnumRoleName.assistant) {
                        type = 14;
                        break;
                    }
                    if (operatedRole == EnumRoleName.guest) {
                        type = 15;
                        break;
                    }
                    if (operatedRole != EnumRoleName.viewer) break;
                    type = 16;
                }
            }
            if (type > 0 && type <= 16) {
                return menus.get(type)[interactive ? 1 : 0];
            }
        }
        return new int[0];
    }

    static {
        menus.put(1, new int[][]{{4}, new int[0]});
        menus.put(2, new int[][]{{5, 6}, {5, 6}});
        menus.put(3, new int[][]{{3, 5, 6}, {3, 1, 2, 4, 5, 6}});
        menus.put(4, new int[][]{{3, 5, 6}, {3, 1, 2, 4, 5, 6}});
        menus.put(5, new int[][]{new int[0], new int[0]});
        menus.put(6, new int[][]{new int[0], new int[0]});
        menus.put(7, new int[][]{new int[0], new int[0]});
        menus.put(8, new int[][]{new int[0], new int[0]});
        menus.put(9, new int[][]{new int[0], new int[0]});
        menus.put(10, new int[][]{new int[0], new int[0]});
        menus.put(11, new int[][]{{3, 5, 6}, new int[0]});
        menus.put(12, new int[][]{{3, 5, 6}, new int[0]});
        menus.put(13, new int[][]{new int[0], new int[0]});
        menus.put(14, new int[][]{new int[0], new int[0]});
        menus.put(15, new int[][]{new int[0], new int[0]});
        menus.put(16, new int[][]{new int[0], new int[0]});
        interactiveMenus.put(1, new int[][]{{4}, new int[0]});
        interactiveMenus.put(2, new int[][]{new int[0], new int[0]});
        interactiveMenus.put(3, new int[][]{new int[0], {1, 2, 3, 4}});
        interactiveMenus.put(4, new int[][]{new int[0], {1, 2, 3, 4}});
    }

    public static interface Menu {
        public static final int OPERATE_VIDEO = 1;
        public static final int OPERATE_AUDIO = 2;
        public static final int OPERATE_SPEAK = 3;
        public static final int OPERATE_MAIN_SCREEN = 4;
        public static final int OPERATE_BANNED = 5;
        public static final int OPERATE_KICK_OUT_LIVE = 6;
    }
}

