/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.core;

import android.os.Bundle;
import androidx.annotation.Nullable;
import com.vhall.appui.baselib.ServiceManager;
import com.vhall.appui.baselib.core.service.IBaseService;
import com.vhall.appui.baselib.core.service.IComponentEventListener;
import com.vhall.appui.baselib.core.service.IComponentsManager;
import com.vhall.appui.baselib.service.chat.ChatManager;

public abstract class SimpleManager<T extends IBaseService>
implements IComponentsManager {
    protected T service = (IBaseService)ServiceManager.getService(this.getComponentsName());

    @Override
    public String dump() {
        return this.getServiceInfo();
    }

    private String getServiceInfo() {
        return this.service == null ? String.format("%s components is no load ! please check your code", this.getComponentsName()) : String.format("%s version is %s", this.getComponentsName(), this.service.getVersion());
    }

    @Override
    public String getComponentsName() {
        return "unkonwn";
    }

    @Override
    public boolean isLoaded() {
        return ServiceManager.isEnableService(this.getComponentsName());
    }

    @Override
    public boolean isAddedChatInterceptor() {
        return ChatManager.getInstance().isAddedChatInterceptor(this.getComponentsName());
    }

    public Bundle call(String method, @Nullable String arg, @Nullable Bundle extras) {
        return this.service.call(method, arg, extras);
    }

    public void registerComponentEventListener(IComponentEventListener iComponentEventListener) {
        if (this.service != null) {
            this.service.registerComponentEventListener(iComponentEventListener);
        }
    }

    public void unregisterComponentEventListener(IComponentEventListener iComponentEventListener) {
        if (this.service != null) {
            this.service.unregisterComponentEventListener(iComponentEventListener);
        }
    }
}

