/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.bean;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.vhall.appui.baselib.service.login.IUser;
import java.io.Serializable;

public class User
implements IUser,
Serializable {
    private static final String DEFAULT_NICKNAME = "\u672a\u77e5";
    public String account_id = "";
    public String anchor_id = "";
    public String nick_name = "";
    public String phone = "";
    public String token = "";
    public String account_type;
    public String app_id;
    public String avatar;
    public String save_user_url;
    public int userStatus = -1;

    @Override
    public String getAccountId() {
        return this.account_id;
    }

    @Override
    public String getNickName() {
        return this.nick_name;
    }

    @Override
    public String getPhoneNum() {
        return this.phone;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public String getAvatar() {
        return this.avatar;
    }

    @Override
    public void setAccountId(String account_id) {
        this.account_id = account_id;
    }

    @Override
    public void setNickName(String nick_name) {
        this.nick_name = nick_name;
    }

    @Override
    public void setPhoneNum(String phone) {
        this.phone = phone;
    }

    @Override
    public void setToken(String token) {
        this.token = token;
    }

    @Override
    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public void setUserStatus(int userStatus) {
        this.userStatus = userStatus;
    }

    public User() {
    }

    public User(String account_id, String nickname) {
        this.account_id = account_id;
        this.nick_name = nickname;
    }

    public User(String account_id, String nickname, int userStatus) {
        this.account_id = account_id;
        this.nick_name = nickname;
        this.userStatus = userStatus;
    }

    public User(String account_id, String nickname, String phone, String token) {
        this.account_id = account_id;
        this.nick_name = nickname;
        this.phone = phone;
        this.token = token;
    }

    public static User getFromLocal(Context context) {
        User mUser = null;
        SharedPreferences sp = context.getSharedPreferences("user", 0);
        String userid = sp.getString("userid", "");
        if (!TextUtils.isEmpty((CharSequence)userid)) {
            String nickname = sp.getString("nickname", "");
            String phone = sp.getString("phone", "");
            String token = sp.getString("token", "");
            String avatar = sp.getString("avatar", "");
            mUser = new User(userid, nickname, phone, token);
            mUser.setAvatar(avatar);
        }
        return mUser;
    }

    public static void clearLocalInfo(Context context) {
        SharedPreferences sp = context.getSharedPreferences("user", 0);
        SharedPreferences.Editor editor = sp.edit();
        editor.clear();
        editor.commit();
    }

    public static void saveToLocal(IUser user, Context context) {
        SharedPreferences sp = context.getSharedPreferences("user", 0);
        SharedPreferences.Editor editor = sp.edit();
        editor.putString("avatar", user.getAvatar());
        editor.putString("userid", user.getAccountId());
        editor.putString("nickname", user.getNickName());
        editor.putString("phone", user.getPhoneNum());
        editor.putString("token", user.getToken());
        editor.commit();
    }

    public static String getNickname(String nickname) {
        return TextUtils.isEmpty((CharSequence)nickname) ? DEFAULT_NICKNAME : nickname;
    }

    public boolean equals(Object obj) {
        if (obj instanceof User) {
            User user = (User)obj;
            if (user.account_id.equals(this.account_id)) {
                return true;
            }
        }
        return false;
    }
}

