/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.base;

import android.content.Context;
import android.os.Bundle;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.vhall.appui.baselib.base.BaseActivity;
import com.vhall.appui.baselib.base.ILifeCycleController;
import com.vhall.appui.baselib.core.service.IBase;
import com.vhall.appui.baselib.core.service.IBaseEventListener;
import com.vhall.appui.baselib.utils.HookOnclickListerUtils;
import com.vhall.appui.baselib.utils.TextViewUtil;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public class IBaseViewImpl
extends FrameLayout
implements ILifeCycleController,
IBase {
    private CompositeDisposable mCompositeSubscription;
    protected IBaseEventListener mIBaseEventListener;
    private List<WeakReference<ILifeCycleController>> mLifeCycleControllers = new ArrayList<WeakReference<ILifeCycleController>>();

    public IBaseViewImpl(@NonNull Context context) {
        super(context);
        this.init();
    }

    public IBaseViewImpl(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public IBaseViewImpl(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public void init() {
        if (this.getContext() instanceof BaseActivity) {
            ((BaseActivity)this.getContext()).addLifeController(this);
        }
        HookOnclickListerUtils.getInstance().hookDecorViewClick((View)this);
        TextViewUtil.hookDecorViewClick(this.getContext(), (View)this);
    }

    @Override
    public void addSubscribe(Disposable disposable) {
        if (this.mCompositeSubscription == null) {
            this.mCompositeSubscription = new CompositeDisposable();
        }
        this.mCompositeSubscription.add(disposable);
    }

    @Override
    public void unSubscribe() {
        if (this.mCompositeSubscription != null && !this.mCompositeSubscription.isDisposed()) {
            this.mCompositeSubscription.dispose();
        }
        for (int i = this.mLifeCycleControllers.size() - 1; i >= 0; --i) {
            if (this.mLifeCycleControllers.get(i) != null && this.mLifeCycleControllers.get(i).get() != null) {
                ((ILifeCycleController)this.mLifeCycleControllers.get(i).get()).unSubscribe();
            }
            this.mLifeCycleControllers.remove(i);
        }
    }

    public void onEvent(String method, String args, Bundle extra) {
    }

    @Override
    public void addILifeCycleController(ILifeCycleController controller) {
        this.mLifeCycleControllers.add(new WeakReference<ILifeCycleController>(controller));
        for (int i = this.mLifeCycleControllers.size() - 1; i >= 0; --i) {
            if (this.mLifeCycleControllers.get(i) != null && this.mLifeCycleControllers.get(i).get() != null) continue;
            this.mLifeCycleControllers.remove(i);
        }
    }

    @Override
    public Bundle call(String method, @Nullable String arg, @Nullable Bundle extras) {
        return null;
    }

    @Override
    public void registerBaseEventListener(IBaseEventListener listener) {
        this.mIBaseEventListener = listener;
    }

    @Override
    public void unregisterBaseEventListener(IBaseEventListener listener) {
        this.mIBaseEventListener = null;
    }
}

