/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.base;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import com.vhall.appui.baselib.M;
import com.vhall.appui.baselib.R;
import com.vhall.appui.baselib.base.ILifeCycleController;
import com.vhall.appui.baselib.service.login.AccountManager;
import com.vhall.appui.baselib.utils.InternalUtils;
import com.vhall.appui.baselib.vss.utils.exception.ApiException;
import com.vhall.appui.baselib.vss.utils.exception.CustomException;
import com.vhall.appui.baselib.vss.utils.rxutils.IPresenter;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import java.util.HashMap;

public class CloudBasePresent
implements IPresenter,
ILifeCycleController {
    protected CompositeDisposable mCompositeSubscription;
    public static final int ERROR_CODE_LOGIN = 401;

    @Override
    public void addSubscribe(Disposable disposable) {
        if (this.mCompositeSubscription == null) {
            this.mCompositeSubscription = new CompositeDisposable();
        }
        this.mCompositeSubscription.add(disposable);
    }

    @Override
    public void subscribe() {
    }

    @Override
    public void unSubscribe() {
        if (this.mCompositeSubscription != null && !this.mCompositeSubscription.isDisposed()) {
            this.mCompositeSubscription.dispose();
        }
    }

    public static HashMap<String, String> getDefaultParam() {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("token", AccountManager.getInstance().getToken());
        param.put("from", "android");
        return param;
    }

    public String dealError(Throwable e, String tag) {
        String msg;
        if (!InternalUtils.isNetworkConnected((Context)M.context)) {
            return M.getString(R.string.base_net_work_error_please_retry);
        }
        if (e instanceof ApiException) {
            ApiException exception = CustomException.handleException(((ApiException)e).getCode(), e);
            msg = TextUtils.isEmpty((CharSequence)exception.getDisplayMessage()) ? exception.getMessage() : exception.getDisplayMessage();
            if (exception.getCode() == 401) {
                AccountManager.getInstance().logOut(new Bundle());
            }
        } else {
            msg = e.getMessage();
        }
        Log.e((String)tag, (String)msg);
        return msg;
    }

    @Override
    public void addILifeCycleController(ILifeCycleController controller) {
    }
}

