/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.base;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.vhall.appui.baselib.M;
import com.vhall.appui.baselib.base.ILifeCycleController;
import com.vhall.appui.baselib.core.service.IBase;
import com.vhall.appui.baselib.core.service.IBaseEventListener;
import com.vhall.appui.baselib.utils.DialogUtils;
import com.vhall.appui.baselib.utils.HookOnclickListerUtils;
import com.vhall.appui.baselib.utils.TextViewUtil;
import com.vhall.appui.baselib.utils.VHToast;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public class BaseFragment
extends Fragment
implements IBase {
    private List<WeakReference<ILifeCycleController>> mLifeCycleControllers = new ArrayList<WeakReference<ILifeCycleController>>();
    protected Activity mContext;
    private Dialog dialog;
    protected IBaseEventListener mIBaseEventListener;
    protected CompositeDisposable mCompositeSubscription;
    private boolean firstVisible = true;

    public void onAttach(Context context) {
        super.onAttach(context);
        this.mContext = (Activity)context;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        HookOnclickListerUtils.getInstance().hookDecorViewClick(this.getActivity().getWindow().getDecorView());
    }

    public void onResume() {
        super.onResume();
        TextViewUtil.hookDecorViewClick((Context)this.getActivity(), this.getView());
    }

    public void setUserVisibleHint(boolean isVisibleToUser) {
        super.setUserVisibleHint(isVisibleToUser);
        if (isVisibleToUser && this.firstVisible) {
            this.onFirstVisible();
            this.firstVisible = false;
        }
        if (this.firstVisible) {
            this.onVisible();
        } else {
            this.onUnVisible();
        }
    }

    public void onFirstVisible() {
    }

    public void onVisible() {
    }

    public void onUnVisible() {
    }

    protected void showLoadProgress() {
        this.showLoadProgress(false);
    }

    protected void showLoadProgress(boolean cancel) {
        try {
            if (this.dialog == null) {
                this.dialog = DialogUtils.showLoadingProgress((Context)this.getActivity(), cancel);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void hideLoadProgress() {
        if (this.dialog != null) {
            this.dialog.dismiss();
            this.dialog = null;
        }
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.dialog != null) {
            this.dialog.dismiss();
            this.dialog = null;
        }
        this.unSubscribeLifeCycle();
    }

    private void unSubscribeLifeCycle() {
        for (int i = this.mLifeCycleControllers.size() - 1; i >= 0; --i) {
            if (this.mLifeCycleControllers.get(i) == null || this.mLifeCycleControllers.get(i) == null) {
                this.mLifeCycleControllers.remove(i);
            }
            if (this.mLifeCycleControllers.get(i) == null || this.mLifeCycleControllers.get(i).get() == null) continue;
            ((ILifeCycleController)this.mLifeCycleControllers.get(i).get()).unSubscribe();
        }
        this.unSubscribe();
    }

    public void baseShowToast(String msg) {
        VHToast.showShortToast((Context)M.context, msg);
    }

    public void baseShowToast(int msg) {
        VHToast.showShortToast((Context)M.context, msg);
    }

    @Override
    public Bundle call(String method, @Nullable String arg, @Nullable Bundle extras) {
        return null;
    }

    @Override
    public void registerBaseEventListener(IBaseEventListener listener) {
        this.mIBaseEventListener = listener;
    }

    @Override
    public void unregisterBaseEventListener(IBaseEventListener callBack) {
        this.mIBaseEventListener = null;
    }

    public void addLifeCycleController(ILifeCycleController controller) {
        this.mLifeCycleControllers.add(new WeakReference<ILifeCycleController>(controller));
        for (int i = this.mLifeCycleControllers.size() - 1; i >= 0; --i) {
            if (this.mLifeCycleControllers.get(i) != null && this.mLifeCycleControllers.get(i) != null) continue;
            this.mLifeCycleControllers.remove(i);
        }
    }

    public void addSubscribe(Disposable disposable) {
        if (this.mCompositeSubscription == null) {
            this.mCompositeSubscription = new CompositeDisposable();
        }
        this.mCompositeSubscription.add(disposable);
    }

    public void unSubscribe() {
        if (this.mCompositeSubscription != null && !this.mCompositeSubscription.isDisposed()) {
            this.mCompositeSubscription.dispose();
        }
    }

    public int getExtraInt(String key, int defaultVal) {
        Bundle bundle = this.getArguments();
        if (bundle != null) {
            return bundle.getInt(key, defaultVal);
        }
        return defaultVal;
    }

    public void back() {
    }

    public void refreshRoom() {
    }
}

