/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.base;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import com.vhall.appui.baselib.R;
import com.vhall.appui.baselib.base.ILifeCycleController;
import com.vhall.appui.baselib.utils.DialogUtils;
import com.vhall.appui.baselib.utils.TextViewUtil;
import io.reactivex.disposables.Disposable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseBottomDialog
extends Dialog
implements ILifeCycleController {
    protected Context mContext;
    private Dialog dialog;
    private List<WeakReference<ILifeCycleController>> mLifeCycleControllers = new ArrayList<WeakReference<ILifeCycleController>>();

    public BaseBottomDialog(Context context) {
        super(context);
        this.mContext = context;
        this.init();
    }

    public void setContentView(int layoutResID) {
        View view = LayoutInflater.from((Context)this.getContext()).inflate(layoutResID, null);
        TextViewUtil.hookDecorViewClick(this.getContext(), view);
        super.setContentView(view);
    }

    public void show() {
        super.show();
    }

    protected void showLoadProgress() {
        this.showLoadProgress(false);
    }

    protected void showLoadProgress(boolean cancel) {
        try {
            Activity activity = (Activity)this.mContext;
            if (this.dialog == null && activity != null && !activity.isFinishing()) {
                this.dialog = DialogUtils.showLoadingProgress((Context)activity, cancel);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void hideLoadProgress() {
        if (this.dialog != null) {
            this.dialog.dismiss();
            this.dialog = null;
        }
    }

    protected void init() {
        Window win = this.getWindow();
        win.getDecorView().setPadding(0, 0, 0, 0);
        WindowManager.LayoutParams lp = win.getAttributes();
        lp.width = -1;
        lp.height = -1;
        lp.windowAnimations = R.style.DialogBottomInAndOutStyle;
        lp.gravity = 0x800055;
        win.setAttributes(lp);
        win.setBackgroundDrawableResource(17170445);
        this.onWindowAttributesChanged(lp);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Override
    public void addSubscribe(Disposable disposable) {
    }

    public void dismiss() {
        super.dismiss();
        this.unSubscribeLifeCycle();
        this.hideLoadProgress();
    }

    @Override
    public void unSubscribe() {
        for (int i = this.mLifeCycleControllers.size() - 1; i >= 0; --i) {
            if (this.mLifeCycleControllers.get(i) == null || this.mLifeCycleControllers.get(i) == null) {
                this.mLifeCycleControllers.remove(i);
            }
            if (this.mLifeCycleControllers.get(i) == null || this.mLifeCycleControllers.get(i).get() == null) continue;
            ((ILifeCycleController)this.mLifeCycleControllers.get(i).get()).unSubscribe();
        }
    }

    @Override
    public void addILifeCycleController(ILifeCycleController controller) {
        this.mLifeCycleControllers.add(new WeakReference<ILifeCycleController>(controller));
        for (int i = this.mLifeCycleControllers.size() - 1; i >= 0; --i) {
            if (this.mLifeCycleControllers.get(i) != null && this.mLifeCycleControllers.get(i) != null) continue;
            this.mLifeCycleControllers.remove(i);
        }
    }

    private void unSubscribeLifeCycle() {
        for (int i = this.mLifeCycleControllers.size() - 1; i >= 0; --i) {
            if (this.mLifeCycleControllers.get(i) == null || this.mLifeCycleControllers.get(i) == null) {
                this.mLifeCycleControllers.remove(i);
            }
            if (this.mLifeCycleControllers.get(i) == null || this.mLifeCycleControllers.get(i).get() == null) continue;
            ((ILifeCycleController)this.mLifeCycleControllers.get(i).get()).unSubscribe();
        }
    }
}

