/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.base;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import com.vhall.appui.baselib.M;
import com.vhall.appui.baselib.R;
import com.vhall.appui.baselib.VhSdk;
import com.vhall.appui.baselib.base.ILifeCycleController;
import com.vhall.appui.baselib.core.service.IBase;
import com.vhall.appui.baselib.core.service.IBaseEventListener;
import com.vhall.appui.baselib.service.language.LanguageManager;
import com.vhall.appui.baselib.service.pictureinpicture.PictureInPictureConstance;
import com.vhall.appui.baselib.utils.ActivityCollector;
import com.vhall.appui.baselib.utils.DialogUtils;
import com.vhall.appui.baselib.utils.HookOnclickListerUtils;
import com.vhall.appui.baselib.utils.StatusBarUtil;
import com.vhall.appui.baselib.utils.TextViewUtil;
import com.vhall.appui.baselib.utils.ToastUtil;
import com.vhall.appui.baselib.utils.VHToast;
import com.vhall.appui.baselib.utils.VhLog;
import com.vhall.appui.livepreview.LivePreviewActivity;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public abstract class BaseActivity
extends AppCompatActivity
implements IBase {
    private List<WeakReference<ILifeCycleController>> mLifeCycleControllers = new ArrayList<WeakReference<ILifeCycleController>>();
    protected Context mContext;
    private Dialog dialog;
    protected IBaseEventListener mBaseEventCallBack;
    protected CompositeDisposable mCompositeSubscription;
    private boolean setLanguage = false;
    protected boolean isSign = false;
    protected boolean isSignOver = false;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.isHoldLightScreen()) {
            this.holdLightScreenInternal();
        }
        if (this.hintBar()) {
            this.supportRequestWindowFeature(1);
            if (this.getSupportActionBar() != null) {
                this.getSupportActionBar().hide();
            }
        }
        this.setContentView(this.getLayoutId());
        this.mContext = this;
        VhSdk.getInstance().addActivity(this);
        this.initView();
        this.initData();
        ActivityCollector.addActivity((Activity)this);
        HookOnclickListerUtils.getInstance().hookDecorViewClick(this.getWindow().getDecorView());
        TextViewUtil.hookDecorViewClick((Context)this, this.getWindow().getDecorView());
    }

    public void showToast(String message) {
        ToastUtil.showToast(this.mContext, message, this.getWindow().getDecorView());
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        Log.e((String)"LocaleChangeReceiver", (String)"onConfigurationChanged");
        Log.e((String)"LocaleChangeReceiver", (String)Locale.getDefault().getLanguage());
    }

    protected void attachBaseContext(Context base) {
        super.attachBaseContext(LanguageManager.attachBaseContext(base));
    }

    private void setStatusBar() {
        if (Build.VERSION.SDK_INT >= 23) {
            if (this.hintBar()) {
                return;
            }
            if (this.isUseFullScreenMode()) {
                StatusBarUtil.transparencyBar((Activity)this);
            } else {
                StatusBarUtil.setStatusBarColor((Activity)this, this.getStatusBarColor());
            }
            if (this.isUseBlackFontWithStatusBar()) {
                StatusBarUtil.setLightStatusBar((Activity)this, true, this.isUseFullScreenMode());
            }
        }
    }

    public boolean isHoldLightScreen() {
        return false;
    }

    private void holdLightScreenInternal() {
        this.getWindow().setFlags(128, 128);
    }

    protected boolean isUseFullScreenMode() {
        return true;
    }

    protected boolean hintBar() {
        return false;
    }

    protected int getStatusBarColor() {
        return R.color.white;
    }

    protected boolean isUseBlackFontWithStatusBar() {
        return true;
    }

    protected abstract int getLayoutId();

    protected abstract void initView();

    protected abstract void initData();

    protected void showLoadProgress() {
        this.showLoadProgress(false);
    }

    protected void showLoadProgress(boolean cancel) {
        try {
            if (this.dialog == null) {
                this.dialog = DialogUtils.showLoadingProgress((Context)this, cancel);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void hideLoadProgress() {
        if (this.dialog != null) {
            this.dialog.dismiss();
            this.dialog = null;
        }
    }

    protected void onResume() {
        super.onResume();
        PictureInPictureConstance.activity = this;
        try {
            if (!(this instanceof LivePreviewActivity)) {
                VhSdk.getInstance().closePIPView((Context)this);
            }
        }
        catch (Exception e) {
            VhLog.d(e.getMessage());
        }
    }

    public boolean moveTaskToBack(boolean nonRoot) {
        return super.moveTaskToBack(nonRoot);
    }

    protected void onPause() {
        super.onPause();
        PictureInPictureConstance.activity = null;
    }

    protected void onDestroy() {
        VhSdk.getInstance().removeActivity(this);
        super.onDestroy();
        if (this.dialog != null) {
            this.dialog.dismiss();
            this.dialog = null;
        }
        ActivityCollector.removeActivity((Activity)this);
        this.unSubscribeLifeCycle();
    }

    public void baseShowToast(String msg) {
        VHToast.showShortToast((Context)M.context, msg);
    }

    @Override
    public Bundle call(String method, @Nullable String arg, @Nullable Bundle extras) {
        return null;
    }

    @Override
    public void registerBaseEventListener(IBaseEventListener listener) {
        this.mBaseEventCallBack = listener;
    }

    @Override
    public void unregisterBaseEventListener(IBaseEventListener listener) {
        this.mBaseEventCallBack = null;
    }

    private void unSubscribeLifeCycle() {
        for (int i = this.mLifeCycleControllers.size() - 1; i >= 0; --i) {
            if (this.mLifeCycleControllers.get(i) == null || this.mLifeCycleControllers.get(i).get() == null) {
                this.mLifeCycleControllers.remove(i);
            }
            if (this.mLifeCycleControllers.get(i) == null || this.mLifeCycleControllers.get(i).get() == null) continue;
            ((ILifeCycleController)this.mLifeCycleControllers.get(i).get()).unSubscribe();
        }
        this.unSubscribe();
    }

    public void addLifeController(ILifeCycleController controller) {
        this.mLifeCycleControllers.add(new WeakReference<ILifeCycleController>(controller));
        for (int i = this.mLifeCycleControllers.size() - 1; i >= 0; --i) {
            if (this.mLifeCycleControllers.get(i) != null && this.mLifeCycleControllers.get(i).get() != null) continue;
            this.mLifeCycleControllers.remove(i);
        }
    }

    public void addSubscribe(Disposable disposable) {
        if (this.mCompositeSubscription == null) {
            this.mCompositeSubscription = new CompositeDisposable();
        }
        this.mCompositeSubscription.add(disposable);
    }

    public void unSubscribe() {
        if (this.mCompositeSubscription != null && !this.mCompositeSubscription.isDisposed()) {
            this.mCompositeSubscription.dispose();
        }
    }

    public String getExtraString(String name) {
        Bundle bundle = this.getExtraBundle();
        if (bundle != null) {
            return bundle.getString(name);
        }
        return "";
    }

    public Serializable getExtraSerializable(String name) {
        Bundle bundle = this.getExtraBundle();
        if (bundle != null) {
            return bundle.getSerializable(name);
        }
        return "";
    }

    public Bundle getExtraBundle() {
        return this.getIntent().getBundleExtra("extra");
    }
}

