/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib;

import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import com.vhall.appui.baselib.CommonManager;
import com.vhall.appui.baselib.M;
import com.vhall.appui.baselib.base.BaseActivity;
import com.vhall.appui.baselib.base.IBaseConfig;
import com.vhall.appui.baselib.bean.User;
import com.vhall.appui.baselib.callback.VhCallBack;
import com.vhall.appui.baselib.callback.VhallCallback;
import com.vhall.appui.baselib.net.CloudApiConstant;
import com.vhall.appui.baselib.net.utils.CoreNetCallback;
import com.vhall.appui.baselib.service.livepreview.LivePreviewManager;
import com.vhall.appui.baselib.service.login.AccountManager;
import com.vhall.appui.baselib.service.pictureinpicture.PictureInPictureConstance;
import com.vhall.appui.baselib.service.pictureinpicture.PictureInPictureManager;
import com.vhall.appui.baselib.service.watchlive.WatchVerticalLiveManager;
import com.vhall.appui.baselib.utils.VHToast;
import com.vhall.appui.baselib.utils.VhLog;
import com.vhall.appui.baselib.utils.VhSpUtils;
import com.vhall.appui.baselib.vss.CallBack;
import com.vhall.appui.baselib.vss.VssSdk;
import com.vhall.appui.baselib.vss.data.InavGetRoomInfo;
import com.vhall.appui.baselib.vss.data.RoomInfo;
import com.vhall.appui.baselib.vss.module.room.VssRoomManager;
import com.vhall.appui.loginview.UserManager;
import com.vhall.appui.main.network.MainListWrapper;
import com.vhall.appui.watchverticallive.WatchVerticalLiveActivity;
import com.vhall.framework.VhallSDK;
import java.io.Serializable;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.json.JSONException;
import org.json.JSONObject;

public class VhSdk {
    public boolean DEBUG = false;
    private static volatile VhSdk vhSdk;
    public boolean lastActivity;
    private String buildTime = "2022-01-07";
    private boolean initialize = false;
    private long lastClickTime = 0L;
    private final int FAST_CLICK_DELAY_TIME = 2000;
    private List<BaseActivity> activities = new ArrayList<BaseActivity>();
    private String appId = "";
    private String hostUrl = "";
    private String appSecretKey = "";
    public String member_id = "";
    public String phone = "";
    public VhallCallback vhallCallback;

    public void setUserInfo(String member_id, String phone) {
        this.member_id = member_id;
        this.phone = phone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static VhSdk getInstance() {
        if (vhSdk != null) return vhSdk;
        Class<VhSdk> clazz = VhSdk.class;
        synchronized (VhSdk.class) {
            if (vhSdk != null) return vhSdk;
            vhSdk = new VhSdk();
            // ** MonitorExit[var0] (shouldn't be in output)
            return vhSdk;
        }
    }

    private VhSdk() {
    }

    public void addActivity(BaseActivity activity) {
        try {
            if (activity == null || this.activities == null) {
                return;
            }
            if (this.activities.contains(activity)) {
                this.activities.add(this.activities.indexOf(activity), activity);
            } else {
                this.activities.add(activity);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void removeActivity(BaseActivity activity) {
        try {
            if (activity == null || this.activities == null) {
                return;
            }
            if (this.activities.contains(activity)) {
                this.activities.remove(activity);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getUUID(Context context) {
        String uuids;
        String uuidStr = "";
        String uuid = UUID.randomUUID().toString();
        boolean adidasUUID = VhSpUtils.contains(context, "adidasUUID");
        if (adidasUUID) {
            uuids = VhSpUtils.get(context, "adidasUUID", "");
            if (TextUtils.isEmpty((CharSequence)uuids)) {
                VhSpUtils.put(context, "adidasUUID", uuid);
            }
        } else {
            VhSpUtils.put(context, "adidasUUID", uuid);
        }
        uuids = VhSpUtils.get(context, "adidasUUID", "");
        if (!TextUtils.isEmpty((CharSequence)uuids)) {
            uuidStr = uuids;
        }
        return uuidStr;
    }

    public void init(Application context, String appId, String appSecretKey, String hostUrl, final VhallCallback vhallCallback) {
        this.member_id = VhSdk.getUUID((Context)context);
        VhLog.d(this.member_id + "  \u552f\u4e00\u6807\u8bc6 init");
        VhLog.d(this.getVHSDKVersion() + "   VHSDKVersion");
        M.context = context;
        this.vhallCallback = vhallCallback;
        this.appId = appId;
        this.hostUrl = hostUrl;
        this.appSecretKey = appSecretKey;
        CloudApiConstant.SECRET_KEY = appSecretKey;
        CloudApiConstant.API_HOST = hostUrl;
        CloudApiConstant.APP_ID = appId;
        CloudApiConstant.APPVERSION = this.getVHSDKVersion();
        UserManager.onCreate((Context)context);
        VhLog.d(" VssSdk init ");
        VssSdk.getInstance().init((Context)context, appId, AccountManager.getInstance().getUserId(), hostUrl, new VhCallBack(){

            @Override
            public void success() {
                VhSdk.this.initialize = true;
                vhallCallback.onRegisterResult(true);
            }

            @Override
            public void error(String message) {
                VhSdk.this.initialize = false;
                vhallCallback.onRegisterResult(false);
            }
        });
        VhLog.d(" CommonManager init ");
        CommonManager.getInstance(context).init();
        CommonManager.getInstance(context).setDebug(false);
        CommonManager.getInstance(context).setBaseConfig(new IBaseConfig(){

            @Override
            public String getHost() {
                return VhSdk.this.hostUrl;
            }

            @Override
            public String getWeb_host() {
                return "";
            }

            @Override
            public String getSecret_key() {
                return VhSdk.this.appSecretKey;
            }

            @Override
            public String getAppId() {
                return VhSdk.this.appId;
            }

            @Override
            public String getBuildTime() {
                return VhSdk.this.buildTime;
            }

            @Override
            public String getLanguage() {
                return "zh";
            }

            @Override
            public String getPlatform() {
                return "4";
            }

            @Override
            public String getStack_type() {
                return "0";
            }
        });
    }

    public boolean isInitialize() {
        try {
            if (VhallSDK.getInstance().isEnable() && this.initialize) {
                return true;
            }
            this.initialize = false;
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.initialize = false;
            return false;
        }
    }

    public void enterRoom(Context context, String roomId, String loginId, String phone) {
        try {
            if (this.avoidRepeatClick()) {
                VhLog.d("\u8fde\u7eed\u70b9\u51fb enterRoom");
                return;
            }
            this.lastClickTime = System.currentTimeMillis();
            if (context == null || TextUtils.isEmpty((CharSequence)roomId)) {
                VhLog.d("context == null || roomId == null");
                return;
            }
            if (TextUtils.isEmpty((CharSequence)phone)) {
                phone = "";
            }
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("il_id", roomId);
            param.put("phone", phone);
            this.phone = phone;
            if (!TextUtils.isEmpty((CharSequence)loginId)) {
                this.member_id = loginId;
                param.put("type", "2");
            } else {
                param.put("type", "3");
            }
            param.put("member_id", this.member_id);
            this.visitorLogin(context, param, roomId, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void refreshRoom(WatchVerticalLiveActivity context, String roomId, String loginId, String phone) {
        try {
            if (this.avoidRepeatClick()) {
                VhLog.d("\u8fde\u7eed\u70b9\u51fb enterRoom");
                return;
            }
            this.lastClickTime = System.currentTimeMillis();
            if (context == null || TextUtils.isEmpty((CharSequence)roomId)) {
                VhLog.d("context == null || roomId == null");
                return;
            }
            if (TextUtils.isEmpty((CharSequence)phone)) {
                phone = "";
            } else if (phone.contains("+")) {
                phone = phone.replace("+", "");
            }
            VssRoomManager.getInstance().leaveRoom(null, null);
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("il_id", roomId);
            param.put("phone", phone);
            this.phone = phone;
            if (!TextUtils.isEmpty((CharSequence)loginId)) {
                this.member_id = loginId;
                param.put("type", "2");
            } else {
                param.put("type", "3");
            }
            param.put("member_id", this.member_id);
            this.visitorLogin((Context)context, param, roomId, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void visitorLogin(final Context context, HashMap param, final String roomId, final boolean isRefresh) {
        MainListWrapper.visitorLogin(param, new CoreNetCallback(new CallBack<String>(){

            @Override
            public void onSuccess(String result) {
                VhLog.d(result);
                try {
                    JSONObject jsonObject = new JSONObject(result);
                    JSONObject data = jsonObject.optJSONObject("data");
                    String nick_name = data.optString("nick_name");
                    String account_id = data.optString("account_id");
                    String token = data.optString("token");
                    User user = new User(account_id, nick_name, "", token);
                    UserManager.refreshUser(user);
                    VhSdk.this.getRoomInfo(context, roomId, isRefresh);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                VhLog.d(msg);
                VHToast.showLongToast(context, msg);
            }
        }));
    }

    public void getRoomInfo(final Context context, final String ilid, final boolean isRefresh) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("il_id", ilid);
        param.put("role_name", "2");
        MainListWrapper.getRoomInfo(param, new CoreNetCallback<InavGetRoomInfo>(new CallBack<InavGetRoomInfo>(){

            @Override
            public void onSuccess(InavGetRoomInfo inavGetRoomInfo) {
                PictureInPictureConstance.INAVGETROOMINFO = inavGetRoomInfo;
                VhSdk.this.dealRoomResult(context, inavGetRoomInfo, ilid, isRefresh);
            }

            @Override
            public void onError(int eventCode, String msg) {
                VhLog.d(msg);
                VHToast.showLongToast(context, msg);
            }
        }, InavGetRoomInfo.class));
    }

    public void dealRoomResult(Context context, InavGetRoomInfo s, String ilid, boolean isRefresh) {
        if (!isRefresh) {
            for (int i = 0; i < this.activities.size(); ++i) {
                this.activities.get(i).finish();
            }
            RoomInfo info = s.getRoom_info();
            Bundle bundle = new Bundle();
            bundle.putSerializable("extra", (Serializable)s);
            bundle.putString("room_id", ilid);
            bundle.putString("role_name", "2");
            if (LivePreviewManager.getInstance().isLoaded()) {
                LivePreviewManager.getInstance().showPreview(context, bundle);
            }
        } else {
            try {
                Bundle bundle = new Bundle();
                bundle.putSerializable("extra", (Serializable)s);
                WatchVerticalLiveManager.getInstance().refreshRoom((WatchVerticalLiveActivity)context, bundle);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private boolean avoidRepeatClick() {
        boolean flag = true;
        long currentClickTime = System.currentTimeMillis();
        if (currentClickTime - this.lastClickTime >= 2000L) {
            flag = false;
        }
        return flag;
    }

    public String getVHSDKVersion() {
        if (TextUtils.isEmpty((CharSequence)"1.2.9")) {
            return "1.1.2";
        }
        return "1.2.9";
    }

    public void closePIPView(Context context) {
        try {
            PictureInPictureManager.getInstance().stopService(context);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void handleSSLHandshake() {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

