/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib;

import android.graphics.Rect;
import android.view.View;
import androidx.recyclerview.widget.RecyclerView;
import com.vhall.appui.baselib.utils.DensityUtils;

public class SpacesItemDecoration
extends RecyclerView.ItemDecoration {
    private int bottom;
    private int left;
    private int right;
    private int top;

    public SpacesItemDecoration(int bottom, int left) {
        this.bottom = (int)DensityUtils.dpToPx(bottom);
        this.left = DensityUtils.dpToPxInt(left);
    }

    public SpacesItemDecoration(int top, int bottom, int left, int right) {
        this.bottom = (int)DensityUtils.dpToPx(bottom);
        this.left = DensityUtils.dpToPxInt(left);
        this.top = DensityUtils.dpToPxInt(top);
        this.right = DensityUtils.dpToPxInt(right);
    }

    public SpacesItemDecoration(int bottom, int left, int right) {
        this.bottom = (int)DensityUtils.dpToPx(bottom);
        this.left = DensityUtils.dpToPxInt(left);
        this.right = DensityUtils.dpToPxInt(right);
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        outRect.left = parent.getChildPosition(view) != 0 && this.left == 4 ? 0 : this.left;
        outRect.bottom = this.bottom;
        if (this.right > 0) {
            outRect.right = this.right;
        }
        if (this.top > 0) {
            outRect.top = this.top;
        }
    }
}

