/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib;

import android.app.Application;
import android.content.pm.ApplicationInfo;
import android.os.Bundle;
import android.text.TextUtils;
import com.vhall.appui.baselib.M;
import com.vhall.appui.baselib.base.IBaseConfig;
import com.vhall.appui.baselib.core.service.IBaseComponent;
import com.vhall.appui.baselib.utils.VHMMKV;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public final class CommonManager {
    private Application instance;
    private boolean isDebug;
    private static volatile CommonManager manager;
    private IBaseConfig iBaseConfig;
    private static final String COMPONENT_ENTRY = "vhall_componentEntry";
    private List<IBaseComponent> modules = new ArrayList<IBaseComponent>();

    public void setBaseConfig(IBaseConfig config) {
        this.iBaseConfig = config;
    }

    public IBaseConfig getBaseConfig() {
        return this.iBaseConfig != null ? this.iBaseConfig : new IBaseConfig.SimpleConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CommonManager getInstance(Application application) {
        if (null != manager) return manager;
        Class<CommonManager> clazz = CommonManager.class;
        synchronized (CommonManager.class) {
            if (null != manager) return manager;
            manager = new CommonManager(application);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return manager;
        }
    }

    private CommonManager(Application application) {
        M.context = this.instance = application;
    }

    public void init() {
        VHMMKV.init(this.instance);
        this.initComponents(this.instance);
        this.onComponentCreate();
        this.onComponentLoaded();
    }

    public void setDebug(boolean debug) {
        this.isDebug = debug;
    }

    private void initComponents(Application application) {
        try {
            this.modules.clear();
            ApplicationInfo info = application.getPackageManager().getPackageInfo((String)application.getPackageName(), (int)128).applicationInfo;
            Bundle metaData = info.metaData;
            for (Object component : metaData.keySet()) {
                if (!(component instanceof String) || !TextUtils.equals((CharSequence)metaData.getString((String)component), (CharSequence)COMPONENT_ENTRY)) continue;
                this.modules.add((IBaseComponent)Class.forName((String)component).newInstance());
            }
            Collections.sort(this.modules, new Comparator<IBaseComponent>(){

                @Override
                public int compare(IBaseComponent o1, IBaseComponent o2) {
                    if (o1.getPriority() > o2.getPriority()) {
                        return -1;
                    }
                    if (o1.getPriority() < o2.getPriority()) {
                        return 1;
                    }
                    return 0;
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void onComponentCreate() {
        for (IBaseComponent component : this.modules) {
            component.onComponentCreate(this.instance);
        }
    }

    void onComponentLoaded() {
        for (IBaseComponent component : this.modules) {
            component.onComponentLoaded();
        }
    }
}

