/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Shader;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.vhall.appui.VhViewAdapter;
import com.vhall.appui.baselib.utils.DensityUtils;

public class VhAdverView
extends LinearLayout {
    private float mAdverHeight = 30.0f;
    private final int mGap = 2000;
    private final int mAnimDuration = 1000;
    private final float TEXTSIZE = 13.0f;
    private VhViewAdapter mAdapter;
    private final float jdAdverHeight = 50.0f;
    private View mFirstView;
    private View mSecondView;
    private int mPosition;
    private boolean isStarted;
    private Paint mPaint;
    private int flag;
    private AnimRunnable mRunnable = new AnimRunnable();
    private LinearGradient linearGradient;
    private boolean inits = false;

    public VhAdverView(Context context) {
        this(context, null);
    }

    public VhAdverView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public VhAdverView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        this.setOrientation(1);
        this.mPaint = new Paint();
        this.setLayerType(1, null);
    }

    public void setAdapter(VhViewAdapter adapter, int flag) {
        this.mAdapter = adapter;
        this.setupAdapter(flag);
    }

    public void start() {
        this.stop();
        if (!this.isStarted && this.mAdapter.getCount() > 1) {
            this.isStarted = true;
            this.postDelayed(this.mRunnable, 1000L);
        }
    }

    public void stop() {
        this.removeCallbacks(this.mRunnable);
        this.isStarted = false;
    }

    private void setupAdapter(int flag) {
        this.flag = flag;
        this.removeAllViews();
        if (this.mAdapter.getCount() == 1) {
            this.mFirstView = this.mAdapter.getView(this);
            this.mAdapter.setItem(this.mFirstView, this.mAdapter.getItem(0), flag);
            this.addView(this.mFirstView, -2, DensityUtils.dpToPxInt(20.0f));
        } else {
            this.mFirstView = this.mAdapter.getView(this);
            this.mSecondView = this.mAdapter.getView(this);
            this.mAdapter.setItem(this.mFirstView, this.mAdapter.getItem(0), flag);
            this.mAdapter.setItem(this.mSecondView, this.mAdapter.getItem(1), flag);
            this.addView(this.mFirstView, -2, DensityUtils.dpToPxInt(20.0f));
            this.addView(this.mSecondView, -2, DensityUtils.dpToPxInt(20.0f));
            this.mPosition = 1;
            this.isStarted = false;
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        LinearLayout.LayoutParams layoutParams;
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (-2 == this.getLayoutParams().height) {
            this.getLayoutParams().height = (int)this.mAdverHeight;
        } else {
            this.mAdverHeight = this.getHeight();
        }
        ViewGroup.LayoutParams viewParams = this.getLayoutParams();
        if (viewParams instanceof LinearLayout.LayoutParams) {
            LinearLayout.LayoutParams linear = (LinearLayout.LayoutParams)viewParams;
            if (this.flag == 1) {
                linear.gravity = 80;
                linear.topMargin = 18;
                linear.bottomMargin = 0;
            } else if (this.flag == 2) {
                linear.gravity = 16;
                linear.topMargin = 0;
                linear.bottomMargin = 0;
            } else {
                linear.gravity = 48;
                linear.bottomMargin = 18;
                linear.topMargin = 0;
            }
        }
        if (viewParams instanceof ConstraintLayout.LayoutParams) {
            ConstraintLayout.LayoutParams constrain = (ConstraintLayout.LayoutParams)viewParams;
            if (this.flag == 1) {
                constrain.topMargin = 18;
                constrain.bottomMargin = 0;
            } else if (this.flag == 2) {
                constrain.topMargin = 0;
                constrain.bottomMargin = 0;
            } else {
                constrain.bottomMargin = 18;
                constrain.topMargin = 0;
            }
        }
        if (this.mFirstView != null) {
            layoutParams = (LinearLayout.LayoutParams)this.mFirstView.getLayoutParams();
            this.mFirstView.getLayoutParams().height = (int)this.mAdverHeight;
            layoutParams.gravity = this.flag == 1 ? 80 : (this.flag == 2 ? 16 : 48);
        }
        if (this.mSecondView != null) {
            layoutParams = (LinearLayout.LayoutParams)this.mFirstView.getLayoutParams();
            this.mSecondView.getLayoutParams().height = (int)this.mAdverHeight;
            layoutParams.gravity = this.flag == 1 ? 80 : (this.flag == 2 ? 16 : 48);
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.mPaint.setColor(-16777216);
        this.mPaint.setTextSize(TypedValue.applyDimension((int)2, (float)13.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()));
        this.mPaint.setStyle(Paint.Style.STROKE);
        canvas.drawText("", 13.0f, (float)(this.getHeight() * 2 / 3), this.mPaint);
    }

    private void performSwitch() {
        ObjectAnimator animator1 = ObjectAnimator.ofFloat((Object)this.mFirstView, (String)"translationY", (float[])new float[]{this.mFirstView.getTranslationY() - this.mAdverHeight});
        ObjectAnimator animator2 = ObjectAnimator.ofFloat((Object)this.mSecondView, (String)"translationY", (float[])new float[]{this.mSecondView.getTranslationY() - this.mAdverHeight});
        AnimatorSet set = new AnimatorSet();
        set.playTogether(new Animator[]{animator1, animator2});
        set.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                VhAdverView.this.mFirstView.setTranslationY(0.0f);
                VhAdverView.this.mSecondView.setTranslationY(0.0f);
                View removedView = VhAdverView.this.getChildAt(0);
                VhAdverView.this.mPosition++;
                VhAdverView.this.mAdapter.setItem(removedView, VhAdverView.this.mAdapter.getItem(VhAdverView.this.mPosition % VhAdverView.this.mAdapter.getCount()), VhAdverView.this.flag);
                VhAdverView.this.removeView(removedView);
                VhAdverView.this.addView(removedView, 1);
            }
        });
        set.setDuration(1000L);
        set.start();
    }

    public void setPaint(LinearGradient linearGradient) {
        if (linearGradient != null) {
            this.linearGradient = linearGradient;
            this.mPaint.setShader((Shader)linearGradient);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.stop();
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
    }

    private class AnimRunnable
    implements Runnable {
        private AnimRunnable() {
        }

        @Override
        public void run() {
            if (!VhAdverView.this.inits) {
                VhAdverView.this.inits = true;
                VhAdverView.this.performSwitch();
                VhAdverView.this.postDelayed(this, 0L);
            } else {
                VhAdverView.this.performSwitch();
                VhAdverView.this.postDelayed(this, 2000L);
            }
        }
    }
}

