package com.vhall.lss.play;

import static com.vhall.lss.VHLssApi.TYPE_ROOM;
import static com.vhall.lss.VHLssApi.TYPE_STREAM_CONVERT;
import static com.vhall.lss.VHLssApi.TYPE_STREAM_START;
import static com.vhall.lss.VHLssApi.TYPE_STREAM_STOP;
import static com.vhall.player.Constants.Event.EVENT_NO_STREAM;
import static com.vhall.player.Constants.Event.EVENT_STREAM_STOP;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.view.Gravity;
import android.view.SurfaceView;

import com.vhall.framework.VhallSDK;
import com.vhall.framework.connect.IVHService;
import com.vhall.framework.connect.VhallConnectService;
import com.vhall.logmanager.L;
import com.vhall.logmanager.LogInfo;
import com.vhall.logmanager.LogReporter;
import com.vhall.lss.VHLssApi;
import com.vhall.message.ConnectServer;
import com.vhall.player.Constants;
import com.vhall.player.MPlayer;
import com.vhall.player.VHPlayer;
import com.vhall.player.VHPlayerListener;
import com.vhall.player.stream.play.IVHAudioPlayer;
import com.vhall.player.stream.play.IVHVideoPlayer;
import com.vhall.player.stream.play.impl.VHVideoPlayerView;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;

import javax.net.ssl.HttpsURLConnection;

import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;

public class VHLivePlayer implements VHPlayer, IVHService {
    private static final String TAG = "VHLivePlayer";

    private MPlayer mPlayer;

    private boolean mLoading = false;

    private VHPlayerListener mListener;

    private Handler mDispatcher;

    private String mRoomId;
    private String mAccessToken;
    private String mDispatchURL;
    private String mDefaultURLS;
    private String waterMarkUrl = "";
    private float waterMarkAlpha = 1f;
    private int waterMarkGravity = 0;
    private IVHVideoPlayer videoPlayer;
    private Context mContext;
    private boolean enable_projection_screen = true;
    private String mCDNPriority = "";
    private boolean is_default_live_subtitle = false;
    private boolean is_live_subtitle = is_default_live_subtitle;
    private int live_subtitle = 0;
    private String live_subtitle_mps = "";

    private VhallConnectService.OnConnectStateChangedListener mOnConnectChangedListener;

    /**
     * 看直播观看参数设置
     */

    public void setOnConnectChangedListener(VhallConnectService.OnConnectStateChangedListener listener) {
        mOnConnectChangedListener = listener;
    }

    private VHLivePlayer() {
        mPlayer = new MPlayer(null, MPlayer.PLAYER_TYPE_LIVE);
        mDispatcher = new Handler(Looper.getMainLooper());
    }

    public void start(String roomId, String accessToken) {
        if (TextUtils.isEmpty(roomId) || TextUtils.isEmpty(accessToken)) {
            L.e(TAG, "roomId or accessToken should not be null");
            return;
        }
        if (mPlayer.getState() == Constants.State.START) {
            L.e(TAG, "player has already started");
            return;
        }
        disPatchURL(roomId, accessToken);
    }

    @Override
    public Constants.State getState() {
        return mPlayer.getState();
    }

    @Override
    public void setDisplay(SurfaceView surfaceView) {

    }

    @Override
    public void startPlay(String s) {
        mPlayer.startPlay(s);
    }

    public boolean resumeAble() {
        return !TextUtils.isEmpty(mDispatchURL);
    }

    public void setDPI(String dpi) {
        mPlayer.setDefinition(dpi);
    }
    //设置默认实时字幕状态,整体实时字幕开关
    public void setDefaultRealtimeSubtitle(boolean open_live_subtitle) {
        is_default_live_subtitle = open_live_subtitle;
        is_live_subtitle = open_live_subtitle;
    }
    //设置实时字幕开启状态,整体实时字幕开关，如果微吼实时字幕、TX实时字幕 都没有设置也无效
    public void setRealtimeSubtitle(boolean open_live_subtitle) {
        is_live_subtitle = open_live_subtitle;
        if(!TextUtils.isEmpty(live_subtitle_mps)){
            mPlayer.setLiveSubtitleMPS((is_live_subtitle && !TextUtils.isEmpty(live_subtitle_mps))?mPlayer.mDispatcher.live_subtitle_mps:"");
        }else if(live_subtitle == 1){
            mPlayer.setLiveSubtitle((is_live_subtitle&& live_subtitle==1)?1:0);
        }
    }

    public String getDpi() {
        return mPlayer.mDispatcher.mCurrentDPI;
    }

    public void pushMsgInfo() {
        mPlayer.pushMsgInfo();
    }

    @Override
    public void stop() {
        mPlayer.stop();
    }

    @Override
    public void pause() {
        mPlayer.pause();
    }

    @Override
    public void resume() {
        mPlayer.resume();
    }

    @Override
    public void release() {
        VhallSDK.getInstance().leave(this);
        mListener = null;
        if (null != mPlayer) {
            mPlayer.setListener(null);
            mPlayer.stop();
            mPlayer.release();
            mPlayer = null;
        }
    }

    @Override
    public void seekto(long l) {

    }

    public void addExtraLogParam(String s) {
        LogInfo.getInstance().setExtraData(s);
    }

    @Override
    public void setLogParam(String s) {
        //外层设置不可用
    }

    @Override
    public void setVideoPlayer(IVHVideoPlayer ivhVideoPlayer) {
        videoPlayer = ivhVideoPlayer;
        if (videoPlayer instanceof VHVideoPlayerView) {
            mContext = ((VHVideoPlayerView) videoPlayer).getContext();
        }
        mPlayer.setVideoPlayer(videoPlayer);
    }

    @Override
    public void setAudioPlayer(IVHAudioPlayer ivhAudioPlayer) {
        mPlayer.setAudioPlayer(ivhAudioPlayer);
    }

    @Override
    public void mute() {
        mPlayer.mute();
    }

    @Override
    public void unmute() {
        mPlayer.unmute();
    }

    @Override
    public float setSpeed(float i) {
        return 1;
    }

    @Override
    public long getPosition() {
        return 0;
    }

    @Override
    public long getDuration() {
        return 0;
    }

    @Override
    public boolean isPlaying() {
        if (mPlayer != null) {
            return mPlayer.isPlaying();
        }
        return false;
    }

    @Override
    public void setListener(VHPlayerListener listener) {
        mListener = listener;
        mPlayer.setListener(listener);
    }

    @Override
    public void setDrawMode(int i) {
        mPlayer.setDrawMode(i);
    }

    @Override
    public String getChannelId() {
        return mRoomId;
    }

    @Override
    public String getAccessToken() {
        return mAccessToken;
    }

    public int getRealityBufferTime() {
        return mPlayer.getRealityBufferTime();
    }

    @Override
    public void onConnectStateChanged(ConnectServer.State state, int serverType) {
        if (mOnConnectChangedListener != null)
            mOnConnectChangedListener.onStateChanged(state, serverType);
    }

    @Override
    public void onMessage(String msg) {
        if (!TextUtils.isEmpty(msg)) {
            try {
                JSONObject obj = new JSONObject(msg);
                String serviceType = obj.optString("service_type");
                if (TextUtils.isEmpty(serviceType)) {
                    return;
                }
                if (!serviceType.equals(TYPE_ROOM)) {
                    return;
                }
                String dataStr = obj.optString("data");
                JSONObject data = new JSONObject(dataStr);
                String type = data.optString("type");
                if (!TextUtils.isEmpty(type)) {
                    if (type.equals(TYPE_STREAM_START)) {
                        sendEvent(Constants.Event.EVENT_STREAM_START, (data == null ? "" : data.toString()));
                    } else if (type.equals(TYPE_STREAM_STOP)) {
                        sendEvent(EVENT_STREAM_STOP, (data == null ? "" : data.toString()));
                    } else if (type.equals(TYPE_STREAM_CONVERT)) {//发起端分辨率切换
                        //通知调度更新调度信息
                        mPlayer.pushMsgInfo();
                    }
                }
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    public String getOriginalUrl() {
        if (mPlayer != null) {
            return mPlayer.getOriginalUrl();
        }
        return null;
    }

    private void disPatchURL(final String roomId, final String accessToken) {
        if (mLoading)
            return;
        mLoading = true;
        mRoomId = roomId;
        mAccessToken = accessToken;
        VHLssApi.getWatchLiveInfo(roomId, accessToken, new Callback() {
            @Override
            public void onFailure(Call call, IOException e) {
                mLoading = false;
                trackInitEvent(LogReporter.LOG_ERROR_NET);
                sendEvent(Constants.ErrorCode.ERROR_CONNECT, "error network,please try later！");

            }

            @Override
            public void onResponse(Call call, Response response) throws IOException {
                String content = response.body().string();
                if (getData(content, roomId, accessToken)) {
                    sendEvent(Constants.Event.EVENT_INIT_SUCCESS, "init success");
                    if (mPlayer != null) {
                        sendEvent(Constants.Event.EVENT_REALTIME_SUBTITLE, "{\"live_subtitle\":"+live_subtitle+",\"live_subtitle_mps\":\""+ live_subtitle_mps+"\"}");
                    }
                    if (mPlayer != null) {
                        start();
                    }
                }
                mLoading = false;
            }
        });
    }

    private void start() {
        if (mPlayer == null) {
            return;
        }
        mPlayer.setLogParam(LogInfo.getInstance().toString());
        mPlayer.startPlay(mDispatchURL, mDefaultURLS, mCDNPriority);
        VhallSDK.getInstance().join(this);
        if (waterMarkGravity != 0 && videoPlayer != null
                && videoPlayer instanceof VHVideoPlayerView
                && ((VHVideoPlayerView) videoPlayer).getWaterMark() == null) {
            setWaterMark();
        }
    }

    @Override
    public void prepare(String streamUrl) {
        //no this function
    }

    private boolean getData(String json, String roomid, String accessToken) {
        boolean success = false;
        try {
            JSONObject result = new JSONObject(json);
            String msg = result.optString("msg");
            int code = result.optInt("code");
            if (code == 200) {
                JSONObject data = result.optJSONObject("data");
                JSONObject server = data.optJSONObject("default_server");
                JSONObject logObj = data.optJSONObject("log_info");
                int streamStatus;
                if (data.has("stream_status")) {
                    streamStatus = data.optInt("stream_status");
                } else {
                    streamStatus = 1;
                }
                if (streamStatus == 1) {
                    LogInfo.getInstance().roomId = roomid;
                    if (logObj != null) {
                        LogInfo.getInstance().initBaseData(logObj);
                    }
                    live_subtitle = data.optInt("live_subtitle", 0);
                    int live_delay = data.optInt("live_delay", 0);
                    if (mPlayer != null) {
                        mPlayer.setLiveSubtitle((is_live_subtitle && live_subtitle==1)?1:0);
                        live_subtitle_mps =  data.optString("live_subtitle_mps", "");
                        mPlayer.setLiveSubtitleMPS((is_live_subtitle && !TextUtils.isEmpty(live_subtitle_mps))?live_subtitle_mps:"");
                    }
                    String dispatch_server = data.optString("dispatch_server");
                    String rand = server.optString("rand");
                    int app_type = data.optInt("app_type");
                    mDispatchURL = dispatch_server + "/api/dispatch_play" + "?webinar_id=" + roomid + "&rand=" + rand + "&uid=id&bu=1&app_type=" + app_type + "&is_subtitle=" + live_subtitle+ "&is_delay_stream=" + live_delay;
                    result.put("data", server);
                    mDefaultURLS = result.toString();
                    L.i(TAG, "mDefaultURLS:" + mDefaultURLS);
                    //watermark
                    JSONObject waterMark = data.optJSONObject("watermark");
                    String url = waterMark.optString("url");
                    if (!TextUtils.isEmpty(url)) {
                        waterMarkUrl = url;
                    }
                    int gravity = waterMark.optInt("position");
                    if (gravity > 0) {
                        waterMarkGravity = gravity;
                    }
                    JSONObject projectionScreen = data.optJSONObject("projection_screen");
                    if (projectionScreen != null) {
                        enable_projection_screen = projectionScreen.optBoolean("enable", true);
                    }

                    mCDNPriority = data.optString("cdn_priority", "");

                    success = true;
                } else {
                    sendEvent(EVENT_NO_STREAM, "There is no stream push !");
                }
                trackInitEvent();
            } else {
                sendError(Constants.ErrorCode.ERROR_CONNECT, msg);
                trackInitEvent(code + ":" + msg);
            }
        } catch (Exception e) {
            e.printStackTrace();
            trackInitEvent(LogReporter.LOG_ERROR_EXCEPTION);
        }
        return success;
    }

    public boolean getProjectionScreen() {
        return enable_projection_screen;
    }

    private void sendEvent(final int code, final String msg) {
        mDispatcher.post(new Runnable() {
            @Override
            public void run() {
                if (mListener != null) {
                    mListener.onEvent(code, msg);
                }
            }
        });
    }

    private void sendError(final int code, final String msg) {
        mDispatcher.post(new Runnable() {
            @Override
            public void run() {
                if (mListener != null) {
                    mListener.onError(code, 0, msg);
                }
            }
        });
    }

    public void setWaterMark(String url, int gravity, float alpha) {
        if (!TextUtils.isEmpty(url)) {
            waterMarkUrl = url;
        }
        if (gravity > 0) {
            waterMarkGravity = gravity;
        }
        waterMarkAlpha = alpha;
    }

    private void setWaterMark() {
        new Thread(new Runnable() {
            @Override
            public void run() {
                try {
                    URL url = new URL(waterMarkUrl);
                    HttpURLConnection conn;
                    if (waterMarkUrl.contains("https")) {
                        conn = (HttpsURLConnection) url.openConnection();
                    } else {
                        conn = (HttpURLConnection) url.openConnection();
                    }
                    conn.setConnectTimeout(5000);
                    conn.setReadTimeout(5000);
                    Bitmap bitmap = BitmapFactory.decodeStream(conn.getInputStream());
                    final Drawable drawable = new BitmapDrawable(mContext.getResources(), bitmap);
                    mDispatcher.post(new Runnable() {
                        @Override
                        public void run() {
                            if (videoPlayer != null && ((VHVideoPlayerView) videoPlayer).getWaterMark() == null) {
                                ((VHVideoPlayerView) videoPlayer).setWaterMark(drawable);
                                ((VHVideoPlayerView) videoPlayer).setWaterMarkAlpha(waterMarkAlpha);
                                switch (waterMarkGravity) {
                                    case 1:
                                        ((VHVideoPlayerView) videoPlayer).setWaterMarkGravity(Gravity.LEFT);
                                        break;
                                    case 2:
                                        ((VHVideoPlayerView) videoPlayer).setWaterMarkGravity(Gravity.RIGHT);
                                        break;
                                    case 3:
                                        ((VHVideoPlayerView) videoPlayer).setWaterMarkGravity(Gravity.RIGHT | Gravity.BOTTOM);
                                        break;
                                    case 4:
                                        ((VHVideoPlayerView) videoPlayer).setWaterMarkGravity(Gravity.LEFT | Gravity.BOTTOM);
                                        break;
                                }
                            }
                        }
                    });
                } catch (MalformedURLException e) {
                    e.printStackTrace();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    /**
     * 单位：毫秒，开始拉流的超时时间
     *
     * @param mConnectTimeout millisecond
     */
    public void setmConnectTimeout(int mConnectTimeout) {
        mPlayer.setmConnectTimeout(mConnectTimeout);
    }

    /**
     * 重连次数
     *
     * @param mReconnectTimes
     */
    public void setmReconnectTimes(int mReconnectTimes) {
        mPlayer.setmReconnectTimes(mReconnectTimes);
    }

    /**
     * 单位：秒，缓冲(预加载)时间
     *
     * @param mBufferSeconds
     */
    public void setmBufferSeconds(int mBufferSeconds) {
        mPlayer.setmBufferSeconds(mBufferSeconds);
    }

    private void setmDecodeMode(int mDecodeMode) {
        mPlayer.setmDecodeMode(mDecodeMode);
    }

    private void setmStreamType(int mStreamType) {
        mPlayer.setmStreamType(mStreamType);
    }

    public static class Builder {

        VHLivePlayer player = new VHLivePlayer();

        public Builder audioPlayer(IVHAudioPlayer audioPlayer) {
            player.setAudioPlayer(audioPlayer);
            return this;
        }

        public Builder videoPlayer(IVHVideoPlayer videoPlayer) {
            player.setVideoPlayer(videoPlayer);
            return this;
        }

        public Builder listener(VHPlayerListener listener) {
            player.setListener(listener);
            return this;
        }

        public Builder bufferSeconds(int bufferSeconds) {
            if (bufferSeconds > 0) {
                player.setmBufferSeconds(bufferSeconds);

            }
            return this;
        }

        public Builder reconnectTimes(int reconnectTimes) {
            if (reconnectTimes > 0) {
                player.setmReconnectTimes(reconnectTimes);
            }
            return this;
        }

        public Builder connectTimeout(int connectTimeout) {
            if (connectTimeout > 0) {
                player.setmConnectTimeout(connectTimeout);
            }
            return this;
        }

        public VHLivePlayer build() {
            return player;
        }
    }



    private void trackInitEvent(String error){
        JSONObject params = new JSONObject();
        try {
            params.put("roomId",mRoomId);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        LogReporter.getInstance().setErr(error);
        LogReporter.getInstance().onCollection(LogReporter.LOG_EVENT_INITLSS_WATCH, false, params);
    }

    private void trackInitEvent(){
        JSONObject params = new JSONObject();
        try {
            params.put("roomId",mRoomId);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        LogReporter.getInstance().onCollection(LogReporter.LOG_EVENT_INITLSS_WATCH, params);
    }
}