/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.ims.message;

import android.text.TextUtils;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public interface IBody {
    public static final String TYPE_KEY = "type";
    public static final String TEXT_CONTENT_KEY = "text_content";
    public static final String IMAGE_URL_KEY = "image_url";
    public static final String IMAGE_URLS_KEY = "image_urls";
    public static final String LINK_URL_KEY = "link_url";
    public static final String VIDEO_URL_KEY = "video_url";
    public static final String VOICE_URL_KEY = "voice_url";
    public static final String TARGET_ID_KEY = "target_id";

    public String getType();

    public String getTextContent();

    public String getImageUrl();

    public List<String> getImageUrls();

    public String getLinkUrl();

    public String getVideoUrl();

    public String getVoiceUrl();

    public String getTargetId();

    public String getBodyStr();

    public static class Builder {
        private String type = "text";
        private String textContent;
        private String imageUrl;
        private List<String> imageUrls;
        private String linkUrl;
        private String videoUrl;
        private String voiceUrl;
        private String targetId;

        public Builder setType(String type) {
            this.type = type;
            return this;
        }

        public Builder setTextContent(String textContent) {
            this.textContent = textContent;
            return this;
        }

        public Builder setImageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
            return this;
        }

        public Builder setImageUrls(List<String> imageUrls) {
            if (this.imageUrls == null) {
                this.imageUrls = new ArrayList<String>();
            }
            if (imageUrls != null && imageUrls.size() > 0) {
                this.imageUrls.addAll(imageUrls);
            }
            return this;
        }

        public Builder setLinkUrl(String linkUrl) {
            this.linkUrl = linkUrl;
            return this;
        }

        public Builder setVideoUrl(String videoUrl) {
            this.videoUrl = videoUrl;
            return this;
        }

        public Builder setVoiceUrl(String voiceUrl) {
            this.voiceUrl = voiceUrl;
            return this;
        }

        public Builder setTargetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public IBody build() {
            return new IBody(){

                @Override
                public String getType() {
                    return type;
                }

                @Override
                public String getTextContent() {
                    return textContent;
                }

                @Override
                public String getImageUrl() {
                    return imageUrl;
                }

                @Override
                public List<String> getImageUrls() {
                    return imageUrls;
                }

                @Override
                public String getLinkUrl() {
                    return linkUrl;
                }

                @Override
                public String getVideoUrl() {
                    return videoUrl;
                }

                @Override
                public String getVoiceUrl() {
                    return voiceUrl;
                }

                @Override
                public String getTargetId() {
                    return targetId;
                }

                @Override
                public String getBodyStr() {
                    return this.toBodyJsonStr();
                }
            };
        }

        public String toBodyJsonStr() {
            JSONObject message = new JSONObject();
            try {
                if (TextUtils.isEmpty((CharSequence)this.type)) {
                    message.put(IBody.TYPE_KEY, (Object)"text");
                } else {
                    message.put(IBody.TYPE_KEY, (Object)this.type);
                }
                if (!TextUtils.isEmpty((CharSequence)this.textContent)) {
                    message.put(IBody.TEXT_CONTENT_KEY, (Object)this.textContent);
                }
                if (!TextUtils.isEmpty((CharSequence)this.imageUrl)) {
                    message.put(IBody.IMAGE_URL_KEY, (Object)this.imageUrl);
                }
                if (this.imageUrls != null && this.imageUrls.size() > 0) {
                    JSONArray array = new JSONArray();
                    for (String url : this.imageUrls) {
                        array.put((Object)url);
                    }
                    message.put(IBody.IMAGE_URLS_KEY, (Object)array);
                }
                if (!TextUtils.isEmpty((CharSequence)this.linkUrl)) {
                    message.put(IBody.LINK_URL_KEY, (Object)this.linkUrl);
                }
                if (!TextUtils.isEmpty((CharSequence)this.videoUrl)) {
                    message.put(IBody.VIDEO_URL_KEY, (Object)this.videoUrl);
                }
                if (!TextUtils.isEmpty((CharSequence)this.voiceUrl)) {
                    message.put(IBody.VOICE_URL_KEY, (Object)this.voiceUrl);
                }
                if (!TextUtils.isEmpty((CharSequence)this.targetId)) {
                    message.put(IBody.TARGET_ID_KEY, (Object)this.targetId);
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            return message.toString();
        }
    }
}

