package com.vhall.ims;

import com.vhall.framework.VHAPI;

import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.FormBody;

import static com.vhall.framework.VHAPI.getBaseBuilder;
import static com.vhall.framework.VHAPI.getOkHttpClient;
import static com.vhall.framework.VHAPI.getRequest;

/**
 * Created by zwp on 2019-08-23
 */
public class VHIMApi {
    /**
     * 获取用户在线连接列表
     *
     * @param channelId
     * @param accessToken
     * @param curPage
     * @param pageSize
     * @param callback
     */
    public static void getUserIdList(String channelId, String accessToken, int curPage, int pageSize, Callback callback) {
        FormBody.Builder builder = getBaseBuilder(accessToken)
                .add("channel_id", channelId)
                .add("curr_page", String.valueOf(curPage))
                .add("page_size", String.valueOf(pageSize));
        Call call = getOkHttpClient().newCall(getRequest("v2/message/get-userid-list", builder.build()));
        if (callback == null)
            call.enqueue(new VHAPI.DefaultCallback());
        else
            call.enqueue(callback);
    }

    /**
     * 设置频道禁言操作
     *
     * @param channelId
     * @param type
     * @param targetId
     * @param accessToken
     * @param callback
     */
    public static void setChannel(String channelId, String type, String targetId, String accessToken, Callback callback) {
        FormBody.Builder builder = getBaseBuilder(accessToken)
                .add("channel_id", channelId)
                .add("type", type);
        if (type.equals(VHIM.TYPE_DISABLE) || type.equals(VHIM.TYPE_PERMIT)) {
            builder.add("target_id", targetId);
        }
        Call call = getOkHttpClient().newCall(getRequest("v2/message/set-channel", builder.build()));
        if (callback == null)
            call.enqueue(new VHAPI.DefaultCallback());
        else
            call.enqueue(callback);

    }

    /**
     * 获取历史消息列表
     *
     * @param channelId
     * @param type         (非必填) 查询类型，1 聊天列表(默认)，2 自定义聊天列表
     * @param curPage
     * @param pageSize
     * @param filterStatus 过滤类型，0 可查看（默认），1 不可查看
     * @param startTime    时间格式：2019/01/01
     * @param endTime
     * @param msgType      （非必填）要查询消息类型，多个类型用逗号分隔，默认文本（text）,可选值：text,image,link,video,voice
     * @param auditStatus  (非必填) 默认("0,1,3"【人工审核通过及系统自动审核通过】，可选值：0【未经过消息审核服务】、1【人工审核通过】、2【人工审核拒绝】、3【超过200条自动审核通过】、4【超过200条自动审核拒绝】)
     * @param accessToken
     * @param callback
     */
    public static void getHistoryList(String channelId, String type, int curPage, int pageSize, String filterStatus, String startTime,
                                      String endTime, String msgType, String auditStatus, String accessToken, Callback callback) {
        FormBody.Builder builder = getBaseBuilder(accessToken)
                .add("channel_id", channelId)
                .add("type", type)
                .add("curr_page", String.valueOf(curPage))
                .add("page_size", String.valueOf(pageSize))
                .add("filter_status", filterStatus)
                .add("start_time", startTime)
                .add("end_time", endTime)
                .add("msg_type", msgType)
                .add("audit_status", auditStatus);
        Call call = getOkHttpClient().newCall(getRequest("v2/message/lists", builder.build()));
        if (callback == null) {
            call.enqueue(new VHAPI.DefaultCallback());
        } else {
            call.enqueue(callback);
        }
    }
}
