/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.rtc.trtc.log;

import com.vhall.logmanager.VLog;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.net.ssl.HttpsURLConnection;

public class TempHttpRequest {
    private static final String TAG = "HttpRequest";
    private static ExecutorService singleThreadExecutor = Executors.newSingleThreadExecutor();

    public static void httpGetAsyncRequest(final String urlStr) {
        singleThreadExecutor.execute(new Runnable(){

            @Override
            public void run() {
                TempHttpRequest.httpSyncRequest("GET", urlStr, null);
            }
        });
    }

    public static void httpPostAsyncRequest(final String urlStr, final String post) {
        singleThreadExecutor.execute(new Runnable(){

            @Override
            public void run() {
                TempHttpRequest.httpSyncRequest("POST", urlStr, post);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void httpSyncRequest(String method, String urlStr, String post) {
        HttpURLConnection connection = null;
        try {
            URL url = new URL(urlStr);
            connection = urlStr.startsWith("https") ? (HttpsURLConnection)url.openConnection() : (HttpURLConnection)url.openConnection();
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setConnectTimeout(15000);
            connection.setReadTimeout(5000);
            connection.setRequestMethod(method);
            if (method.equals("POST")) {
                PrintWriter printWriter = new PrintWriter(connection.getOutputStream());
                printWriter.write(post);
                printWriter.flush();
                printWriter.close();
            }
            if (200 == connection.getResponseCode()) {
                String line;
                InputStream in = connection.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                StringBuilder response = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
                VLog.d((String)TAG, (String)("------> respone data: " + response));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }
}

