/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.rtc.trtc.log;

import android.util.Base64;
import com.vhall.logmanager.VLog;
import com.vhall.rtc.trtc.Stream;
import com.vhall.rtc.trtc.log.LogReport;
import com.vhall.rtc.trtc.log.TempHttpRequest;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import org.json.JSONException;
import org.json.JSONObject;

public class StreamLogReport {
    private static final String mTag = "StreamLogReport";
    private static final long period = 30000L;
    private static final String KDizDes02 = "biz_des02";
    private static final int VhallStreamStatusTypeStart = 0;
    private static final int VhallStreamStatusTypesStop = 1;
    public static final String kStreamId = "p";
    public static final String kErrorCode = "errorcode";
    public static final String kBitRate = "bitrate";
    public static final String kTF = "tf";
    public static final String kTT = "tt";
    public static final String kUF = "uf";
    public static final String kOS = "os";
    public static final String kWidth = "v_width";
    public static final String kHeight = "v_height";
    private Object lock = new Object();
    private Stream mStream;
    private Timer mStatsTimer;
    private TimerTask timerTask;

    public void streamStart(Stream stream) {
        this.mStream = stream;
        if (this.mStatsTimer == null) {
            this.mStatsTimer = new Timer();
            this.timerTask = new TimerTask(){

                @Override
                public void run() {
                    StreamLogReport.this.gatherTrackStats(VhallLogReportErrorCode.kNoneError, 0);
                }
            };
            this.mStatsTimer.schedule(this.timerTask, 30000L, 30000L);
        }
    }

    public void streamStop() {
        if (this.mStatsTimer != null) {
            this.mStatsTimer.cancel();
            this.mStatsTimer = null;
        }
        if (this.timerTask != null) {
            this.timerTask.cancel();
            this.timerTask = null;
        }
        VhallLogReportErrorCode errorCode = this.mStream.isLocal ? VhallLogReportErrorCode.kPublishSuccess : VhallLogReportErrorCode.kSubscribeSuccess;
        this.gatherTrackStats(errorCode, 1);
    }

    public void streamError() {
        VhallLogReportErrorCode errorCode = this.mStream.isLocal ? VhallLogReportErrorCode.kPublishError : VhallLogReportErrorCode.kSubscribeError;
        this.gatherTrackStats(errorCode, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gatherTrackStats(VhallLogReportErrorCode errorCode, int type) {
        LogReport logReport = LogReport.instance();
        LogReport.VhallLogReportKey key = LogReport.VhallLogReportKey.kSignalingConnectSuccess;
        String token = null;
        try {
            JSONObject tokenDic = new JSONObject(logReport.logDataInfo.toString());
            tokenDic.put(kStreamId, (Object)this.mStream.streamId);
            HashMap<String, String> statistcs = logReport.fetchStatisticsData(this.mStream);
            if (null != statistcs) {
                if (statistcs.containsKey("videoWidth")) {
                    tokenDic.put(kWidth, (Object)Integer.valueOf(statistcs.get("videoWidth")));
                }
                if (statistcs.containsKey("videoHeight")) {
                    tokenDic.put(kHeight, (Object)Integer.valueOf(statistcs.get("videoHeight")));
                }
                key = this.mStream.isLocal ? LogReport.VhallLogReportKey.kPublishInfo : LogReport.VhallLogReportKey.kSubscribeInfo;
                if (type == 0) {
                    tokenDic.put(KDizDes02, 1);
                } else {
                    tokenDic.put(KDizDes02, 2);
                }
                tokenDic.put(kOS, false);
                tokenDic.put(kBitRate, (Object)statistcs.get(kBitRate));
                if (errorCode.getValue() > 0) {
                    tokenDic.put(kErrorCode, errorCode.getValue());
                }
                token = tokenDic.toString();
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        if (null != token) {
            String url = null;
            try {
                url = logReport.reportUrl + "?k=" + key.getValue() + "&s=" + logReport.sessionId + "&id=" + logReport.getLogId() + "&bu=" + logReport.bu + "&token=" + new String(Base64.encode((byte[])token.getBytes(), (int)2), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            VLog.d((String)mTag, url);
            TempHttpRequest.httpGetAsyncRequest(url);
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
            object = this.lock;
            synchronized (object) {
                try {
                    this.lock.wait(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static enum VhallLogReportErrorCode {
        kNoneError(-1),
        kSubscribeError(4001),
        kSubscribeSuccess(2002),
        kPublishError(4002),
        kPublishSuccess(2003);

        private int _value;

        private VhallLogReportErrorCode(int value) {
            this._value = value;
        }

        public int getValue() {
            return this._value;
        }
    }
}

