/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.rtc;

import android.text.TextUtils;
import com.vhall.rtc.Utils;
import org.json.JSONException;
import org.json.JSONObject;

public class VRTCParams {
    public static final String RTCTYPE_VRTC = "1";
    public static final String RTCTYPE_TRTC = "2";

    public static class VRTCBroadcastParamInner {
        public VRTCBroadcastParam broadcastParam;
        public JSONObject compat_profile_json;
        public int compat_layout_mode;
        public boolean isAdaptiveLayoutMode = false;
        public String pushUrl;
        public String inavRoomId;
        public String broadcastRoomId;

        public VRTCBroadcastParamInner() {
        }

        public VRTCBroadcastParamInner(VRTCBroadcastParam broadcastParam) {
            this.broadcastParam = broadcastParam;
        }

        public VRTCBroadcastParamInner(VRTCBroadcastParamInner originParam) {
            this.broadcastParam = originParam.broadcastParam;
            this.compat_layout_mode = originParam.compat_layout_mode;
            this.compat_profile_json = originParam.compat_profile_json;
            this.pushUrl = originParam.pushUrl;
        }
    }

    public static class VRTCBroadcastParam {
        public int profile = 5;
        public int layoutMode = 13;
        public boolean precast_pic_exist = false;
        public boolean nickName = true;
        public int cropType = 0;
        public String backgroundColor;
        @Deprecated
        public String backgroundImageUrl;
        public Border border;

        public static class Border {
            public boolean exist = false;
            public int width = 4;
            public String color = "";
            public boolean transparent = false;

            public JSONObject convertToJson() {
                JSONObject result = new JSONObject();
                try {
                    result.put("exist", this.exist);
                    result.put("width", this.width);
                    result.put("color", (Object)this.color);
                    result.put("transparency", this.transparent ? 100 : 0);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                return result;
            }

            public String convertColor2VRTCStyle() {
                return Utils.compatColor2HexStyle(this.color);
            }

            public Border copy() {
                Border newBorder = new Border();
                newBorder.color = this.color;
                newBorder.width = this.width;
                newBorder.exist = this.exist;
                return newBorder;
            }
        }
    }

    public static class VRTCRoomParamsInner {
        public VRTCRoomParams roomParams;
        public String mode = "rtc";
        public boolean softEchoCanceller = false;
        public boolean cpuoverusedetection = true;
        public String type = "1";
        public int trtcSdkAppId = 0;
        public String inavToken = "";
        public String userId = "";

        public VRTCRoomParamsInner() {
        }

        public VRTCRoomParamsInner(VRTCRoomParams roomParams) {
            this.roomParams = roomParams;
        }

        public VRTCRoomParamsInner(VRTCRoomParamsInner originParam) {
            this.roomParams = originParam.roomParams;
            this.trtcSdkAppId = originParam.trtcSdkAppId;
            this.inavToken = originParam.inavToken;
            this.type = originParam.type;
            this.softEchoCanceller = originParam.softEchoCanceller;
            this.cpuoverusedetection = originParam.cpuoverusedetection;
            if (!TextUtils.isEmpty((CharSequence)originParam.roomParams.broadcastRoomId)) {
                this.mode = "live";
            }
        }
    }

    public static class VRTCRoomParams {
        public String inavRoomId = "";
        public String broadcastRoomId = "";
        public String accessToken = "";
        public String role = "administrator";

        public VRTCRoomParams() {
        }

        public VRTCRoomParams(String inavRoomId, String accessToken, String role) {
            this.inavRoomId = inavRoomId;
            this.accessToken = accessToken;
            this.role = role;
        }

        public VRTCRoomParams(String inavRoomId, String accessToken, String broadcastRoomId, String role) {
            this.inavRoomId = inavRoomId;
            this.accessToken = accessToken;
            this.broadcastRoomId = broadcastRoomId;
            this.role = role;
        }
    }

    public static class VRTCVideoEncodeParam {
        public int videoResolution;
        public int videoResolutionMode;
        public int resolutionStrategy = 3;
        public int videoWidth;
        public int videoHeight;
        public int videoFps;
        public int videoBitrate;
        public int minVideoBitrate;
        public int maxVideoBitrate;
        public int videoResolution2TRTC;

        public VRTCVideoEncodeParam() {
        }

        public VRTCVideoEncodeParam(int videoResolution, int videoResolutionMode) {
            this.videoResolution = videoResolution;
            this.videoResolutionMode = videoResolutionMode;
        }
    }

    public static class VRTCStreamParam {
        public String attributes;
        public int streamType;
        public String nickName;
    }

    public static class VRTCVideoFillMode {
        public static final int RENDER_MODE_NONE = 0;
        public static final int RENDER_MODE_FIT = 1;
        public static final int RENDER_MODE_ASPECT_FILL = 2;
    }

    public static class VRTCStreamType {
        public static final int VhallStreamTypeOnlyAudio = 0;
        public static final int VhallStreamTypeOnlyVideo = 1;
        public static final int VhallStreamTypeAudioAndVideo = 2;
        public static final int VhallStreamTypeScreen = 3;
        public static final int VhallStreamTypeFile = 4;
        public static final int VhallStreamTypeVideoPatrol = 5;
        public static final int VhallStreamTypeCustom = 6;
    }
}

