/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.ilss;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import com.vhall.framework.VhallSDK;
import com.vhall.framework.connect.IVHService;
import com.vhall.ilss.VHInteractive;
import com.vhall.ilss.VHInteractiveApi;
import com.vhall.logmanager.L;
import com.vhall.logmanager.LogInfo;
import com.vhall.logmanager.LogReporter;
import com.vhall.message.ConnectServer;
import com.vhall.rtc.VhallRTC;
import com.vhall.vhallrtc.client.Room;
import com.vhall.vhallrtc.client.Stream;
import java.io.IOException;
import java.util.concurrent.CopyOnWriteArraySet;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class VHOTOInteractive
extends VhallRTC
implements IVHService {
    private static final String TAG = "VHOTOInteractive";
    public static final String publish_inav_stream = "publish_inav_stream";
    public static final String askfor_inav_publish = "askfor_inav_publish";
    public static final String user_publish_callback = "user_publish_callback";
    public static final String inav_close = "inav_close";
    public static final int STATUS_AGREE = 1;
    public static final int STATUS_LEAVE = 2;
    public static final int STATUS_REJECT = 3;
    private String targetId = "";
    private String mRoomId = "";
    private String mAccessToken = "";
    private String TOKEN = "";
    private Handler mHandler;
    private CopyOnWriteArraySet<String> mPermissions = new CopyOnWriteArraySet();
    private OTOInteractiveListener listener;
    private Room.RoomDelegate roomDelegate = new Room.RoomDelegate(){

        public void onDidConnect(Room room, JSONObject jsonObject) {
            Log.i((String)VHOTOInteractive.TAG, (String)"onDidConnect");
            if (VHOTOInteractive.this.listener != null) {
                VHOTOInteractive.this.listener.onRoomDidConnect();
            }
        }

        public void onDidError(Room room, Room.VHRoomErrorStatus vhRoomErrorStatus, String s) {
            Log.i((String)VHOTOInteractive.TAG, (String)"onDidError");
            if (VHOTOInteractive.this.listener != null) {
                VHOTOInteractive.this.listener.onRoomConnectError();
            }
        }

        public void onDidPublishStream(Room room, Stream stream) {
        }

        public void onDidInternalStreamAdded(Room room, Stream stream) {
        }

        public void onDidInternalStreamRemoved(Room room, Stream stream) {
        }

        public void onDidInternalStreamFailed(Room room, Stream stream, JSONObject jsonObject) {
        }

        public void onDidUnPublishStream(Room room, Stream stream) {
        }

        public void onDidSubscribeStream(Room room, final Stream stream) {
            if (VHOTOInteractive.this.listener != null) {
                new Handler(Looper.getMainLooper()).post(new Runnable(){

                    @Override
                    public void run() {
                        VHOTOInteractive.this.listener.onDidAddStream(stream);
                    }
                });
            }
        }

        public void onDidUnSubscribeStream(Room room, Stream stream) {
            Log.e((String)VHOTOInteractive.TAG, (String)"onDidUnSubscribeStream: ");
            VHOTOInteractive.this.unpublish();
        }

        public void onDidChangeStatus(Room room, Room.VHRoomStatus vhRoomStatus) {
        }

        public void onDidAddStream(Room room, Stream stream) {
            if (!VHOTOInteractive.this.targetId.equals(stream.userId)) {
                return;
            }
            try {
                stream.streamOption.put("dual", 1);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            room.subscribe(stream);
            if (VHOTOInteractive.this.mLocalStream != null && !((VHOTOInteractive)VHOTOInteractive.this).mLocalStream.isPublish) {
                VHOTOInteractive.this.publish();
            }
        }

        public void onDidRemoveStream(Room room, Stream stream) {
            Log.e((String)VHOTOInteractive.TAG, (String)"onDidRemoveStream: ");
            if (VHOTOInteractive.this.targetId.equals(stream.userId)) {
                VHOTOInteractive.this.unpublish();
            }
        }

        public void onDidUpdateOfStream(Stream stream, JSONObject jsonObject) {
        }

        public void onReconnect(int i, int i1) {
            if (VHOTOInteractive.this.listener != null) {
                VHOTOInteractive.this.listener.onRoomReconnect();
            }
        }

        public void onStreamMixed(JSONObject jsonObject) {
        }
    };

    public VHOTOInteractive(Context context) {
        super(context, true);
        this.setListener(this.roomDelegate);
        this.mHandler = new Handler(Looper.getMainLooper());
    }

    public void setOTOListener(OTOInteractiveListener listener) {
        this.listener = listener;
    }

    public String getChannelId() {
        return this.mRoomId;
    }

    public String getAccessToken() {
        return this.mAccessToken;
    }

    public void onConnectStateChanged(ConnectServer.State state, int serverType) {
        if (this.listener != null && serverType == 1) {
            switch (state) {
                case STATE_CONNECTED: {
                    this.listener.onServerConnected();
                    break;
                }
                case STATE_DISCONNECT: {
                    this.listener.onServerDisConnected();
                    break;
                }
                case STATE_CONNECTIONG: {
                    this.listener.onServerConnecting();
                }
            }
        }
    }

    public void onMessage(String msg) {
        if (TextUtils.isEmpty((CharSequence)msg)) {
            return;
        }
        if (this.listener != null) {
            try {
                JSONObject result = new JSONObject(msg);
                String event = result.optString("event");
                if (event.equals("Inav")) {
                    JSONObject data = result.optJSONObject("data");
                    String senderId = result.optString("third_party_user_id");
                    String dataEvent = data.getString("inav_event");
                    String userId = data.optString("third_party_user_id");
                    if (!VhallSDK.getInstance().getmUserId().equals(senderId)) {
                        switch (dataEvent) {
                            case "askfor_inav_publish": {
                                if (!VhallSDK.getInstance().getmUserId().equals(userId)) break;
                                this.listener.onOTOCall(senderId);
                                this.targetId = senderId;
                                break;
                            }
                            case "user_publish_callback": {
                                if (!senderId.equals(this.targetId)) break;
                                int status = data.optInt("status");
                                if (status == 1) {
                                    this.listener.onOTOPositiveAnswer();
                                    break;
                                }
                                if (status == 2) {
                                    this.listener.onOTOCallEnd();
                                    break;
                                }
                                if (status != 3) break;
                                this.listener.onOTONegativeAnswer();
                            }
                        }
                    }
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    public void init(final String roomid, final String accessToken, final VHInteractive.InitCallback callback) {
        VHInteractiveApi.getRoomInfo(roomid, accessToken, null, "rtc", "administrator", new Callback(){

            public void onFailure(Call call, IOException e) {
                L.e((String)VHOTOInteractive.TAG, (String)e.getMessage());
                VHOTOInteractive.this.trackInitEvent("-1");
                VHOTOInteractive.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            callback.onFailure(-1, "error network,please try later\uff01");
                        }
                    }
                });
            }

            public void onResponse(Call call, Response response) throws IOException {
                final String content = response.body().string();
                VHOTOInteractive.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            JSONObject result = new JSONObject(content);
                            String msg = result.optString("msg");
                            int code = result.optInt("code");
                            if (code == 200) {
                                VHOTOInteractive.this.mRoomId = roomid;
                                VHOTOInteractive.this.mAccessToken = accessToken;
                                JSONObject data = result.optJSONObject("data");
                                VHOTOInteractive.this.TOKEN = data.getString("inav_token");
                                JSONArray permissions = data.optJSONArray("permission");
                                if (permissions != null && permissions.length() > 0) {
                                    for (int i = 0; i < permissions.length(); ++i) {
                                        VHOTOInteractive.this.mPermissions.add((String)permissions.get(i));
                                    }
                                }
                                LogInfo.getInstance().roomId = VHOTOInteractive.this.mRoomId;
                                VHOTOInteractive.this.setDataReport(new JSONObject(LogInfo.getInstance().toString()));
                                if (callback != null) {
                                    callback.onSuccess();
                                }
                                VHOTOInteractive.this.trackInitEvent();
                            } else {
                                if (callback != null) {
                                    callback.onFailure(code, msg);
                                }
                                VHOTOInteractive.this.trackInitEvent(code + ":" + msg);
                            }
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                            if (callback != null) {
                                callback.onFailure(-1, "Request data exception");
                            }
                            VHOTOInteractive.this.trackInitEvent("-2");
                        }
                    }
                });
            }
        });
    }

    public void enterRoom(String attribute) {
        if (!TextUtils.isEmpty((CharSequence)this.TOKEN)) {
            super.enterRoom(this.TOKEN, attribute);
        }
        VhallSDK.getInstance().join((IVHService)this);
    }

    public int OTOCall(String userId) {
        final int[] result = new int[]{-1};
        this.targetId = userId;
        if (this.isInviteAvailable()) {
            VHInteractiveApi.invitePush(this.mRoomId, this.mAccessToken, userId, new Callback(){

                public void onFailure(Call call, IOException e) {
                }

                public void onResponse(Call call, Response response) throws IOException {
                    if (response.code() == 200) {
                        String res = response.body().string();
                        try {
                            JSONObject obj = new JSONObject(res);
                            int code = obj.optInt("code");
                            if (code == 200) {
                                result[0] = 1;
                            }
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
        }
        return result[0];
    }

    public int OTOPositiveAnswer() {
        return this.OTOAnswer(1);
    }

    public int OTONegativeAnswer() {
        if (this.mLocalStream != null && this.mLocalStream.isPublish) {
            return this.OTOAnswer(2);
        }
        return this.OTOAnswer(3);
    }

    private int OTOAnswer(int type) {
        final int[] result = new int[]{-1};
        if (type == 1) {
            super.publish();
        } else {
            super.unpublish();
        }
        VHInteractiveApi.onStateChanged(this.mRoomId, this.mAccessToken, String.valueOf(this.mLocalStream.streamId), type, new Callback(){

            public void onFailure(Call call, IOException e) {
            }

            public void onResponse(Call call, Response response) throws IOException {
                if (response.code() == 200) {
                    try {
                        JSONObject obj = new JSONObject(response.body().string());
                        int code = obj.optInt("code");
                        if (code == 200) {
                            result[0] = 1;
                        }
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        return result[0];
    }

    public Stream createLocalStream(String extraInfo) {
        JSONObject option = new JSONObject();
        try {
            option.put("frameResolutionType", 3);
            option.put("minBitrateKbps", 1200);
            option.put("currentBitrateKbps", 1500);
            option.put("maxBitrateKbps", 1900);
            option.put("streamType", Stream.VhallStreamType.VhallStreamTypeAudioAndVideo.getValue());
            option.put("numSpatialLayers", 2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return super.createLocalStream(option, extraInfo);
    }

    public void publish() {
        if (this.isPushAvailable()) {
            super.publish();
            VHInteractiveApi.onStateChanged(this.mRoomId, this.mAccessToken, String.valueOf(this.mLocalStream.streamId), 1, null);
        } else {
            Log.e((String)TAG, (String)"Do not have publish permission.");
        }
    }

    public void unpublish() {
        super.unpublish();
        VHInteractiveApi.onStateChanged(this.mRoomId, this.mAccessToken, String.valueOf(this.mLocalStream.streamId), 2, null);
    }

    public void leaveRoom() {
        super.leaveRoom();
        VhallSDK.getInstance().leave((IVHService)this);
        VHInteractiveApi.onLeave(this.mRoomId, this.mAccessToken);
    }

    public void getMembers(Callback callback) {
        if (TextUtils.isEmpty((CharSequence)this.mRoomId)) {
            return;
        }
        VHInteractiveApi.getRoomMember(this.mRoomId, this.mAccessToken, callback);
    }

    public boolean isPushAvailable() {
        return this.mPermissions != null && this.mPermissions.contains(publish_inav_stream);
    }

    public boolean isInviteAvailable() {
        return this.mPermissions != null && this.mPermissions.contains(askfor_inav_publish);
    }

    private void trackInitEvent(String error) {
        JSONObject params = new JSONObject();
        try {
            params.put("inavId", (Object)this.mRoomId);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        LogReporter.getInstance().setErr(error);
        LogReporter.getInstance().onCollection("2007", false, params);
    }

    private void trackInitEvent() {
        JSONObject params = new JSONObject();
        try {
            params.put("inavId", (Object)this.mRoomId);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        LogReporter.getInstance().onCollection("2007", params);
    }

    public static interface OTOInteractiveListener {
        public void onRoomDidConnect();

        public void onRoomConnectError();

        public void onRoomReconnect();

        public void onServerConnecting();

        public void onServerConnected();

        public void onServerDisConnected();

        public void onOTOCall(String var1);

        public void onOTOPositiveAnswer();

        public void onOTONegativeAnswer();

        public void onOTOCallEnd();

        public void onDidAddStream(Stream var1);
    }
}

