/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.ilss;

import android.content.Context;
import android.media.projection.MediaProjection;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.vhall.framework.VhallBaseSDK;
import com.vhall.framework.common.ICallback;
import com.vhall.framework.connect.IVHService;
import com.vhall.framework.connect.VhallConnectService;
import com.vhall.ilss.VHInteractiveApi;
import com.vhall.ilss.VHRoomListener;
import com.vhall.logmanager.LogInfo;
import com.vhall.logmanager.LogReporter;
import com.vhall.logmanager.VLog;
import com.vhall.message.ConnectServer;
import com.vhall.rtc.Utils;
import com.vhall.rtc.VRTCParams;
import com.vhall.rtc.absrtc.ISwitchFocusModeListener;
import com.vhall.rtc.absrtc.IVHRTC;
import com.vhall.rtc.absrtc.IVHRTCRenderView;
import com.vhall.rtc.absrtc.VHInteractiveFactory;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class VHInteractiveV2
implements IVHService {
    private static final String TAG = "VHInteractive";
    private IVHRTC mRtcInstance = null;
    private VRTCParams.VRTCRoomParamsInner mRoomParams;
    private VRTCParams.VRTCBroadcastParamInner mBroadcastParams;
    private String mRoomId = "";
    private String mAccessToken = "";
    private String mBroadcastId = "";
    private String mPushUrl = "";
    private String mMode = "rtc";
    private String mRole = "administrator";
    private CopyOnWriteArraySet<String> mPermissions = new CopyOnWriteArraySet();
    private OnMessageListener mMessageListener;
    private VhallConnectService.OnConnectStateChangedListener mOnConnectChangedListener;
    private JSONObject _bgColorJSON = null;
    private JSONObject _boardColorJSON = null;
    private Handler mHandler;
    private Context mContext;
    private VHRoomListener mRoomListener;

    private VHInteractiveV2() {
    }

    public VHInteractiveV2(Context context, VRTCParams.VRTCRoomParams roomParams, ICallback roomInfoCallback) {
        this(context, roomParams, roomInfoCallback, null);
    }

    public VHInteractiveV2(Context context, VRTCParams.VRTCRoomParams roomParams, final ICallback roomInfoCallback, String rtcSDKType) {
        this.mContext = context;
        this.mHandler = new Handler(Looper.getMainLooper());
        this.mRoomParams = new VRTCParams.VRTCRoomParamsInner(roomParams);
        this.mRoomParams.userId = VhallBaseSDK.getInstance().getmUserId();
        if (!TextUtils.isEmpty((CharSequence)rtcSDKType)) {
            this.doRtcInit(rtcSDKType, null);
        }
        this.init(roomParams.inavRoomId, roomParams.accessToken, roomParams.broadcastRoomId, this.mRoomParams.mode, roomParams.role, new ICallback(){

            public void onSuccess() {
                if (null != roomInfoCallback) {
                    roomInfoCallback.onSuccess();
                }
            }

            public void onFailure(int code, String msg) {
                if (null != roomInfoCallback) {
                    roomInfoCallback.onFailure(code, msg);
                }
            }
        });
    }

    public void setListener(VHRoomListener roomListener) {
        this.mRoomListener = roomListener;
    }

    private void init(String roomid, String accessToken, String broadcastid, String mode, String role, ICallback callback) {
        this.mRoomId = roomid;
        this.mMode = mode;
        this.mRole = role;
        if (TextUtils.isEmpty((CharSequence)this.mMode)) {
            this.mMode = "rtc";
        }
        if (!this.mMode.equals("live")) {
            this.mRole = "administrator";
        }
        this.mAccessToken = accessToken;
        this.getRoomInfo(roomid, accessToken, broadcastid, mode, role, callback);
    }

    public void setOnMessageListener(OnMessageListener listener) {
        this.mMessageListener = listener;
    }

    @Deprecated
    public void setOnConnectChangedListener(VhallConnectService.OnConnectStateChangedListener listener) {
        this.mOnConnectChangedListener = listener;
    }

    private void getRoomInfo(String roomid, String accessToken, final String broadcastid, String mode, String role, final ICallback callback) {
        VHInteractiveApi.getRoomInfo(roomid, accessToken, broadcastid, mode, role, new Callback(){

            public void onFailure(Call call, IOException e) {
                VLog.d((String)VHInteractiveV2.TAG, (String)e.getMessage());
                VHInteractiveV2.this.trackInitEvent("-1");
                VHInteractiveV2.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            callback.onFailure(-1, "error network,please try later\uff01");
                        }
                    }
                });
            }

            public void onResponse(Call call, Response response) throws IOException {
                final String content = response.body().string();
                VHInteractiveV2.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            JSONObject result = new JSONObject(content);
                            String msg = result.optString("msg");
                            int code = result.optInt("code");
                            if (code == 200) {
                                VHInteractiveV2.this.mBroadcastId = broadcastid;
                                JSONObject data = result.optJSONObject("data");
                                ((VHInteractiveV2)VHInteractiveV2.this).mRoomParams.inavToken = data.getString("inav_token");
                                VHInteractiveV2.this.mPushUrl = data.getString("pushUrl");
                                JSONObject logObj = data.optJSONObject("log_info");
                                JSONArray permissions = data.optJSONArray("permission");
                                boolean initResult = VHInteractiveV2.this.doRtcInit(data.optString("type"), data.optString("sdk_app_id"));
                                if (initResult) {
                                    if (permissions != null && permissions.length() > 0) {
                                        for (int i = 0; i < permissions.length(); ++i) {
                                            VHInteractiveV2.this.mPermissions.add((String)permissions.get(i));
                                        }
                                    }
                                    LogInfo.getInstance().roomId = VHInteractiveV2.this.mRoomId;
                                    if (logObj != null) {
                                        LogInfo.getInstance().initBaseData(logObj);
                                    }
                                    VHInteractiveV2.this.mRtcInstance.setDataReport(new JSONObject(LogInfo.getInstance().toString()));
                                    if (((VHInteractiveV2)VHInteractiveV2.this).mRoomParams.type.equals("1") && !Utils.verifyToken(((VHInteractiveV2)VHInteractiveV2.this).mRoomParams.inavToken) && null != callback) {
                                        callback.onFailure(-1, "token error: " + ((VHInteractiveV2)VHInteractiveV2.this).mRoomParams.inavToken);
                                        VHInteractiveV2.this.trackInitEvent();
                                        return;
                                    }
                                    if (callback != null) {
                                        callback.onSuccess();
                                    }
                                    VHInteractiveV2.this.trackInitEvent();
                                } else if (callback != null) {
                                    callback.onFailure(11001, "SDK\u4e0d\u5b58\u5728\uff0c\u8bf7\u53c2\u8003\u5b98\u65b9\u96c6\u6210\u624b\u518c");
                                    return;
                                }
                            } else {
                                if (callback != null) {
                                    callback.onFailure(code, msg);
                                }
                                VHInteractiveV2.this.trackInitEvent(code + ":" + msg);
                            }
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                            if (callback != null) {
                                callback.onFailure(-1, "Request data exception");
                            }
                            VHInteractiveV2.this.trackInitEvent("-2");
                        }
                    }
                });
            }
        });
    }

    private boolean doRtcInit(String type, String trtcSdkAppId) {
        if (!TextUtils.isEmpty((CharSequence)trtcSdkAppId)) {
            try {
                this.mRoomParams.trtcSdkAppId = Integer.parseInt(trtcSdkAppId);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        if (null != this.mRtcInstance && this.mRoomParams.type.equals(type)) {
            return true;
        }
        this.mRoomParams.type = type;
        this.mRtcInstance = VHInteractiveFactory.newRTC(this.mContext, this.mRoomParams);
        return null != this.mRtcInstance;
    }

    public void addExtraLogParam(String s) {
        LogInfo.getInstance().setExtraData(s);
    }

    public void enterRoom(String attribute) {
        this.enterRoom(true, true, attribute);
    }

    public void enterRoom(boolean autoPublish, boolean autoSubscribe, String attribute) {
        if (null != this.mRtcInstance) {
            if (!this.isPushAvailable()) {
                autoPublish = false;
            }
            VhallBaseSDK.getInstance().join((IVHService)this);
            this.mRtcInstance.enterRoom(this.mRoomParams, autoPublish, autoSubscribe, attribute, this.mRoomListener);
        } else {
            VLog.e((String)TAG, (String)"enterRoom#please call VHInteractiveV2#init first");
        }
    }

    public void createLocalStream(IVHRTCRenderView renderView, VRTCParams.VRTCVideoEncodeParam videoParam, VRTCParams.VRTCStreamParam streamParam) {
        if (null == streamParam) {
            throw new IllegalArgumentException("streamParam should not be null");
        }
        if (null != this.mRtcInstance) {
            this.mRtcInstance.startLocalPreview(renderView, videoParam, streamParam, true);
        } else {
            VLog.e((String)TAG, (String)"createLocalStream#please call VHInteractiveV2#init first");
        }
    }

    public void createRemoteView(IVHRTCRenderView renderView, String streamId) {
        if (null != this.mRtcInstance) {
            this.mRtcInstance.startRemoteView(renderView, streamId);
        } else {
            VLog.e((String)TAG, (String)"createLocalStream#please call VHInteractiveV2#init first");
        }
    }

    public void createScreenShareStream(MediaProjection mediaProjection, VRTCParams.VRTCVideoEncodeParam videoParam, VRTCParams.VRTCStreamParam streamParam) {
        if (null == streamParam) {
            throw new IllegalArgumentException("streamParam should not be null");
        }
        if (null != this.mRtcInstance) {
            this.mRtcInstance.createScreenShareStream(mediaProjection, videoParam, streamParam);
        } else {
            VLog.e((String)TAG, (String)"createLocalStream#please call VHInteractiveV2#init first");
        }
    }

    public void stopScreenShare() {
        if (null != this.mRtcInstance) {
            this.mRtcInstance.stopScreenShare();
        } else {
            VLog.e((String)TAG, (String)"stopScreenShare#please call VHInteractiveV2#init first");
        }
    }

    public String getUserIdByStreamId(String streamId) {
        if (null != this.mRtcInstance) {
            return this.mRtcInstance.getUserIdByStreamId(streamId);
        }
        return "";
    }

    public boolean publish() {
        if (this.isPushAvailable()) {
            if (null == this.mRtcInstance) {
                VLog.e((String)TAG, (String)"publish#please call VHInteractiveV2#init first");
                return false;
            }
            this.mRtcInstance.publish();
            return true;
        }
        VLog.e((String)TAG, (String)"Do not have publish permission.");
        return false;
    }

    public void unPublish() {
        if (null == this.mRtcInstance) {
            VLog.e((String)TAG, (String)"unpublish#please call VHInteractiveV2#init first");
            return;
        }
        this.mRtcInstance.unPublish();
    }

    public void subscribe(String streamId) {
        if (null == this.mRtcInstance) {
            VLog.e((String)TAG, (String)"subscribe#please call VHInteractiveV2#init first");
            return;
        }
        this.mRtcInstance.subscribe(streamId);
    }

    public void unSubscribe(String streamId) {
        if (null == this.mRtcInstance) {
            VLog.e((String)TAG, (String)"subscribe#please call VHInteractiveV2#init first");
            return;
        }
        this.mRtcInstance.unSubscribe(streamId);
    }

    public void leaveRoom() {
        if (null == this.mRtcInstance) {
            VLog.e((String)TAG, (String)"leaveRoom#please call VHInteractiveV2#init first");
            return;
        }
        this.mRtcInstance.leaveRoom();
        VhallBaseSDK.getInstance().leave((IVHService)this);
        VHInteractiveApi.onLeave(this.mRoomId, this.mAccessToken);
    }

    public void forceLeaveRoom(String userid, Callback callback) {
        if (userid == null) {
            userid = VhallBaseSDK.getInstance().getmUserId();
        }
        VHInteractiveApi.forceLeaveRoom(this.mRoomId, this.mAccessToken, userid, callback);
    }

    public void broadcastRoom(VRTCParams.VRTCBroadcastParam broadcastParam, ICallback callback) {
        if (null != this.mRtcInstance) {
            if (!this.isBrocastRoomAvailable()) {
                if (callback != null) {
                    callback.onFailure(10002, "\u8bf7\u5f00\u901a\u8bbe\u7f6e\u65c1\u8def\u6743\u9650");
                }
                return;
            }
            if (null != broadcastParam) {
                if (TextUtils.isEmpty((CharSequence)this.mBroadcastId)) {
                    if (callback != null) {
                        callback.onFailure(10000, "\u672a\u8bbe\u7f6e\u65c1\u8defID");
                    }
                    return;
                }
                if (TextUtils.isEmpty((CharSequence)this.mPushUrl)) {
                    if (callback != null) {
                        callback.onFailure(10001, "\u65c1\u8def\u63a8\u6d41\u5730\u5740\u4e3a\u7a7a");
                    }
                    return;
                }
                this.mBroadcastParams = new VRTCParams.VRTCBroadcastParamInner(broadcastParam);
                this.mBroadcastParams.inavRoomId = this.mRoomId;
                this.mBroadcastParams.broadcastRoomId = this.mBroadcastId;
                this.mBroadcastParams.pushUrl = this.mPushUrl;
                this.mBroadcastParams.isAdaptiveLayoutMode = broadcastParam.layoutMode >= 1000;
                this.mBroadcastParams.compat_layout_mode = Utils.compatAdaptiveLayoutMode(broadcastParam.layoutMode);
                try {
                    this.mBroadcastParams.compat_profile_json = Utils.compatBroadcastProfile(broadcastParam.profile);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            } else {
                this.mBroadcastParams = null;
            }
            this.mRtcInstance.broadcastRoom(this.mBroadcastParams, this.mAccessToken, callback);
        }
    }

    public void stopBroadcastRoom(ICallback callback) {
        this.broadcastRoom(null, callback);
    }

    public void setMixLayoutMainScreen(String streamId, ICallback callback) {
        if (null != this.mRtcInstance) {
            this.mRtcInstance.setMixLayoutMainScreen(streamId, callback);
        }
    }

    public boolean isInternalStreamDocCloudRender(JSONObject config) {
        return null != config && config.has("type") && config.optString("type").equals("doc-cloud-render");
    }

    @Deprecated
    public void broadcastLayout(int layout, ICallback callback) {
        this.setMixLayoutMode(layout, callback);
    }

    public void setMixLayoutMode(int layoutMode, ICallback callback) {
        if (null == this.mBroadcastParams) {
            callback.onFailure(10001, "\u8bf7\u5148\u5f00\u542f\u65c1\u8def");
            return;
        }
        if (!this.isBrocastRoomAvailable()) {
            if (callback != null) {
                callback.onFailure(10002, "\u8bf7\u5f00\u901a\u8bbe\u7f6e\u65c1\u8def\u6743\u9650");
            }
            return;
        }
        if (null != this.mRtcInstance) {
            this.mRtcInstance.setMixLayoutMode(this.mBroadcastParams, layoutMode, callback);
        }
    }

    public void setMixBackgroundColor(String hexColor, ICallback callback) {
        if (null == this.mBroadcastParams) {
            callback.onFailure(10001, "\u8bf7\u5148\u5f00\u542f\u65c1\u8def");
            return;
        }
        if (null != this.mRtcInstance) {
            this.mRtcInstance.setMixBackgroundColor(this.mBroadcastParams, hexColor, callback);
        }
    }

    public void setMixBorderColor(VRTCParams.VRTCBroadcastParam.Border border, ICallback callback) {
        if (null != this.mRtcInstance) {
            this.mRtcInstance.setMixBorderColor(border, callback);
        }
    }

    public void setMixBackgroundImage(String url, int cropType, ICallback callback) {
        if (null == this.mBroadcastParams) {
            callback.onFailure(10001, "\u8bf7\u5148\u5f00\u542f\u65c1\u8def");
            return;
        }
        if (null != this.mRtcInstance) {
            this.mRtcInstance.setMixBackgroundImage(this.mBroadcastParams, url, cropType, callback);
        }
    }

    public void setMixPlaceholderImage(String url, ICallback callback) {
        if (null != this.mRtcInstance) {
            this.mRtcInstance.setMixPlaceholderImage(url, callback);
        }
    }

    public void startDocCloudRender(String channelId, ICallback callback) {
        if (null != this.mRtcInstance) {
            this.mRtcInstance.docCloudRender(VhallBaseSDK.getInstance().getAPP_ID(), channelId, true, callback);
        }
    }

    public void stopDocCloudRender(String channelId, ICallback callback) {
        if (null != this.mRtcInstance) {
            this.mRtcInstance.docCloudRender(VhallBaseSDK.getInstance().getAPP_ID(), channelId, false, callback);
        }
    }

    public void setScaleType(int scaleType) {
        if (null != this.mRtcInstance) {
            this.mRtcInstance.setScaleType(scaleType);
        }
    }

    public void updateVideoResolution(int videoProfile) {
        if (null != this.mRtcInstance) {
            this.mRtcInstance.setVideoResolution(videoProfile);
        }
    }

    public void muteVideo(String streamId, boolean mute) {
        if (null != this.mRtcInstance) {
            this.mRtcInstance.muteVideo(streamId, mute);
        }
    }

    public void muteAudio(String streamId, boolean mute) {
        if (null != this.mRtcInstance) {
            this.mRtcInstance.muteAudio(streamId, mute);
        }
    }

    public void switchCamera() {
        if (null != this.mRtcInstance) {
            this.mRtcInstance.switchCamera();
        }
    }

    public boolean isFrontCamera() {
        if (null != this.mRtcInstance) {
            return this.mRtcInstance.isFrontCamera();
        }
        return false;
    }

    public void setMirror(boolean isMirror) {
        if (null != this.mRtcInstance) {
            this.mRtcInstance.setMirror(isMirror);
        }
    }

    public void switchAutoFocusMode(boolean enableAuto, ISwitchFocusModeListener switchFocusModeListener) {
        if (null != this.mRtcInstance) {
            this.mRtcInstance.switchAutoFocusMode(enableAuto, switchFocusModeListener);
        }
    }

    public Set<String> getPermissions() {
        return this.mPermissions;
    }

    public String getChannelId() {
        return this.mRoomId;
    }

    public String getAccessToken() {
        return this.mAccessToken;
    }

    public void onConnectStateChanged(ConnectServer.State state, int serverType) {
        if (this.mOnConnectChangedListener != null) {
            this.mOnConnectChangedListener.onStateChanged(state, serverType);
        }
    }

    public void onMessage(String msg) {
        if (TextUtils.isEmpty((CharSequence)msg)) {
            return;
        }
        VLog.d((String)TAG, (String)("onMsg:" + msg));
        try {
            JSONObject result = new JSONObject(msg);
            String event = result.optString("event");
            if (this.mMessageListener != null) {
                this.mMessageListener.onRefreshMemberState();
            }
            if (event.equals("Join")) {
                this.mRtcInstance.setDataReport(new JSONObject(LogInfo.getInstance().toString()));
            }
            if (!event.equals("Inav")) {
                JSONObject text = !TextUtils.isEmpty((CharSequence)result.optString("text")) ? new JSONObject(URLDecoder.decode(result.optString("text"))) : result;
                if (this.mMessageListener != null && text != null) {
                    this.mMessageListener.onRefreshMembers(text);
                }
                return;
            }
            JSONObject data = result.getJSONObject("data");
            String dataEvent = data.getString("inav_event");
            String userId = data.optString("third_party_user_id");
            switch (dataEvent) {
                case "apply_inav_publish": {
                    if (userId.equals(VhallBaseSDK.getInstance().mUserId) || !this.isCheckReqAvailable() || this.mMessageListener == null) break;
                    this.mMessageListener.onMessage(data);
                    break;
                }
                case "audit_inav_publish": {
                    if (!userId.equals(VhallBaseSDK.getInstance().mUserId)) break;
                    int status = data.getInt("status");
                    if (status == 1) {
                        this.mPermissions.add("publish_inav_stream");
                    } else {
                        this.mPermissions.remove("publish_inav_stream");
                    }
                    if (this.mMessageListener != null) {
                        this.mMessageListener.onMessage(data);
                    }
                    break;
                }
                case "askfor_inav_publish": {
                    if (!userId.equals(VhallBaseSDK.getInstance().mUserId)) break;
                    this.mPermissions.add("publish_inav_stream");
                    if (this.mMessageListener == null) break;
                    this.mMessageListener.onMessage(data);
                    break;
                }
                case "kick_inav_stream": {
                    if (!userId.equals(VhallBaseSDK.getInstance().mUserId)) break;
                    this.unPublish();
                    this.mPermissions.remove("publish_inav_stream");
                    if (this.mMessageListener == null) break;
                    this.mMessageListener.onMessage(data);
                    break;
                }
                case "kick_inav": {
                    if (!userId.equals(VhallBaseSDK.getInstance().mUserId)) break;
                    this.mPermissions.remove("publish_inav_stream");
                    this.leaveRoom();
                    if (this.mMessageListener == null) break;
                    this.mMessageListener.onMessage(data);
                    break;
                }
                case "force_leave_inav": {
                    if (!userId.equals(VhallBaseSDK.getInstance().mUserId)) break;
                    this.leaveRoom();
                    if (this.mMessageListener == null) break;
                    this.mMessageListener.onMessage(data);
                    break;
                }
                case "user_publish_callback": {
                    if (this.mMessageListener == null) break;
                    this.mMessageListener.onMessage(data);
                    break;
                }
                case "inav_close": {
                    this.leaveRoom();
                    if (this.mMessageListener == null) break;
                    this.mMessageListener.onMessage(data);
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void getMembers(Callback callback) {
        if (TextUtils.isEmpty((CharSequence)this.mRoomId)) {
            return;
        }
        VHInteractiveApi.getRoomMember(this.mRoomId, this.mAccessToken, callback);
    }

    public boolean isKickoutStreamAvailable() {
        return this.mPermissions != null && this.mPermissions.contains("kick_inav_stream");
    }

    public boolean isKickoutRoomAvailable() {
        return this.mPermissions != null && this.mPermissions.contains("kick_inav");
    }

    public boolean isBrocastRoomAvailable() {
        return this.mPermissions != null && this.mPermissions.contains("publish_inav_another");
    }

    public String getToken() {
        return null == this.mRoomParams ? null : this.mRoomParams.inavToken;
    }

    @Deprecated
    public boolean isReqPushAvailable() {
        return this.mPermissions != null && this.mPermissions.contains("apply_inav_publish");
    }

    public boolean isPushAvailable() {
        if (this.mMode.equals("live") && this.mRole.equals("viewer")) {
            return false;
        }
        return this.mPermissions != null && this.mPermissions.contains("publish_inav_stream");
    }

    public boolean isInviteAvailable() {
        return this.mPermissions != null && this.mPermissions.contains("askfor_inav_publish");
    }

    public boolean isCheckReqAvailable() {
        return this.mPermissions != null && this.mPermissions.contains("audit_inav_publish");
    }

    public void release() {
        VhallBaseSDK.getInstance().leave((IVHService)this);
        VHInteractiveApi.onLeave(this.mRoomId, this.mAccessToken);
        if (null != this.mRtcInstance) {
            this.mRtcInstance.release();
            this.mRtcInstance = null;
        } else {
            VLog.e((String)TAG, (String)"please call VHInteractiveV2#init first");
        }
        this.mRoomParams = null;
        this.mBroadcastParams = null;
    }

    private void trackInitEvent(String error) {
        JSONObject params = new JSONObject();
        try {
            params.put("inavId", (Object)this.mRoomId);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        LogReporter.getInstance().setErr(error);
        LogReporter.getInstance().onCollection("2007", false, params);
    }

    private void trackInitEvent() {
        JSONObject params = new JSONObject();
        try {
            params.put("inavId", (Object)this.mRoomId);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        LogReporter.getInstance().onCollection("2007", params);
    }

    public static interface OnMessageListener {
        public void onMessage(JSONObject var1);

        public void onRefreshMemberState();

        public void onRefreshMembers(JSONObject var1);
    }
}

