/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.ilss;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import com.vhall.framework.VhallSDK;
import com.vhall.framework.connect.IVHService;
import com.vhall.framework.connect.VhallConnectService;
import com.vhall.ilss.VHInteractiveApi;
import com.vhall.logmanager.L;
import com.vhall.logmanager.LogInfo;
import com.vhall.logmanager.LogReporter;
import com.vhall.logmanager.VLog;
import com.vhall.message.ConnectServer;
import com.vhall.rtc.Utils;
import com.vhall.rtc.VhallRTC;
import com.vhall.vhallrtc.client.FinishCallback;
import com.vhall.vhallrtc.client.Room;
import com.vhall.vhallrtc.client.Stream;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class VHInteractive
extends VhallRTC
implements IVHService {
    private static final String TAG = "VHInteractive";
    public static final String kick_inav = "kick_inav";
    public static final String force_leave_inav = "force_leave_inav";
    public static final String kick_inav_stream = "kick_inav_stream";
    public static final String publish_inav_another = "publish_inav_another";
    public static final String apply_inav_publish = "apply_inav_publish";
    public static final String publish_inav_stream = "publish_inav_stream";
    public static final String askfor_inav_publish = "askfor_inav_publish";
    public static final String audit_inav_publish = "audit_inav_publish";
    public static final String user_publish_callback = "user_publish_callback";
    public static final String inav_close = "inav_close";
    public static final String MODE_RTC = "rtc";
    public static final String MODE_LIVE = "live";
    public static final String ROLE_HOST = "administrator";
    public static final String ROLE_AUDIENCE = "viewer";
    public static final int BROADCAST_VIDEO_PROFILE_480P_0 = 0;
    public static final int BROADCAST_VIDEO_PROFILE_480P_1 = 1;
    public static final int BROADCAST_VIDEO_PROFILE_540P_0 = 2;
    public static final int BROADCAST_VIDEO_PROFILE_540P_1 = 3;
    public static final int BROADCAST_VIDEO_PROFILE_720P_0 = 4;
    public static final int BROADCAST_VIDEO_PROFILE_720P_1 = 5;
    public static final int BROADCAST_VIDEO_PROFILE_960P_0 = 6;
    public static final int BROADCAST_VIDEO_PROFILE_960P_1 = 7;
    public static final int BROADCAST_VIDEO_PROFILE_1080P_0 = 8;
    public static final int BROADCAST_VIDEO_PROFILE_1080P_1 = 9;
    public static final int BROADCAST_VIDEO_PROFILE_480P_1_VERTICAL = 10;
    public static final int BROADCAST_VIDEO_PROFILE_540P_1_VERTICAL = 11;
    public static final int BROADCAST_VIDEO_PROFILE_720P_1_VERTICAL = 12;
    public static final int BROADCAST_VIDEO_PROFILE_1080P_1_VERTICAL = 13;
    public static final int CANVAS_LAYOUT_PATTERN_GRID_1 = 0;
    public static final int CANVAS_LAYOUT_PATTERN_GRID_2_H = 1;
    public static final int CANVAS_LAYOUT_PATTERN_GRID_3_E = 2;
    public static final int CANVAS_LAYOUT_PATTERN_GRID_3_D = 3;
    public static final int CANVAS_LAYOUT_PATTERN_GRID_4_M = 4;
    public static final int CANVAS_LAYOUT_PATTERN_GRID_5_D = 5;
    public static final int CANVAS_LAYOUT_PATTERN_GRID_6_E = 6;
    public static final int CANVAS_LAYOUT_PATTERN_GRID_9_E = 7;
    public static final int CANVAS_LAYOUT_PATTERN_FLOAT_2_1DR = 8;
    public static final int CANVAS_LAYOUT_PATTERN_FLOAT_2_1DL = 9;
    public static final int CANVAS_LAYOUT_PATTERN_FLOAT_3_2DL = 10;
    public static final int CANVAS_LAYOUT_PATTERN_FLOAT_6_5D = 11;
    public static final int CANVAS_LAYOUT_PATTERN_FLOAT_6_5T = 12;
    public static final int CANVAS_LAYOUT_PATTERN_TILED_5_1T4D = 13;
    public static final int CANVAS_LAYOUT_PATTERN_TILED_5_1D4T = 14;
    public static final int CANVAS_LAYOUT_PATTERN_TILED_5_1L4R = 15;
    public static final int CANVAS_LAYOUT_PATTERN_TILED_5_1R4L = 16;
    public static final int CANVAS_LAYOUT_PATTERN_TILED_6_1T5D = 17;
    public static final int CANVAS_LAYOUT_PATTERN_TILED_6_1D5T = 18;
    public static final int CANVAS_LAYOUT_PATTERN_TILED_9_1L8R = 19;
    public static final int CANVAS_LAYOUT_PATTERN_TILED_9_1R8L = 20;
    public static final int CANVAS_LAYOUT_PATTERN_TILED_13_1L12R = 21;
    public static final int CANVAS_LAYOUT_PATTERN_TILED_17_1TL16GRID = 22;
    public static final int CANVAS_LAYOUT_PATTERN_TILED_9_1D8T = 23;
    public static final int CANVAS_LAYOUT_PATTERN_TILED_13_1TL12GRID = 24;
    public static final int CANVAS_LAYOUT_PATTERN_TILED_17_1TL16GRID_E = 25;
    public static final int CANVAS_LAYOUT_PATTERN_CUSTOM = 27;
    public static final int CANVAS_LAYOUT_EX_PATTERN_GRID_12_E = 28;
    public static final int CANVAS_LAYOUT_EX_PATTERN_GRID_16_E = 29;
    public static final int CANVAS_LAYOUT_EX_PATTERN_FLOAT_2_1TR = 30;
    public static final int CANVAS_LAYOUT_EX_PATTERN_FLOAT_2_1TL = 31;
    public static final int CANVAS_ADAPTIVE_LAYOUT_UNDEFINED = 1000;
    public static final int CANVAS_ADAPTIVE_LAYOUT_GRID_MODE = 1001;
    public static final int CANVAS_ADAPTIVE_LAYOUT_TILED_MODE = 1002;
    public static final int CANVAS_ADAPTIVE_LAYOUT_FLOAT_MODE = 1003;
    public static final int CANVAS_ADAPTIVE_LAYOUT_TILED_TOP_MAX16 = 1004;
    public static final int CANVAS_ADAPTIVE_LAYOUT_MAX = 1005;
    private String mRoomId = "";
    private String mAccessToken = "";
    private String TOKEN = "";
    private String mBroadcastId = "";
    private String mPushUrl = "";
    private String mMode = "rtc";
    private String mRole = "administrator";
    private CopyOnWriteArraySet<String> mPermissions = new CopyOnWriteArraySet();
    private OnMessageListener mMessageListener;
    private VhallConnectService.OnConnectStateChangedListener mOnConnectChangedListener;
    private Room.RoomDelegate roomDelegate;
    private JSONObject mMixConfig = null;
    private Handler mHandler;
    public static final String MIX_INTERNALSTREAM_TYPE_DOC_CLOUD_RENDER = "doc-cloud-render";
    private Room.RoomDelegate delegate = new Room.RoomDelegate(){

        public void onDidConnect(Room room, JSONObject jsonObject) {
            if (VHInteractive.this.roomDelegate != null) {
                VHInteractive.this.roomDelegate.onDidConnect(room, jsonObject);
            }
        }

        public void onDidError(Room room, Room.VHRoomErrorStatus vhRoomErrorStatus, String s) {
            if (VHInteractive.this.roomDelegate != null) {
                VHInteractive.this.roomDelegate.onDidError(room, vhRoomErrorStatus, s);
            }
        }

        public void onDidPublishStream(Room room, Stream stream) {
            VHInteractiveApi.onStateChanged(VHInteractive.this.mRoomId, VHInteractive.this.mAccessToken, String.valueOf(((VHInteractive)VHInteractive.this).mLocalStream.streamId), 1, null);
            if (VHInteractive.this.roomDelegate != null) {
                VHInteractive.this.roomDelegate.onDidPublishStream(room, stream);
            }
        }

        public void onDidInternalStreamAdded(Room room, Stream stream) {
            if (VHInteractive.this.roomDelegate != null) {
                VHInteractive.this.roomDelegate.onDidInternalStreamAdded(room, stream);
            }
        }

        public void onDidInternalStreamRemoved(Room room, Stream stream) {
            if (VHInteractive.this.roomDelegate != null) {
                VHInteractive.this.roomDelegate.onDidInternalStreamRemoved(room, stream);
            }
        }

        public void onDidInternalStreamFailed(Room room, Stream stream, JSONObject msg) {
            if (VHInteractive.this.roomDelegate != null) {
                VHInteractive.this.roomDelegate.onDidInternalStreamFailed(room, stream, msg);
            }
        }

        public void onDidUnPublishStream(Room room, Stream stream) {
            if (VHInteractive.this.roomDelegate != null) {
                VHInteractive.this.roomDelegate.onDidUnPublishStream(room, stream);
            }
        }

        public void onDidSubscribeStream(Room room, Stream stream) {
            if (VHInteractive.this.roomDelegate != null) {
                VHInteractive.this.roomDelegate.onDidSubscribeStream(room, stream);
            }
        }

        public void onDidUnSubscribeStream(Room room, Stream stream) {
            if (VHInteractive.this.roomDelegate != null) {
                VHInteractive.this.roomDelegate.onDidUnSubscribeStream(room, stream);
            }
        }

        public void onDidChangeStatus(Room room, Room.VHRoomStatus vhRoomStatus) {
            if (VHInteractive.this.roomDelegate != null) {
                VHInteractive.this.roomDelegate.onDidChangeStatus(room, vhRoomStatus);
            }
            if (vhRoomStatus.getValue() == Room.VHRoomStatus.VHRoomStatusDisconnected.getValue() || vhRoomStatus.getValue() == Room.VHRoomStatus.VHRoomStatusError.getValue()) {
                VHInteractive.this.makeConnectReport("113301", "Room.VHRoomStatus=" + vhRoomStatus.getValue());
            }
        }

        public void onDidAddStream(Room room, Stream stream) {
            if (VHInteractive.this.roomDelegate != null) {
                VHInteractive.this.roomDelegate.onDidAddStream(room, stream);
            }
        }

        public void onDidRemoveStream(Room room, Stream stream) {
            if (VHInteractive.this.roomDelegate != null) {
                VHInteractive.this.roomDelegate.onDidRemoveStream(room, stream);
            }
        }

        public void onDidUpdateOfStream(Stream stream, JSONObject jsonObject) {
            if (VHInteractive.this.roomDelegate != null) {
                VHInteractive.this.roomDelegate.onDidUpdateOfStream(stream, jsonObject);
            }
        }

        public void onReconnect(int i, int i1) {
            if (VHInteractive.this.roomDelegate != null) {
                VHInteractive.this.roomDelegate.onReconnect(i, i1);
            }
        }

        public void onStreamMixed(JSONObject jsonObject) {
            if (VHInteractive.this.roomDelegate != null) {
                VHInteractive.this.roomDelegate.onStreamMixed(jsonObject);
            }
        }
    };
    private JSONObject _bgColorJSON = null;
    private JSONObject _boardColorJSON = null;

    public void setOnMessageListener(OnMessageListener listener) {
        this.mMessageListener = listener;
    }

    public void setOnConnectChangedListener(VhallConnectService.OnConnectStateChangedListener listener) {
        this.mOnConnectChangedListener = listener;
    }

    public void setMixLayoutMainScreen(String streamId, FinishCallback callback) {
        if (null != this.mRoom) {
            this.mRoom.setMixLayoutMainScreen(streamId, callback);
            JSONObject logConfig = new JSONObject();
            try {
                logConfig.put("stream_id", (Object)streamId);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            this.makeBroadcastReport("113306", logConfig);
        }
    }

    public boolean isInternalStreamDocCloudRender(JSONObject config) {
        return null != config && config.has("type") && config.optString("type").equals(MIX_INTERNALSTREAM_TYPE_DOC_CLOUD_RENDER);
    }

    public VHInteractive(Context context, Room.RoomDelegate listener) {
        this(context, listener, true, true);
    }

    public VHInteractive(Context context, Room.RoomDelegate listener, boolean softEchoCanceller) {
        this(context, listener, softEchoCanceller, true);
    }

    public VHInteractive(Context context, Room.RoomDelegate listener, boolean softEchoCanceller, boolean enableCpuoverusedetection) {
        super(context, softEchoCanceller, enableCpuoverusedetection);
        this.roomDelegate = listener;
        this.setListener(this.delegate);
        this.mHandler = new Handler(Looper.getMainLooper());
    }

    public void init(String roomid, String accessToken, InitCallback callback) {
        this.init(roomid, accessToken, null, callback);
    }

    public void init(String roomid, String accessToken, String broadcastid, InitCallback callback) {
        this.init(roomid, accessToken, broadcastid, MODE_RTC, ROLE_HOST, callback);
    }

    public void init(String roomid, String accessToken, String broadcastid, String mode, String role, InitCallback callback) {
        this.mRoomId = roomid;
        this.mMode = mode;
        this.mRole = role;
        if (TextUtils.isEmpty((CharSequence)this.mMode)) {
            this.mMode = MODE_RTC;
        }
        if (!this.mMode.equals(MODE_LIVE)) {
            this.mRole = ROLE_HOST;
        }
        this.mAccessToken = accessToken;
        this.getRoomInfo(roomid, accessToken, broadcastid, mode, role, callback);
    }

    private void getRoomInfo(String roomid, String accessToken, final String broadcastid, String mode, String role, final InitCallback callback) {
        VHInteractiveApi.getRoomInfo(roomid, accessToken, broadcastid, mode, role, new Callback(){

            public void onFailure(Call call, IOException e) {
                L.e((String)VHInteractive.TAG, (String)e.getMessage());
                VHInteractive.this.trackInitEvent("-1");
                VHInteractive.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            callback.onFailure(-1, "error network,please try later\uff01");
                        }
                    }
                });
            }

            public void onResponse(Call call, Response response) throws IOException {
                final String content = response.body().string();
                VHInteractive.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            JSONObject result = new JSONObject(content);
                            String msg = result.optString("msg");
                            int code = result.optInt("code");
                            if (code == 200) {
                                VHInteractive.this.mBroadcastId = broadcastid;
                                JSONObject data = result.optJSONObject("data");
                                String room_type = data.optString("type");
                                if (!room_type.equals("1")) {
                                    if (callback != null) {
                                        callback.onFailure(-1, "room type error");
                                    }
                                    return;
                                }
                                VHInteractive.this.TOKEN = data.getString("inav_token");
                                VHInteractive.this.mPushUrl = data.getString("pushUrl");
                                JSONObject logObj = data.optJSONObject("log_info");
                                JSONArray permissions = data.optJSONArray("permission");
                                if (permissions != null && permissions.length() > 0) {
                                    for (int i = 0; i < permissions.length(); ++i) {
                                        VHInteractive.this.mPermissions.add((String)permissions.get(i));
                                    }
                                }
                                LogInfo.getInstance().roomId = VHInteractive.this.mRoomId;
                                if (logObj != null) {
                                    LogInfo.getInstance().initBaseData(logObj);
                                }
                                VHInteractive.this.setDataReport(new JSONObject(LogInfo.getInstance().toString()));
                                if (!Utils.verifyToken(VHInteractive.this.TOKEN) && null != callback) {
                                    VHInteractive.this.trackInitEvent();
                                }
                                if (callback != null) {
                                    callback.onSuccess();
                                }
                                VHInteractive.this.trackInitEvent();
                            } else {
                                if (callback != null) {
                                    callback.onFailure(code, msg);
                                }
                                VHInteractive.this.trackInitEvent(code + ":" + msg);
                            }
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                            if (callback != null) {
                                callback.onFailure(-1, "Request data exception");
                            }
                            VHInteractive.this.trackInitEvent("-2");
                        }
                    }
                });
            }
        });
    }

    public void addExtraLogParam(String s) {
        LogInfo.getInstance().setExtraData(s);
    }

    public void enterRoom(String attribute) {
        if (!TextUtils.isEmpty((CharSequence)this.TOKEN)) {
            super.enterRoom(this.TOKEN, attribute);
            VhallSDK.getInstance().join((IVHService)this);
            this.makeConnectReport("113300", null);
        } else {
            VLog.e((String)TAG, (String)"token is null, please init first");
        }
    }

    public void publish() {
        if (this.isPushAvailable()) {
            super.publish();
        } else {
            Log.e((String)TAG, (String)"Do not have publish permission.");
        }
    }

    public void unpublish() {
        super.unpublish();
        if (this.mLocalStream != null) {
            VHInteractiveApi.onStateChanged(this.mRoomId, this.mAccessToken, String.valueOf(this.mLocalStream.streamId), 2, null);
        }
    }

    public void leaveRoom() {
        super.leaveRoom();
        VhallSDK.getInstance().leave((IVHService)this);
        VHInteractiveApi.onLeave(this.mRoomId, this.mAccessToken);
        this.makeConnectReport("113301", "call leaveRoom");
    }

    public void requestPublish(Callback callback) {
        if (this.isReqPushAvailable()) {
            VHInteractiveApi.reqPush(this.mRoomId, this.mAccessToken, callback);
        }
    }

    public void checkPublishRequest(String userid, int type, Callback callback) {
        if (this.isCheckReqAvailable()) {
            VHInteractiveApi.checkPushReq(this.mRoomId, this.mAccessToken, userid, type, callback);
        }
    }

    public void invitePublish(String userid, Callback callback) {
        if (this.isInviteAvailable()) {
            VHInteractiveApi.invitePush(this.mRoomId, this.mAccessToken, userid, callback);
        }
    }

    public void refusePublish() {
        if (this.mLocalStream != null) {
            VHInteractiveApi.onStateChanged(this.mRoomId, this.mAccessToken, String.valueOf(this.mLocalStream.streamId), 3, null);
        }
    }

    public void kickoutStream(String userid, Callback callback) {
        if (this.isKickoutStreamAvailable()) {
            VHInteractiveApi.kickoutPush(this.mRoomId, this.mAccessToken, userid, 1, callback);
        }
    }

    public void kickoutRoom(String userid, Callback callback) {
        if (this.isKickoutRoomAvailable()) {
            VHInteractiveApi.kickoutRoom(this.mRoomId, this.mAccessToken, userid, 1, callback);
        }
    }

    public void forceLeaveRoom(String userid, Callback callback) {
        if (userid == null) {
            userid = VhallSDK.getInstance().getmUserId();
        }
        VHInteractiveApi.forceLeaveRoom(this.mRoomId, this.mAccessToken, userid, callback);
    }

    public void broadcastRoom(int type, Callback callback) {
        this.broadcastRoom(type, 5, 13, callback);
    }

    public void broadcastRoom(int type, int layout, Callback callback) {
        this.broadcastRoom(type, 5, layout, callback);
    }

    public void broadcastRoom(int type, int dpi, int layout, Callback callback) {
        this.broadcastRoom(type, dpi, layout, false, callback);
    }

    public void broadcastRoom(int type, int dpi, int layout, boolean precast_pic_exist, Callback callback) {
        block2: {
            JSONObject config = new JSONObject();
            try {
                config.put("profile", (Object)Room.getProfile((int)dpi));
                config.put("layoutMode", layout);
                config.put("precast_pic_exist", precast_pic_exist);
                this.broadcastRoom(type, config, callback);
            }
            catch (JSONException e) {
                e.printStackTrace();
                if (callback == null) break block2;
                callback.onFailure(null, new IOException(e.getMessage()));
            }
        }
    }

    public void broadcastRoom(int type, JSONObject config, final Callback callback) {
        final JSONObject tempConfig = null != config ? config : new JSONObject();
        if (tempConfig.has("layoutMode")) {
            try {
                int tempLayoutMode = tempConfig.getInt("layoutMode");
                if (tempLayoutMode >= 1000) {
                    tempConfig.remove("layoutMode");
                    tempConfig.put("adaptiveLayoutMode", tempLayoutMode - 1000);
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        if (TextUtils.isEmpty((CharSequence)this.mBroadcastId) || TextUtils.isEmpty((CharSequence)this.mPushUrl)) {
            if (callback != null) {
                callback.onFailure(null, new IOException("\u672a\u8bbe\u7f6e\u65c1\u8def\u4fe1\u606f"));
            }
            return;
        }
        if (!this.isBrocastRoomAvailable()) {
            if (callback != null) {
                callback.onFailure(null, new IOException("\u8bf7\u5f00\u901a\u8bbe\u7f6e\u65c1\u8def\u6743\u9650"));
            }
            return;
        }
        if (type == 1) {
            try {
                tempConfig.put("publishUrl", (Object)this.mPushUrl);
                if (!tempConfig.has("nickName")) {
                    JSONObject nickName = new JSONObject();
                    nickName.put("display", true);
                    tempConfig.put("nickName", (Object)nickName);
                }
                this.boundPreConfigColor(tempConfig);
                this.configRoomBroadCast(tempConfig, null, new FinishCallback(){

                    public void onFinish(int code, String message) {
                        VHInteractive.this.mMixConfig = tempConfig;
                        if (code != 200) {
                            if (callback != null) {
                                callback.onFailure(null, new IOException(message));
                            }
                        } else if (callback != null) {
                            try {
                                callback.onResponse(null, null);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                });
                this.makeBroadcastReport("113305", tempConfig);
            }
            catch (JSONException e) {
                e.printStackTrace();
                if (callback != null) {
                    callback.onFailure(null, new IOException(e.getMessage()));
                }
            }
        } else if (type == 2) {
            this.stopRoomBroadCast(null, new FinishCallback(){

                public void onFinish(int code, String message) {
                    if (code != 200) {
                        if (callback != null) {
                            callback.onFailure(null, new IOException(message));
                        }
                    } else if (callback != null) {
                        try {
                            callback.onResponse(null, null);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
        }
    }

    private void boundPreConfigColor(JSONObject baseConfig) {
        if (null != this._bgColorJSON) {
            try {
                baseConfig.put("backgroundColor", this._bgColorJSON.opt("backgroundColor"));
                this._bgColorJSON = null;
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        if (null != this._boardColorJSON) {
            try {
                baseConfig.put("border", this._boardColorJSON.opt("border"));
                this._boardColorJSON = null;
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    public void broadcastLayout(int layout, final Callback callback) {
        if (!this.isBrocastRoomAvailable()) {
            if (callback != null) {
                callback.onFailure(null, new IOException("\u8bf7\u5f00\u901a\u8bbe\u7f6e\u65c1\u8def\u6743\u9650"));
            }
            return;
        }
        this.setMixLayoutMode(layout, null, new FinishCallback(){

            public void onFinish(int code, String message) {
                if (code != 200) {
                    if (callback != null) {
                        callback.onFailure(null, new IOException(message));
                    }
                } else if (callback != null) {
                    try {
                        callback.onResponse(null, null);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    public void setMixLayoutMode(int layoutMode, String mode, FinishCallback finish) {
        super.setMixLayoutMode(layoutMode, mode, finish);
        if (null != this.mMixConfig) {
            if (layoutMode >= 1000) {
                try {
                    this.mMixConfig.remove("layoutMode");
                    this.mMixConfig.put("adaptiveLayoutMode", layoutMode - 1000);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    this.mMixConfig.put("layoutMode", layoutMode);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void subscribeStream(Stream stream) {
        super.subscribeStream(stream);
        JSONObject logConfig = new JSONObject();
        try {
            logConfig.put("stream_id", (Object)stream.streamId);
            logConfig.put("attr", (Object)stream.getAttributes());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.makeBroadcastReport("113308", logConfig);
    }

    public void setRoomBroadCastBackgroundImage(String url, int cropType, FinishCallback callback) {
        super.setRoomBroadCastBackgroundImage(url, cropType, callback);
        JSONObject logConfig = new JSONObject();
        try {
            logConfig.put("img", (Object)url);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.makeBroadcastReport("113307", logConfig);
    }

    public void setRoomBroadCastBackgroundColor(String hexColor, FinishCallback callback) {
        block9: {
            String bgColor = "0x333338";
            if (!TextUtils.isEmpty((CharSequence)hexColor)) {
                bgColor = hexColor;
                if (hexColor.startsWith("#")) {
                    bgColor = hexColor.replace("#", "0x");
                } else if (!hexColor.startsWith("0x")) {
                    bgColor = "0x".concat(hexColor);
                }
            }
            if (null != this.mRoom) {
                try {
                    if (null != this.mMixConfig) {
                        this.mMixConfig.put("backgroundColor", (Object)bgColor);
                        this.mRoom.configRoomBroadCast(this.mMixConfig, null, callback);
                        break block9;
                    }
                    this._bgColorJSON = new JSONObject();
                    this._bgColorJSON.put("backgroundColor", (Object)bgColor);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            } else {
                Log.e((String)TAG, (String)"Room is null");
            }
        }
    }

    public void resetRoomBroadCastBackgroundColor(FinishCallback callback) {
        this.setRoomBroadCastBackgroundColor("0x333338", callback);
    }

    private void setRoomBroadCastBorderColor(boolean enable, int width, String hexColor, boolean transparent, FinishCallback callback) {
        if (null != this.mRoom) {
            if (!enable) {
                try {
                    if (null != this.mMixConfig) {
                        JSONObject border = new JSONObject();
                        border.put("exist", false);
                        this.mMixConfig.put("border", (Object)border);
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            } else {
                String bgColor = "0x555657";
                if (!TextUtils.isEmpty((CharSequence)hexColor)) {
                    bgColor = hexColor;
                    if (hexColor.startsWith("#")) {
                        bgColor = hexColor.replace("#", "0x");
                    } else if (!hexColor.startsWith("0x")) {
                        bgColor = "0x".concat(hexColor);
                    }
                }
                if (width > 8) {
                    width = 8;
                } else if (width < 1) {
                    width = 0;
                }
                try {
                    JSONObject border = new JSONObject();
                    border.put("exist", true);
                    border.put("width", width);
                    border.put("color", (Object)bgColor);
                    border.put("transparency", transparent ? 100 : 0);
                    if (null != this.mMixConfig) {
                        this.mMixConfig.put("border", (Object)border);
                    } else {
                        this._boardColorJSON = new JSONObject();
                        this._boardColorJSON.put("border", (Object)border);
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            if (null != this.mMixConfig) {
                this.mRoom.configRoomBroadCast(this.mMixConfig, null, callback);
            }
        } else {
            Log.e((String)TAG, (String)"Room is null");
        }
    }

    public void setRoomBroadCastBorderColor(int width, String hexColor, FinishCallback callback) {
        this.setRoomBroadCastBorderColor(width, hexColor, false, callback);
    }

    public void setRoomBroadCastBorderColor(int width, String hexColor, boolean transparent, FinishCallback callback) {
        this.setRoomBroadCastBorderColor(true, width, hexColor, transparent, callback);
    }

    public void resetRoomBroadCastBorderColor(FinishCallback callback) {
        this.setRoomBroadCastBorderColor(false, 0, null, false, callback);
    }

    public Set<String> getPermissions() {
        return this.mPermissions;
    }

    public String getChannelId() {
        return this.mRoomId;
    }

    public String getAccessToken() {
        return this.mAccessToken;
    }

    public void onConnectStateChanged(ConnectServer.State state, int serverType) {
        if (this.mOnConnectChangedListener != null) {
            this.mOnConnectChangedListener.onStateChanged(state, serverType);
        }
    }

    public void onMessage(String msg) {
        if (TextUtils.isEmpty((CharSequence)msg)) {
            return;
        }
        Log.i((String)TAG, (String)("onMsg:" + msg));
        try {
            JSONObject result = new JSONObject(msg);
            String event = result.optString("event");
            if (this.mMessageListener != null) {
                this.mMessageListener.onRefreshMemberState();
            }
            if (!event.equals("Inav")) {
                JSONObject text = !TextUtils.isEmpty((CharSequence)result.optString("text")) ? new JSONObject(URLDecoder.decode(result.optString("text"))) : result;
                if (this.mMessageListener != null && text != null) {
                    this.mMessageListener.onRefreshMembers(text);
                }
                return;
            }
            JSONObject data = result.getJSONObject("data");
            String dataEvent = data.getString("inav_event");
            String userId = data.optString("third_party_user_id");
            switch (dataEvent) {
                case "apply_inav_publish": {
                    if (userId.equals(VhallSDK.getInstance().mUserId) || !this.isCheckReqAvailable() || this.mMessageListener == null) break;
                    this.mMessageListener.onMessage(data);
                    break;
                }
                case "audit_inav_publish": {
                    if (!userId.equals(VhallSDK.getInstance().mUserId)) break;
                    int status = data.getInt("status");
                    if (status == 1) {
                        this.mPermissions.add(publish_inav_stream);
                    } else {
                        this.mPermissions.remove(publish_inav_stream);
                    }
                    if (this.mMessageListener != null) {
                        this.mMessageListener.onMessage(data);
                    }
                    break;
                }
                case "askfor_inav_publish": {
                    if (!userId.equals(VhallSDK.getInstance().mUserId)) break;
                    this.mPermissions.add(publish_inav_stream);
                    if (this.mMessageListener == null) break;
                    this.mMessageListener.onMessage(data);
                    break;
                }
                case "kick_inav_stream": {
                    if (!userId.equals(VhallSDK.getInstance().mUserId)) break;
                    this.unpublish();
                    this.mPermissions.remove(publish_inav_stream);
                    if (this.mMessageListener == null) break;
                    this.mMessageListener.onMessage(data);
                    break;
                }
                case "kick_inav": {
                    if (!userId.equals(VhallSDK.getInstance().mUserId)) break;
                    this.mPermissions.remove(publish_inav_stream);
                    this.leaveRoom();
                    if (this.mMessageListener == null) break;
                    this.mMessageListener.onMessage(data);
                    break;
                }
                case "force_leave_inav": {
                    if (!userId.equals(VhallSDK.getInstance().mUserId)) break;
                    this.leaveRoom();
                    if (this.mMessageListener == null) break;
                    this.mMessageListener.onMessage(data);
                    break;
                }
                case "user_publish_callback": {
                    if (this.mMessageListener == null) break;
                    this.mMessageListener.onMessage(data);
                    break;
                }
                case "inav_close": {
                    this.leaveRoom();
                    if (this.mMessageListener == null) break;
                    this.mMessageListener.onMessage(data);
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void getMembers(Callback callback) {
        if (TextUtils.isEmpty((CharSequence)this.mRoomId)) {
            return;
        }
        VHInteractiveApi.getRoomMember(this.mRoomId, this.mAccessToken, callback);
    }

    public boolean isKickoutStreamAvailable() {
        return this.mPermissions != null && this.mPermissions.contains(kick_inav_stream);
    }

    public boolean isKickoutRoomAvailable() {
        return this.mPermissions != null && this.mPermissions.contains(kick_inav);
    }

    public boolean isBrocastRoomAvailable() {
        return this.mPermissions != null && this.mPermissions.contains(publish_inav_another);
    }

    public String getToken() {
        return this.TOKEN;
    }

    public boolean isReqPushAvailable() {
        return this.mPermissions != null && this.mPermissions.contains(apply_inav_publish);
    }

    public boolean isPushAvailable() {
        if (this.mMode.equals(MODE_LIVE) && this.mRole.equals(ROLE_AUDIENCE)) {
            return false;
        }
        return this.mPermissions != null && this.mPermissions.contains(publish_inav_stream);
    }

    public boolean isInviteAvailable() {
        return this.mPermissions != null && this.mPermissions.contains(askfor_inav_publish);
    }

    public boolean isCheckReqAvailable() {
        return this.mPermissions != null && this.mPermissions.contains(audit_inav_publish);
    }

    public void release() {
        super.release();
        VhallSDK.getInstance().leave((IVHService)this);
        VHInteractiveApi.onLeave(this.mRoomId, this.mAccessToken);
    }

    private void trackInitEvent(String error) {
        JSONObject params = new JSONObject();
        try {
            params.put("inavId", (Object)this.mRoomId);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        LogReporter.getInstance().setErr(error);
        LogReporter.getInstance().onCollection("2007", false, params);
    }

    private void trackInitEvent() {
        JSONObject params = new JSONObject();
        try {
            params.put("inavId", (Object)this.mRoomId);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        LogReporter.getInstance().onCollection("2007", params);
    }

    private void makeConnectReport(String event, String reason) {
        JSONObject pushConfig = new JSONObject();
        try {
            pushConfig.put("inav_id", (Object)this.mRoomId);
            pushConfig.put("user_id", (Object)VhallSDK.getInstance().mUserId);
            pushConfig.put("third_user_id", (Object)VhallSDK.getInstance().mUserId);
            if (!TextUtils.isEmpty((CharSequence)reason)) {
                pushConfig.put("reason", (Object)reason);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        LogReporter.getInstance().onCollectionWithBData(event, pushConfig);
    }

    private void makeBroadcastReport(String event, JSONObject param) {
        LogReporter.getInstance().onCollectionWithBData(event, param);
    }

    public static interface OnMessageListener {
        public void onMessage(JSONObject var1);

        public void onRefreshMemberState();

        public void onRefreshMembers(JSONObject var1);
    }

    public static interface InitCallback {
        public void onSuccess();

        public void onFailure(int var1, String var2);
    }
}

