package com.vhall.rtc.vrtc;

import com.vhall.rtc.VRTCCode;
import com.vhall.rtc.VRTCParams;

/**
 * @author：jooper Email：jooperge@163.com
 * 描述：基于通用rtc视频编码配置的VRTC最佳组合转换
 * 参考：http://wiki.vhallops.com/pages/viewpage.action?pageId=76218457 ，TODO 对应其中M档
 * 修改历史:
 * <p>
 * 创建于： 2022/10/21
 */
class VRTCVideoEncodeCompat {

    public static void compat(VRTCParams.VRTCVideoEncodeParam encodeParam) {
        if (encodeParam.videoWidth > 0 || encodeParam.videoHeight > 0) {
            //开发者自行定义视频宽高的，需要同时定义帧率/码率等参数
            return;
        }
        switch (encodeParam.videoResolution) {
            case VRTCCode.RTCVideoProfile.PROFILE_1920_1080_16x9:
                encodeParam.videoWidth = 1920;
                encodeParam.videoHeight = 1080;
                tryFitWithRecommendValue(encodeParam, 15, 700, 1300, 1700);
                break;
            case VRTCCode.RTCVideoProfile.PROFILE_1280_720_16x9:
            default://传入非预定义的类型，默认按1280_720处理
                encodeParam.videoWidth = 1280;
                encodeParam.videoHeight = 720;
                tryFitWithRecommendValue(encodeParam, 15, 500, 800, 1200);
                break;
            case VRTCCode.RTCVideoProfile.PROFILE_960_540_16x9:
                encodeParam.videoWidth = 960;
                encodeParam.videoHeight = 540;
                tryFitWithRecommendValue(encodeParam, 15, 500, 700, 800);
                break;
            case VRTCCode.RTCVideoProfile.PROFILE_640_360_16x9:
                encodeParam.videoWidth = 640;
                encodeParam.videoHeight = 360;
                tryFitWithRecommendValue(encodeParam, 15, 240, 350, 450);
                break;
            case VRTCCode.RTCVideoProfile.PROFILE_480_270_16x9://TRTC only, do downgrade
            case VRTCCode.RTCVideoProfile.PROFILE_320_180_16x9:
                encodeParam.videoWidth = 320;
                encodeParam.videoHeight = 180;
                encodeParam.videoResolution = VRTCCode.RTCVideoProfile.PROFILE_320_180_16x9;
                tryFitWithRecommendValue(encodeParam, 15, 190, 230, 290);
                break;
            case VRTCCode.RTCVideoProfile.PROFILE_256_144_16x9://TRTC only, do downgrade
            case VRTCCode.RTCVideoProfile.PROFILE_160_90_16x9:
                encodeParam.videoResolution = VRTCCode.RTCVideoProfile.PROFILE_160_90_16x9;
                encodeParam.videoWidth = 160;
                encodeParam.videoHeight = 90;
                tryFitWithRecommendValue(encodeParam, 15, 120, 150, 180);
                break;
            case VRTCCode.RTCVideoProfile.PROFILE_960_720_4x3:
                encodeParam.videoWidth = 960;
                encodeParam.videoHeight = 720;
                tryFitWithRecommendValue(encodeParam, 15, 450, 750, 1050);
                break;
            case VRTCCode.RTCVideoProfile.PROFILE_640_480_4x3:
                encodeParam.videoWidth = 640;
                encodeParam.videoHeight = 480;
                tryFitWithRecommendValue(encodeParam, 15, 360, 500, 600);
                break;
            case VRTCCode.RTCVideoProfile.PROFILE_480_360_4x3:
                encodeParam.videoWidth = 480;
                encodeParam.videoHeight = 360;
                tryFitWithRecommendValue(encodeParam, 15, 200, 280, 350);
                break;
            case VRTCCode.RTCVideoProfile.PROFILE_400_300_4x3://TRTC only, do downgrade
            case VRTCCode.RTCVideoProfile.PROFILE_320_240_4x3:
                encodeParam.videoResolution = VRTCCode.RTCVideoProfile.PROFILE_320_240_4x3;
                encodeParam.videoWidth = 320;
                encodeParam.videoHeight = 240;
                tryFitWithRecommendValue(encodeParam, 15, 200, 250, 300);
                break;
            case VRTCCode.RTCVideoProfile.PROFILE_280_210_4x3://TRTC only, do downgrade
            case VRTCCode.RTCVideoProfile.PROFILE_240_180_4x3://TRTC only, do downgrade
            case VRTCCode.RTCVideoProfile.PROFILE_192_144_4x3:
            case VRTCCode.RTCVideoProfile.PROFILE_160_120_4x3://TRTC only, do upgrade
                encodeParam.videoResolution = VRTCCode.RTCVideoProfile.PROFILE_192_144_4x3;
                encodeParam.videoWidth = 192;
                encodeParam.videoHeight = 144;
                tryFitWithRecommendValue(encodeParam, 15, 150, 170, 200);
                break;
        }
        //竖屏模式，交换宽高
        if (encodeParam.videoResolutionMode == VRTCCode.RTC_VIDEO_PROFILE_MODE_PORTRAIT) {
            int tempWidth = encodeParam.videoWidth;
            encodeParam.videoWidth = encodeParam.videoHeight;
            encodeParam.videoHeight = tempWidth;
        }
    }

    private static void fitVideoFps(VRTCParams.VRTCVideoEncodeParam encodeParam, int defaultValue) {
        if (encodeParam.videoFps <= 0) {
            encodeParam.videoFps = defaultValue;
        }
    }

    private static void fitVideoBitrate(VRTCParams.VRTCVideoEncodeParam encodeParam, int defaultValue) {
        if (encodeParam.videoBitrate <= 0) {
            encodeParam.videoBitrate = defaultValue;
        }
    }

    private static void fitVideoMaxBitrate(VRTCParams.VRTCVideoEncodeParam encodeParam, int defaultValue) {
        if (encodeParam.maxVideoBitrate <= 0) {
            encodeParam.maxVideoBitrate = defaultValue;
        }
    }

    private static void fitVideoMinBitrate(VRTCParams.VRTCVideoEncodeParam encodeParam, int defaultValue) {
        if (encodeParam.minVideoBitrate <= 0) {
            encodeParam.minVideoBitrate = defaultValue;
        }
    }

    private static void tryFitWithRecommendValue(VRTCParams.VRTCVideoEncodeParam encodeParam, int videoFps, int minBitrate, int bitrate, int maxBitrate) {
        fitVideoFps(encodeParam, videoFps);
        fitVideoMinBitrate(encodeParam, minBitrate);
        fitVideoBitrate(encodeParam, bitrate);
        fitVideoMaxBitrate(encodeParam, maxBitrate);
    }
}