package com.vhall.rtc.trtc.log;

import android.util.Base64;

import com.vhall.logmanager.VLog;
import com.vhall.rtc.trtc.Stream;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;

public class StreamLogReport {
    private static final String mTag = "StreamLogReport";
    private static final long period = 30 * 1000;//30s
    private static final String KDizDes02 = "biz_des02";

    private static final int VhallStreamStatusTypeStart = 0;
    private static final int VhallStreamStatusTypesStop = 1;

    //各k值定义参考：http://wiki.vhallops.com/pages/viewpage.action?pageId=918066
    public static final String kStreamId = "p";
    public static final String kErrorCode = "errorcode";
    public static final String kBitRate = "bitrate";
    public static final String kTF = "tf";
    public static final String kTT = "tt";
    public static final String kUF = "uf";
    //是否启用了海外节点
    public static final String kOS = "os";
    public static final String kWidth = "v_width";
    public static final String kHeight = "v_height";
    //各k值定义参考：http://wiki.vhallops.com/pages/viewpage.action?pageId=918066

    private Object lock = new Object();

    private Stream mStream;
    private Timer mStatsTimer;
    private TimerTask timerTask;

    public void streamStart(Stream stream) {
        mStream = stream;
        if (mStatsTimer == null) {
            mStatsTimer = new Timer();
            timerTask = new TimerTask() {
                @Override
                public void run() {
                    gatherTrackStats(VhallLogReportErrorCode.kNoneError, VhallStreamStatusTypeStart);
                }
            };
            mStatsTimer.schedule(timerTask, period, period);//30s
        }
    }

    public void streamStop() {
        if (mStatsTimer != null) {
            mStatsTimer.cancel();
            mStatsTimer = null;
        }
        if (timerTask != null) {
            timerTask.cancel();
            timerTask = null;
        }
        VhallLogReportErrorCode errorCode;
        if (mStream.isLocal) {
            errorCode = VhallLogReportErrorCode.kPublishSuccess;
        } else {
            errorCode = VhallLogReportErrorCode.kSubscribeSuccess;
        }
        gatherTrackStats(errorCode, VhallStreamStatusTypesStop);
    }

    public void streamError() {
        VhallLogReportErrorCode errorCode;
        if (mStream.isLocal) {
            errorCode = VhallLogReportErrorCode.kPublishError;
        } else {
            errorCode = VhallLogReportErrorCode.kSubscribeError;
        }
        gatherTrackStats(errorCode, VhallStreamStatusTypesStop);
    }

    /**
     * TODO 简单copy自vrtc，待后续做日志层面的统一
     */
    private enum VhallLogReportErrorCode {
        kNoneError(-1),
        kSubscribeError(4001),
        kSubscribeSuccess(2002),
        kPublishError(4002),
        kPublishSuccess(2003);

        private int _value;

        private VhallLogReportErrorCode(int value) {
            this._value = value;
        }

        public int getValue() {
            return this._value;
        }
    }

    private void gatherTrackStats(final VhallLogReportErrorCode errorCode, int type) {
        LogReport logReport = LogReport.instance();
        LogReport.VhallLogReportKey key = LogReport.VhallLogReportKey.kSignalingConnectSuccess;
        String token = null;
        try {
            JSONObject tokenDic = new JSONObject(logReport.logDataInfo.toString());
            tokenDic.put(kStreamId, mStream.streamId);

            HashMap<String, String> statistcs = logReport.fetchStatisticsData(mStream);
            if (null != statistcs) {
                if (statistcs.containsKey("videoWidth")) {
                    tokenDic.put(kWidth, Integer.valueOf(statistcs.get("videoWidth")));
                }
                if (statistcs.containsKey("videoHeight")) {
                    tokenDic.put(kHeight, Integer.valueOf(statistcs.get("videoHeight")));
                }
                if (mStream.isLocal) {
                    key = LogReport.VhallLogReportKey.kPublishInfo;
                } else {
                    key = LogReport.VhallLogReportKey.kSubscribeInfo;
                }
                if (type == VhallStreamStatusTypeStart) {
                    tokenDic.put(KDizDes02, 1);
                } else {
                    tokenDic.put(KDizDes02, 2);
                }
                tokenDic.put(kOS, false);
                tokenDic.put(kBitRate, statistcs.get("bitrate"));
                if (errorCode.getValue() > 0) {
                    tokenDic.put(kErrorCode, errorCode.getValue());
                }
                token = tokenDic.toString();
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }
        if (null != token) {
            String url = null;
            try {
                url = logReport.reportUrl + "?k=" + key.getValue() + "&s=" + logReport.sessionId + "&id=" + logReport.getLogId() + "&bu=" + logReport.bu + "&token=" + new String(Base64.encode(token.getBytes(), Base64.NO_WRAP), "UTF-8");
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            VLog.d(mTag, url);
            TempHttpRequest.httpGetAsyncRequest(url);
            synchronized (lock) {
                lock.notify();
            }

            synchronized (lock) {
                try {
                    lock.wait(1000);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}
