package com.vhall.rtc.trtc;

import com.tencent.trtc.TRTCCloudDef;
import com.vhall.logmanager.VLog;
import com.vhall.rtc.VRTCCode;
import com.vhall.rtc.VRTCParams;

/**
 * @author：jooper Email：jooperge@163.com
 * 描述：基于通用rtc视频编码配置的TRTC最佳组合转换
 * 修改历史:
 * <p>
 * 创建于： 2022/10/21
 */
class TRTCVideoEncodeCompat {
    private static final String TAG = "TRTCVideoEncodeCompat";

    public static void compat(VRTCParams.VRTCVideoEncodeParam encodeParam) {
        if (encodeParam.videoWidth > 0 || encodeParam.videoHeight > 0) {
            VLog.d(TAG, "TRTC 模式下自定义宽高无效，请使用videoResolution字段，值参考VRTCCode#RTCVideoProfile");
        }
        switch (encodeParam.videoResolution) {
            case VRTCCode.RTCVideoProfile.PROFILE_1920_1080_16x9:
                encodeParam.videoResolution2TRTC = TRTCCloudDef.TRTC_VIDEO_RESOLUTION_1920_1080;
                tryFitWithRecommendValue(encodeParam, 20, 3000);
                break;
            case VRTCCode.RTCVideoProfile.PROFILE_1280_720_16x9:
            default://传入非预定义的类型，默认按1280_720处理
                encodeParam.videoResolution2TRTC = TRTCCloudDef.TRTC_VIDEO_RESOLUTION_1280_720;
                tryFitWithRecommendValue(encodeParam, 20, 1800);
                break;
            case VRTCCode.RTCVideoProfile.PROFILE_960_540_16x9:
                encodeParam.videoResolution2TRTC = TRTCCloudDef.TRTC_VIDEO_RESOLUTION_960_540;
                tryFitWithRecommendValue(encodeParam, 20, 1300);
                break;
            case VRTCCode.RTCVideoProfile.PROFILE_640_360_16x9:
                encodeParam.videoResolution2TRTC = TRTCCloudDef.TRTC_VIDEO_RESOLUTION_640_360;
                tryFitWithRecommendValue(encodeParam, 20, 900);
                break;
            case VRTCCode.RTCVideoProfile.PROFILE_480_270_16x9:
                encodeParam.videoResolution2TRTC = TRTCCloudDef.TRTC_VIDEO_RESOLUTION_480_270;
                tryFitWithRecommendValue(encodeParam, 20, 550);
            case VRTCCode.RTCVideoProfile.PROFILE_320_180_16x9:
                encodeParam.videoResolution2TRTC = TRTCCloudDef.TRTC_VIDEO_RESOLUTION_320_180;
                tryFitWithRecommendValue(encodeParam, 20, 400);
                break;
            case VRTCCode.RTCVideoProfile.PROFILE_256_144_16x9:
                encodeParam.videoResolution2TRTC = TRTCCloudDef.TRTC_VIDEO_RESOLUTION_256_144;
                tryFitWithRecommendValue(encodeParam, 20, 300);
            case VRTCCode.RTCVideoProfile.PROFILE_160_90_16x9:
                encodeParam.videoResolution2TRTC = TRTCCloudDef.TRTC_VIDEO_RESOLUTION_160_90;
                tryFitWithRecommendValue(encodeParam, 20, 250);
                break;
            case VRTCCode.RTCVideoProfile.PROFILE_960_720_4x3:
                encodeParam.videoResolution2TRTC = TRTCCloudDef.TRTC_VIDEO_RESOLUTION_960_720;
                tryFitWithRecommendValue(encodeParam, 20, 1500);
                break;
            case VRTCCode.RTCVideoProfile.PROFILE_640_480_4x3:
                encodeParam.videoResolution2TRTC = TRTCCloudDef.TRTC_VIDEO_RESOLUTION_640_480;
                tryFitWithRecommendValue(encodeParam, 20, 900);
                break;
            case VRTCCode.RTCVideoProfile.PROFILE_480_360_4x3:
                encodeParam.videoResolution2TRTC = TRTCCloudDef.TRTC_VIDEO_RESOLUTION_480_360;
                tryFitWithRecommendValue(encodeParam, 20, 600);
                break;
            case VRTCCode.RTCVideoProfile.PROFILE_400_300_4x3:
                encodeParam.videoResolution2TRTC = TRTCCloudDef.TRTC_VIDEO_RESOLUTION_400_300;
                tryFitWithRecommendValue(encodeParam, 20, 450);
            case VRTCCode.RTCVideoProfile.PROFILE_320_240_4x3:
                encodeParam.videoResolution2TRTC = TRTCCloudDef.TRTC_VIDEO_RESOLUTION_320_240;
                tryFitWithRecommendValue(encodeParam, 20, 375);
                break;
            case VRTCCode.RTCVideoProfile.PROFILE_280_210_4x3:
                encodeParam.videoResolution2TRTC = TRTCCloudDef.TRTC_VIDEO_RESOLUTION_280_210;
                tryFitWithRecommendValue(encodeParam, 20, 300);
                break;
            case VRTCCode.RTCVideoProfile.PROFILE_240_180_4x3:
                encodeParam.videoResolution2TRTC = TRTCCloudDef.TRTC_VIDEO_RESOLUTION_240_180;
                tryFitWithRecommendValue(encodeParam, 20, 225);
                break;
            case VRTCCode.RTCVideoProfile.PROFILE_192_144_4x3://VRTC only, do upgrade
            case VRTCCode.RTCVideoProfile.PROFILE_160_120_4x3:
                encodeParam.videoResolution2TRTC = TRTCCloudDef.TRTC_VIDEO_RESOLUTION_160_120;
                tryFitWithRecommendValue(encodeParam, 20, 150);
                break;
        }
    }

    private static void fitVideoFps(VRTCParams.VRTCVideoEncodeParam encodeParam, int defaultValue) {
        if (encodeParam.videoFps <= 0) {
            encodeParam.videoFps = defaultValue;
        }
    }

    private static void fitVideoBitrate(VRTCParams.VRTCVideoEncodeParam encodeParam, int defaultValue) {
        if (encodeParam.videoBitrate <= 0) {
            encodeParam.videoBitrate = defaultValue;
        }
    }

    private static void tryFitWithRecommendValue(VRTCParams.VRTCVideoEncodeParam encodeParam, int videoFps, int bitrate) {
        fitVideoFps(encodeParam, videoFps);
        fitVideoBitrate(encodeParam, bitrate);
    }
}