package com.vhall.rtc.absrtc;

import android.content.Context;

import com.vhall.logmanager.VLog;
import com.vhall.rtc.VRTCParams;
import com.vhall.rtc.trtc.VhallTRTCImpl;
import com.vhall.rtc.vrtc.VhallVRTCImpl;

/**
 * @author：vhall Email：jooperge@163.com
 * 描述 互动能力工厂
 * 修改历史:
 * <p>
 * 创建于： 2022/10/18
 */
public class VHInteractiveFactory {

    public static IVHRTC newRTC(Context context, VRTCParams.VRTCRoomParamsInner roomParams) {
        if (VRTCParams.RTCTYPE_TRTC.equals(roomParams.type)) {
            VhallTRTCImpl trtc = null;
            try {
                trtc = new VhallTRTCImpl(context);
            } catch (NoClassDefFoundError e) {
                e.printStackTrace();
                VLog.e("VHInteractive", "请参考官方文档引入TRTC sdk相关依赖");
            }
            return trtc;
        } else {
            VhallVRTCImpl vrtc = null;
            try {
                vrtc = new VhallVRTCImpl(context, roomParams);
            } catch (NoClassDefFoundError e) {
                e.printStackTrace();
                VLog.e("VHInteractive", "请检查是否移除了VRTC sdk相关依赖");
            }
            return vrtc;
        }
    }
}