package com.vhall.rtc.absrtc;

import android.content.Context;
import android.util.AttributeSet;
import android.view.SurfaceView;
import android.widget.FrameLayout;

/**
 * @author：vhall Email：jooperge@163.com
 * 描述：renderview holder
 * 修改历史:
 * <p>
 * 创建于： 2022/10/25
 */
public class IVHRTCRenderView extends FrameLayout {

    public IVHRTCRenderView(Context context) {
        super(context);
    }

    public IVHRTCRenderView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public IVHRTCRenderView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    /**
     * for VRTC VHRenderView【开发者无需调用】
     *
     * @param surfaceView
     */
    public void bindSurfaceView(SurfaceView surfaceView) {
        removeAllViews();
        addView(surfaceView);
    }

    /**
     * for TRTC TXCloudVideoView【开发者无需调用】
     *
     * @param frameLayout
     */
    public void bindFramelayout(FrameLayout frameLayout) {
        removeAllViews();
        addView(frameLayout);
    }

    @Override
    public boolean performClick() {
        return super.performClick();
    }
}
