package com.vhall.ilss;

import static com.vhall.framework.VHAPI.getBaseBuilder;
import static com.vhall.framework.VHAPI.getOkHttpClient;
import static com.vhall.framework.VHAPI.getRequest;

import android.text.TextUtils;

import com.vhall.framework.VHAPI;
import com.vhall.framework.common.ICallback;
import com.vhall.rtc.VRTCParams;

import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import java.util.concurrent.TimeUnit;

/**
 * Created by zwp on 2019/7/18
 */
public class VHInteractiveApi {
    //    //互动
    public static final String TYPE_INAV = "Inav";

    /**
     * 权限验证
     *
     * @param resId
     * @param permission
     * @param callback
     */
    protected static void getPermission(String resId, String accessToken, String permission, Callback callback) {
        FormBody.Builder builder = getBaseBuilder(accessToken)
                .add("resourse_id", resId)
                .add("permission", permission);
        Call call = getOkHttpClient().newCall(getRequest("v2/inav/get-access-token-permission", builder.build()));
        if (callback == null)
            call.enqueue(new VHAPI.DefaultCallback());
        else
            call.enqueue(callback);
    }

    /**
     * 获取互动房间信息
     *
     * @param roomid
     * @param callback
     */
    protected static void getRoomInfo(String roomid, String accessToken, String broadcastid, final String mode, final String role, Callback callback) {
        FormBody.Builder builder = getBaseBuilder(accessToken)
                .add("inav_id", roomid);
        if (!TextUtils.isEmpty(broadcastid))
            builder.add("room_id", broadcastid);
        if (!TextUtils.isEmpty(mode))
            builder.add("mode", mode);
        if (!TextUtils.isEmpty(role))
            builder.add("role", role);
        Call call = getOkHttpClient().newCall(getRequest("v2/inav/get-inav-info", builder.build()));
        if (callback == null)
            call.enqueue(new VHAPI.DefaultCallback());
        else
            call.enqueue(callback);
    }

    protected static void getRoomMember(String roomid, String accessToken, Callback callback) {
        FormBody.Builder builder = getBaseBuilder(accessToken)
                .add("inav_id", roomid);
        Call call = getOkHttpClient().newCall(getRequest("v2/inav/inav-user-list", builder.build()));
        if (callback == null)
            call.enqueue(new VHAPI.DefaultCallback());
        else
            call.enqueue(callback);
    }

    /**
     * 离开房间，清理房间资源
     *
     * @param roomid
     * @param accessToken
     */
    protected static void onLeave(String roomid, String accessToken) {
        FormBody.Builder builder = getBaseBuilder(accessToken)
                .add("inav_id", roomid);
        Call call = getOkHttpClient().newCall(getRequest("v2/inav/leave-inav", builder.build()));
        call.enqueue(new VHAPI.DefaultCallback());
    }

    /**
     * @param roomid
     * @param accessToken
     * @param streamid
     * @param type        1 上麦(默认) 2 下麦 3 拒绝上麦
     */
    @Deprecated
    protected static void onStateChanged(String roomid, String accessToken, String streamid, int type, Callback callback) {
        FormBody.Builder builder = getBaseBuilder(accessToken)
                .add("inav_id", roomid)
                .add("stream_id", streamid)
                .add("type", String.valueOf(type));
        Call call = getOkHttpClient().newCall(getRequest("v2/inav/user-publish-callback", builder.build()));
        if (callback == null) {
            call.enqueue(new VHAPI.DefaultCallback());
        } else {
            call.enqueue(callback);
        }
    }


    /**
     * 【已废弃，不再生效】
     * 发起/结束 旁路直播 通知微吼修改状态接口
     *
     * @param roomid      互动房间ID
     * @param accessToken
     * @param broid       直播房间ID
     * @param type        1 推起 2 结束推起//开启 1 默认 / 关闭 2
     */
    @Deprecated
    protected static void onBrocast(String roomid, String accessToken, String broid, int type, Callback callback) {
        FormBody.Builder builder = getBaseBuilder(accessToken)
                .add("inav_id", roomid)
                .add("room_id", broid)
                .add("type", String.valueOf(type));

        Call call = getOkHttpClient().newCall(getRequest("v2/inav/publish-another-config", builder.build()));
        if (callback == null)
            call.enqueue(new VHAPI.DefaultCallback());
        else
            call.enqueue(callback);
    }

    /**
     * 仅适用于TRTC，发起旁路直播
     *
     * @param accessToken
     * @param callback
     */
    public static void startBroadcastTRTC(
            VRTCParams.VRTCBroadcastParamInner broadcastParam,
            String accessToken,
            Callback callback) {
        FormBody.Builder builder = getBaseBuilder(accessToken)
                .add("inav_id", broadcastParam.inavRoomId)
                .add("room_id", broadcastParam.broadcastRoomId)
                .add("profile", null != broadcastParam.compat_profile_json ? broadcastParam.compat_profile_json.toString() : "");
        if (broadcastParam.isAdaptiveLayoutMode) {
            builder.add("adaptive_layout_mode", String.valueOf(broadcastParam.compat_layout_mode));
            builder.add("layout", "");
        } else {
            builder.add("adaptive_layout_mode", "");
            builder.add("layout", String.valueOf(broadcastParam.compat_layout_mode));
        }
        if (!TextUtils.isEmpty(broadcastParam.broadcastParam.backgroundColor)) {
            builder.add("background_color", broadcastParam.broadcastParam.backgroundColor);
        } else {
            builder.add("background_color", "");
        }
        if (!TextUtils.isEmpty(broadcastParam.broadcastParam.backgroundImageUrl)) {
            builder.add("background_url", broadcastParam.broadcastParam.backgroundImageUrl);
        } else {
            builder.add("background_url", "");
        }

        Call call = getOkHttpClient().newCall(getRequest("/v2/inav/start-mix-transcode", builder.build()));
        if (callback == null)
            call.enqueue(new VHAPI.DefaultCallback());
        else
            call.enqueue(callback);
    }

    /**
     * 仅适用于TRTC，停止旁路直播
     *
     * @param accessToken
     * @param callback
     */
    public static void stopBroadcastTRTC(String inavRoomId, String accessToken, Callback callback) {
        FormBody.Builder builder = getBaseBuilder(accessToken)
                .add("inav_id", inavRoomId);

        Call call = getOkHttpClient().newCall(getRequest("/v2/inav/stop-mix-transcode", builder.build()));
        if (callback == null)
            call.enqueue(new VHAPI.DefaultCallback());
        else
            call.enqueue(callback);
    }

    /**
     * 仅适用于TRTC，用户事件通知
     *
     * @param inavRoomId
     * @param streamId   组装格式见: http://yapi.vhall.domain/project/48/interface/api/54081
     * @param event      见: {@link com.vhall.rtc.VRTCCode.TRTCStreamEvent}
     */
    public static void eventNotifyTRTC(String inavRoomId, String streamId, String event, String accessToken, Callback callback) {
        if (!TextUtils.isEmpty(streamId)) {
            FormBody.Builder builder = getBaseBuilder(accessToken)
                    .add("inav_id", inavRoomId)
                    .add("stream_id", streamId)
                    .add("type", event);

            Call call = getOkHttpClient().newCall(getRequest("/v2/inav/event-notification", builder.build()));
            if (callback == null)
                call.enqueue(new VHAPI.DefaultCallback());
            else
                call.enqueue(callback);
        }
    }

    /**
     * 仅适用于TRTC，设置旁路主屏
     *
     * @param inavRoomId
     * @param streamId   TRTC旁路/事件上报相关业务场景下对组合流ID，格式见: http://yapi.vhallops.com/project/48/interface/api/54002
     */
    public static void setMixMainScreenTRTC(String inavRoomId, String streamId, String accessToken, Callback callback) {
        FormBody.Builder builder = getBaseBuilder(accessToken)
                .add("inav_id", inavRoomId)
                .add("stream_id", streamId);

        Call call = getOkHttpClient().newCall(getRequest("/v2/inav/set-max-video-user", builder.build()));
        if (callback == null)
            call.enqueue(new VHAPI.DefaultCallback());
        else
            call.enqueue(callback);
    }

    /**
     * 申请上麦
     *
     * @param roomid
     */
    @Deprecated
    protected static void reqPush(String roomid, String accessToken, Callback callback) {
        FormBody.Builder builder = getBaseBuilder(accessToken)
                .add("inav_id", roomid);
        Call call = getOkHttpClient().newCall(getRequest("v2/inav/apply-inav-publish", builder.build()));
        if (callback == null)
            call.enqueue(new VHAPI.DefaultCallback());
        else
            call.enqueue(callback);
    }

    /**
     * 审核申请上麦
     *
     * @param roomid
     * @param userid 受审核人第三放用户ID
     * @param type   是否同意 1 同意 2 不同意
     */
    @Deprecated
    protected static void checkPushReq(String roomid, String accessToken, String userid, int type, Callback callback) {
        FormBody.Builder builder = getBaseBuilder(accessToken)
                .add("inav_id", roomid)
                .add("audit_user_id", userid)
                .add("audit_type", String.valueOf(type));
        Call call = getOkHttpClient().newCall(getRequest("v2/inav/audit-inav-publish", builder.build()));
        if (callback == null)
            call.enqueue(new VHAPI.DefaultCallback());
        else
            call.enqueue(callback);
    }

    /**
     * 邀请上麦
     *
     * @param roomid
     */
    @Deprecated
    protected static void invitePush(String roomid, String accessToken, String userid, Callback callback) {
        FormBody.Builder builder = getBaseBuilder(accessToken)
                .add("inav_id", roomid)
                .add("askfor_third_user_id", userid);
        Call call = getOkHttpClient().newCall(getRequest("v2/inav/askfor-inav-publish", builder.build()));
        if (callback == null)
            call.enqueue(new VHAPI.DefaultCallback());
        else
            call.enqueue(callback);
    }

    /**
     * 请下麦
     *
     * @param roomid
     * @param userid
     * @param type   1 踢出流（默认） 2 取消踢出流
     *               还原accessToken
     */
    @Deprecated
    protected static void kickoutPush(String roomid, String accessToken, String userid, int type, Callback callback) {
        FormBody.Builder builder = getBaseBuilder(accessToken)
                .add("inav_id", roomid)
                .add("kick_user_id", userid)
                .add("type", String.valueOf(type));
        Call call = getOkHttpClient().newCall(getRequest("v2/inav/kick-inav-stream", builder.build()));
        if (callback == null)
            call.enqueue(new VHAPI.DefaultCallback());
        else
            call.enqueue(callback);
    }

    /**
     * 踢出互动 房间
     *
     * @param roomid
     * @param userid
     * @param type   1 踢出互动房间（默认） 2 取消踢出互动房间
     */
    @Deprecated
    protected static void kickoutRoom(String roomid, String accessToken, String userid, int type, Callback callback) {
        FormBody.Builder builder = getBaseBuilder(accessToken)
                .add("inav_id", roomid)
                .add("kick_user_id", userid)
                .add("type", String.valueOf(type));
        Call call = getOkHttpClient().newCall(getRequest("v2/inav/kick-inav", builder.build()));
        if (callback == null)
            call.enqueue(new VHAPI.DefaultCallback());
        else
            call.enqueue(callback);
    }

    /**
     * 强制用户离开房间
     *
     * @param roomId      房间id
     * @param accessToken 权限token
     * @param kickUserId  被踢出者id
     * @param callback
     */
    public static void forceLeaveRoom(String roomId, String accessToken, String kickUserId, Callback callback) {
        FormBody.Builder builder = getBaseBuilder(accessToken)
                .add("inav_id", roomId)
                .add("kick_user_id", kickUserId);
        Call call = getOkHttpClient().newCall(getRequest("v2/inav/leave-room-force-inav", builder.build()));
        if (callback != null) {
            call.enqueue(callback);
        } else {
            call.equals(new VHAPI.DefaultCallback());
        }
    }

    public static void docCloudRender(String roomId, String accessToken, String channelId, boolean start, Callback callback) {
        FormBody.Builder builder = getBaseBuilder(accessToken)
                .add("channel_id", channelId)
                .add("inav_id", roomId);
        Call call = getOkHttpClient().newCall(getRequest(start ? "v2/inav/start-doc-cloud-render" : "v2/inav/stop-doc-cloud-render", builder.build()));
        if (callback != null) {
            call.enqueue(callback);
        } else {
            call.equals(new VHAPI.DefaultCallback());
        }
    }

    public static Call stream_get_attributes(String roomId, String accessToken, String streamId, Callback callback) {
        FormBody.Builder builder = getBaseBuilder(accessToken)
                .add("stream_id", streamId)
                .add("inav_id", roomId);
        // 超时时间 5 seconds
        OkHttpClient client = getOkHttpClient().newBuilder()
                .writeTimeout(5, TimeUnit.SECONDS)
                .readTimeout(5, TimeUnit.SECONDS)
                .connectTimeout(5, TimeUnit.SECONDS)
                .build();
        Call call = client.newCall(getRequest("v2/inav/stream-get-attributes", builder.build()));
        if (callback != null) {
            call.enqueue(callback);
        } else {
            call.equals(new VHAPI.DefaultCallback());
        }
        return call;
    }
    public static void stream_update_attributes(String roomId, String accessToken, String streamId, String attribute, Callback callback) {
        FormBody.Builder builder = getBaseBuilder(accessToken)
                .add("stream_id", streamId)
                .add("attributes", attribute)
                .add("inav_id", roomId);
        Call call = getOkHttpClient().newCall(getRequest("v2/inav/stream-update-attributes", builder.build()));
        if (callback != null) {
            call.enqueue(callback);
        } else {
            call.equals(new VHAPI.DefaultCallback());
        }
    }
}
