/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.framework;

import android.annotation.SuppressLint;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Build;
import android.os.IBinder;
import android.text.TextUtils;
import android.util.Base64;
import com.vhall.beautify.IVHBeautifyInitListener;
import com.vhall.framework.beautify.BeautifyRegServiceImpl;
import com.vhall.framework.connect.IVHService;
import com.vhall.framework.connect.VhallConnectService;
import com.vhall.framework.lssv2.VHV2PusherServiceImpl;
import com.vhall.framework.utils.InternalUtils;
import com.vhall.framework.utils.SignatureUtil;
import com.vhall.logmanager.L;
import com.vhall.logmanager.LogInfo;
import com.vhall.logmanager.LogReporter;
import com.vhall.logmanager.VLog;
import com.vhall.logmanager.VhallDeviceId;
import java.util.concurrent.CopyOnWriteArraySet;
import org.json.JSONException;
import org.json.JSONObject;

public class VhallBaseSDK {
    private static final String TAG = "VhallBaseSDK";
    private static VhallBaseSDK mInstance = null;
    protected String APP_ID = "";
    protected String packageCheck = "";
    private Context mContext;
    private String mVersion = this.getVersionImpl();
    public String mUserId = "";
    private String mUserInfo = "";
    protected String mAtom = "";
    public String mIMEI = "";
    public String mAPIHost = "https://api.vhallyun.com/sdk/";
    public String mDocHost = "";
    public String mLogHost = "https://dc.e.vhall.com/login";
    private VhallConnectService mService = null;
    private BaseConnection mConnection = null;
    private boolean startService = true;
    private String packageName;
    private String signature;
    private boolean hide = false;
    private InitCallback initCallback;
    public String mLicenseUrl = "";
    public String mLicenseKey = "";
    public String documentExt = "[\"txt\",\"doc\",\"docx\",\"xls\",\"xlsx\",\"ppt\",\"pptx\",\"pdf\",\"gif\",\"jpeg\",\"jpg\",\"png\",\"bmp\"]";
    public int documentMaxSize = 0x3200000;
    private static final String atomFormat = "cv=%s&dt=%s&pf=%s&uid=%s&cn=%s&imei=%s";

    protected VhallBaseSDK() {
    }

    private String getVersionImpl() {
        return String.format("v%s", "2.7.6");
    }

    public static VhallBaseSDK getInstance() {
        if (mInstance == null) {
            mInstance = new VhallBaseSDK();
        }
        return mInstance;
    }

    protected static VhallBaseSDK newInstance(VhallBaseSDK baseSDK) {
        if (mInstance == null) {
            mInstance = baseSDK;
        }
        return mInstance;
    }

    public void setStartService(boolean startService) {
        this.startService = startService;
    }

    public void setInitCallback(InitCallback initCallback) {
        this.initCallback = initCallback;
        if (this.mService != null) {
            this.mService.setInitCallback(initCallback);
        }
    }

    public void init(Context context, String appid, String userid, InitCallback initCallback) {
        this.initImpl(context, appid, userid, null, initCallback);
    }

    public void init(Context context, String appid, String userid, String host) {
        this.initImpl(context, appid, userid, host, null);
    }

    public void init(Context context, String appid, String userid) {
        this.initImpl(context, appid, userid, null, null);
    }

    public void initBeautify(String accessToken, IVHBeautifyInitListener beautifyInitListener) {
        if (null == this.mContext || null == this.mService) {
            throw new IllegalStateException("please call VhallBaseSDK#init(...) before this method!");
        }
        if (null == accessToken) {
            throw new IllegalArgumentException("accessToken must not be null!");
        }
        this.mService.setBeautifyInitCallback(beautifyInitListener);
        this.join(new BeautifyRegServiceImpl(accessToken));
    }

    public void initLssV2(String accessToken, InitCallback initListener) {
        if (null == this.mContext || null == this.mService) {
            throw new IllegalStateException("please call VhallBaseSDK#init(...) before this method!");
        }
        if (null == accessToken) {
            throw new IllegalArgumentException("accessToken must not be null!");
        }
        this.mService.setInitCallback(initListener);
        this.join(new VHV2PusherServiceImpl(accessToken));
    }

    private void initImpl(Context context, String appid, String userid, String host, InitCallback initCallback) {
        if (InternalUtils.isMainProcess(context)) {
            if (!TextUtils.isEmpty((CharSequence)host)) {
                this.mAPIHost = "https://" + host + "/sdk/";
            }
            this.initCallback = initCallback;
            this.APP_ID = appid;
            this.mContext = context;
            this.mUserId = TextUtils.isEmpty((CharSequence)userid) ? String.valueOf(System.currentTimeMillis()) : userid;
            this.refreshAtom();
            if (TextUtils.isEmpty((CharSequence)this.mUserInfo)) {
                try {
                    JSONObject userInfo = new JSONObject();
                    userInfo.put("third_party_user_id", (Object)this.mUserId);
                    this.mUserInfo = userInfo.toString();
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            this.packageCheck = this.getPackageCheck();
            this.mAtom = this.getAtom();
            LogReporter.getInstance().init(this.mContext, this.mLogHost, this.mVersion, 1, this.APP_ID, this.mUserId);
            LogInfo.getInstance().setBiz("01", "11", "des01", "des02");
            if (this.startService) {
                this.startService();
            } else if (null != this.initCallback) {
                this.initCallback.onSuccess();
            }
        }
    }

    public void setBiz(String biz_role, String biz_id, String biz_des01, String biz_des02) {
        LogInfo.getInstance().setBiz(biz_role, biz_id, biz_des01, biz_des02);
    }

    public void startService() {
        Intent connectService = new Intent(this.mContext, VhallConnectService.class);
        connectService.putExtra("third_party_user_id", this.mUserId);
        connectService.putExtra("userInfo", this.mUserInfo);
        connectService.putExtra("hint", this.hide);
        this.mConnection = new BaseConnection();
        this.mContext.bindService(connectService, (ServiceConnection)this.mConnection, 1);
    }

    public void stopService() {
        if (this.mConnection != null) {
            try {
                this.mContext.unbindService((ServiceConnection)this.mConnection);
                this.mConnection = null;
                if (this.mService != null) {
                    this.mService.onDestroy();
                    this.mService = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean join(IVHService service) {
        if (!this.isEnable()) {
            VLog.e((String)TAG, (String)"SDK\u521d\u59cb\u5316\u5931\u8d25\uff0c\u6d88\u606f\u670d\u52a1\u5c06\u4e0d\u53ef\u7528\uff01");
            return false;
        }
        this.mService.join(service);
        return true;
    }

    public boolean leave(IVHService service) {
        if (!this.isEnable()) {
            VLog.e((String)TAG, (String)"SDK\u521d\u59cb\u5316\u5931\u8d25\uff0c\u6d88\u606f\u670d\u52a1\u5c06\u4e0d\u53ef\u7528\uff01");
            return false;
        }
        this.mService.leave(service);
        return true;
    }

    public boolean setUserId(String userid) {
        return this.setUserId(userid, null);
    }

    public boolean setUserId(String userid, InitCallback callback) {
        LogReporter.getInstance().setUserid(userid);
        LogReporter.getInstance().onCollection("2008", (JSONObject)null);
        this.setInitCallback(callback);
        if (TextUtils.isEmpty((CharSequence)userid)) {
            return false;
        }
        if (!this.isEnable()) {
            VLog.e((String)TAG, (String)"SDK\u521d\u59cb\u5316\u5931\u8d25\uff0c\u6d88\u606f\u670d\u52a1\u5c06\u4e0d\u53ef\u7528\uff01");
            return false;
        }
        this.mUserId = userid;
        this.refreshAtom();
        this.mService.setUserId(this.mUserId);
        return true;
    }

    public void setHide(boolean hide) {
        this.hide = hide;
        if (!this.isEnable()) {
            VLog.e((String)TAG, (String)"SDK\u521d\u59cb\u5316\u5931\u8d25\uff0c\u6d88\u606f\u670d\u52a1\u5c06\u4e0d\u53ef\u7528\uff01");
            return;
        }
        this.mService.setHide(hide);
    }

    public boolean setUserInfo(String userInfo) {
        return this.setUserInfo(userInfo, null);
    }

    public boolean setUserInfo(String userInfo, InitCallback initCallback) {
        this.mUserInfo = userInfo;
        if (initCallback != null) {
            this.setInitCallback(initCallback);
        }
        try {
            JSONObject info = new JSONObject(this.mUserInfo);
            String userId = info.optString("third_party_user_id");
            if (TextUtils.isEmpty((CharSequence)this.mUserId)) {
                return false;
            }
            if (!this.isEnable()) {
                VLog.e((String)"VhallSDK", (String)"SDK\u521d\u59cb\u5316\u5931\u8d25\uff0c\u6d88\u606f\u670d\u52a1\u5c06\u4e0d\u53ef\u7528\uff01");
                return false;
            }
            if (this.mUserId.equals(userId)) {
                this.mService.updateUserInfo(userInfo);
            } else {
                this.mUserId = userId;
                this.refreshAtom();
                LogReporter.getInstance().setUserid(userId);
                LogReporter.getInstance().onCollection("2008", (JSONObject)null);
                this.mService.setUserInfo(userInfo);
            }
            return true;
        }
        catch (JSONException var4) {
            var4.printStackTrace();
            return false;
        }
    }

    public String getmUserInfo() {
        return this.mUserInfo;
    }

    public boolean updateUserInfo(String userInfo) {
        return this.updateUserInfo(userInfo, null);
    }

    public boolean updateUserInfo(String userInfo, InitCallback initCallback) {
        this.setInitCallback(initCallback);
        try {
            JSONObject obj = new JSONObject(userInfo);
            String userId = obj.optString("third_party_user_id");
            if (this.mUserId.equals(userId)) {
                this.mUserInfo = userInfo;
                this.mService.updateUserInfo(userInfo);
                return true;
            }
            return false;
        }
        catch (JSONException var4) {
            var4.printStackTrace();
            return false;
        }
    }

    public String getmUserId() {
        return this.mUserId;
    }

    public boolean sendMsg(String msg) {
        if (!this.isEnable()) {
            VLog.e((String)TAG, (String)"SDK\u521d\u59cb\u5316\u5931\u8d25\uff0c\u6d88\u606f\u670d\u52a1\u5c06\u4e0d\u53ef\u7528\uff01");
            return false;
        }
        this.mService.disPatchMsg(msg);
        return true;
    }

    private String getPackageCheck() {
        if (this.packageName == null) {
            this.packageName = SignatureUtil.getPackageName(this.mContext);
        }
        if (this.signature == null) {
            this.signature = SignatureUtil.getSignatureSHA1(this.mContext, this.packageName);
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.APP_ID).append("|").append(this.signature).append("|").append(this.packageName);
        String unSignStr = builder.toString();
        try {
            unSignStr = SignatureUtil.sha256Signature(unSignStr).subSequence(0, 16).toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return unSignStr;
    }

    public void setPackageCheck(String packageName, String signature) {
        this.packageName = packageName;
        this.signature = signature;
    }

    @SuppressLint(value={"MissingPermission"})
    private String getIMEI(Context context) {
        return VhallDeviceId.getVhallDeviceId((Context)context);
    }

    private void refreshAtom() {
        this.mAtom = this.getAtom();
        this.mIMEI = this.getIMEI(this.mContext);
    }

    protected String getAtom() {
        String mPhone = Build.BRAND + "  " + Build.MANUFACTURER;
        this.mIMEI = this.getIMEI(this.mContext);
        String mNetType = "";
        String atom = String.format(atomFormat, this.mVersion, mPhone, 5, this.mUserId, mNetType, this.mIMEI);
        VLog.d((String)TAG, (String)("atom:" + atom));
        return Base64.encodeToString((byte[])atom.getBytes(), (int)2);
    }

    public void destory() {
        this.mContext.unbindService((ServiceConnection)this.mConnection);
        VLog.d((String)TAG, (String)"SDK destory\uff01");
    }

    public String getVersion() {
        return this.mVersion;
    }

    @Deprecated
    public void setLogLevel(L.LogLevel level) {
        L.setLogLevel((L.LogLevel)level);
    }

    public void setLogLevel(VLog.LogLevel logLevel) {
        VLog.setLogLevel((VLog.LogLevel)logLevel);
    }

    public String getAPP_ID() {
        return this.APP_ID;
    }

    public String getLicenseUrl() {
        return this.mLicenseUrl;
    }

    public String getLicenseKey() {
        return this.mLicenseKey;
    }

    public boolean isEnable() {
        return this.mService != null;
    }

    private class BaseConnection
    implements ServiceConnection {
        private BaseConnection() {
        }

        public void onServiceConnected(ComponentName name, IBinder service) {
            VhallConnectService.ConnectBinder mBinder;
            try {
                mBinder = (VhallConnectService.ConnectBinder)service;
            }
            catch (Exception e) {
                if (null != VhallBaseSDK.this.initCallback) {
                    VhallBaseSDK.this.initCallback.onFailure(e.getMessage());
                }
                e.printStackTrace();
                return;
            }
            CopyOnWriteArraySet<IVHService> services = null;
            if (VhallBaseSDK.this.mService != null) {
                services = VhallBaseSDK.this.mService.getServices();
            }
            VhallBaseSDK.this.mService = mBinder.getService();
            VhallBaseSDK.this.mService.setInitCallback(VhallBaseSDK.this.initCallback);
            if (null != VhallBaseSDK.this.initCallback) {
                VhallBaseSDK.this.initCallback.onSuccess();
            }
            if (services != null && !services.isEmpty()) {
                for (IVHService lastService : services) {
                    VhallBaseSDK.this.join(lastService);
                }
            }
        }

        public void onServiceDisconnected(ComponentName name) {
            VLog.e((String)VhallBaseSDK.TAG, (String)"\u6d88\u606f\u670d\u52a1 \u610f\u5916\u5173\u95ed");
            if (VhallBaseSDK.this.mService != null) {
                VhallBaseSDK.this.mService.onDestroy();
            }
            VhallBaseSDK.this.startService();
        }
    }

    public static interface InitCallback {
        public void onSuccess();

        public void onFailure(String var1);
    }
}

