/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.framework;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.vhall.framework.VhallBaseSDK;
import com.vhall.httpclient.utils.OKHttpUtils;
import com.vhall.logmanager.VLog;
import java.io.File;
import java.io.IOException;
import okhttp3.Cache;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;

public final class VHAPI {
    private static final String TAG = "VHAPI";
    private static final String client = "android";
    private static OkHttpClient mOkHttpClient;
    private static OkHttpClient uploadClient;
    public static OkHttpClient mCacheClient;

    public static OkHttpClient getOkHttpClient() {
        if (mOkHttpClient == null) {
            mOkHttpClient = OKHttpUtils.createOkClient();
        }
        return mOkHttpClient;
    }

    public static OkHttpClient getUploadOKHttpClient() {
        if (uploadClient == null) {
            uploadClient = OKHttpUtils.createOkClient();
        }
        return uploadClient;
    }

    public static FormBody.Builder getBaseBuilder(String accessToken) {
        FormBody.Builder builder = new FormBody.Builder().add("client", client).add("app_id", VhallBaseSDK.getInstance().APP_ID).add("sign_type", "2").add("package_check", VhallBaseSDK.getInstance().packageCheck).add("third_party_user_id", TextUtils.isEmpty((CharSequence)VhallBaseSDK.getInstance().mUserId) ? "" : VhallBaseSDK.getInstance().mUserId).add("uuid", TextUtils.isEmpty((CharSequence)VhallBaseSDK.getInstance().mIMEI) ? VhallBaseSDK.getInstance().mUserId : VhallBaseSDK.getInstance().mIMEI).add("version_msg", "2.7.1").add("access_token", null == accessToken ? "" : accessToken);
        return builder;
    }

    public static MultipartBody.Builder getMultipartBodyBuild(String accessToken) {
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("client", client).addFormDataPart("app_id", VhallBaseSDK.getInstance().APP_ID).addFormDataPart("version_msg", "2.7.1").addFormDataPart("uuid", TextUtils.isEmpty((CharSequence)VhallBaseSDK.getInstance().mIMEI) ? VhallBaseSDK.getInstance().mUserId : VhallBaseSDK.getInstance().mIMEI).addFormDataPart("sign_type", "2").addFormDataPart("package_check", VhallBaseSDK.getInstance().packageCheck).addFormDataPart("third_party_user_id", TextUtils.isEmpty((CharSequence)VhallBaseSDK.getInstance().mUserId) ? "" : VhallBaseSDK.getInstance().mUserId).addFormDataPart("access_token", null == accessToken ? "" : accessToken);
        return builder;
    }

    public static Request getRequest(String command, RequestBody body) {
        Request request = new Request.Builder().addHeader("atom", VhallBaseSDK.getInstance().mAtom).url(VhallBaseSDK.getInstance().mAPIHost + command).post(body).build();
        return request;
    }

    public static Request getRequest(String host, String command, RequestBody body) {
        Request request = new Request.Builder().addHeader("atom", VhallBaseSDK.getInstance().mAtom).url(host + command).post(body).build();
        return request;
    }

    public static void initSDK(String accessToken, Callback callback) {
        FormBody.Builder builder = VHAPI.getBaseBuilder(accessToken);
        Request request = VHAPI.getRequest("v2/init/start", (RequestBody)builder.build());
        VHAPI.getOkHttpClient().newCall(request).enqueue(callback);
    }

    public static void joinChannelId(String channelId, String accessToken, Callback callback) {
        FormBody.Builder builder = VHAPI.getBaseBuilder(accessToken);
        if (!TextUtils.isEmpty((CharSequence)channelId)) {
            builder.add("channel_id", channelId);
        }
        Request request = VHAPI.getRequest("v2/init/start", (RequestBody)builder.build());
        VHAPI.getOkHttpClient().newCall(request).enqueue(callback);
    }

    public static void updateUserId(String channelId, String accessToken, Callback callback) {
        FormBody.Builder builder = VHAPI.getBaseBuilder(accessToken);
        if (!TextUtils.isEmpty((CharSequence)channelId)) {
            builder.add("channel_id", channelId);
        }
        Request request = VHAPI.getRequest("v2/init/start", (RequestBody)builder.build());
        VHAPI.getOkHttpClient().newCall(request).enqueue(callback);
    }

    public static void sendMsg(String content, String accessToken, String type, String channelId, String roomid, Callback callback) {
        VHAPI.sendMsg(content, accessToken, type, channelId, roomid, "0", callback);
    }

    public static void sendMsg(String content, String accessToken, String type, String channelId, String roomid, String noAudit, Callback callback) {
        VHAPI.sendMsg(content, accessToken, type, channelId, roomid, noAudit, VhallBaseSDK.getInstance().getmUserInfo(), callback);
    }

    public static void sendMsg(String content, String accessToken, String type, String channelId, String roomid, String noAudit, String context, Callback callback) {
        FormBody.Builder builder = VHAPI.getBaseBuilder(accessToken).add("body", content).add("type", type).add("context", context).add("no_audit", noAudit);
        if (!TextUtils.isEmpty((CharSequence)channelId)) {
            builder.add("channel_id", channelId);
        }
        if (!TextUtils.isEmpty((CharSequence)roomid)) {
            builder.add("room_id", roomid);
        }
        Call call = VHAPI.getOkHttpClient().newCall(VHAPI.getRequest("v2/message/send", (RequestBody)builder.build()));
        if (callback == null) {
            call.enqueue((Callback)new DefaultCallback());
        } else {
            call.enqueue(callback);
        }
    }

    public static OkHttpClient getCacheClient(Context context) {
        if (mCacheClient == null) {
            Cache mCache = new Cache(context.getCacheDir(), 0xA00000L);
            mCacheClient = OKHttpUtils.createOkClient();
        }
        return mCacheClient;
    }

    public static class ProgressRequestBody
    extends RequestBody {
        protected File file;
        protected ProgressListener listener;
        protected String contentType;
        private Handler handler;

        public ProgressRequestBody(String contentType, File file, ProgressListener listener) {
            this.file = file;
            this.contentType = contentType;
            this.listener = listener;
            this.handler = new Handler(Looper.getMainLooper());
        }

        public MediaType contentType() {
            return MediaType.parse((String)this.contentType);
        }

        public long contentLength() throws IOException {
            return this.file.length();
        }

        public void writeTo(BufferedSink sink) throws IOException {
            try {
                long readCount;
                Source source = Okio.source((File)this.file);
                Buffer buf = new Buffer();
                final Long[] remaining = new Long[]{this.contentLength()};
                final Long total = this.contentLength();
                while ((readCount = source.read(buf, 2048L)) != -1L) {
                    sink.write(buf, readCount);
                    if (this.listener == null) continue;
                    final long finalReadCount = readCount;
                    this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            remaining[0] = remaining[0] - finalReadCount;
                            listener.onProgress(total, remaining[0], remaining[0] == 0L);
                        }
                    });
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public static interface ProgressListener {
            public void onProgress(long var1, long var3, boolean var5);
        }
    }

    public static class DefaultCallback
    implements Callback {
        public void onFailure(Call call, IOException e) {
            VLog.e((String)VHAPI.TAG, (String)e.getMessage());
        }

        public void onResponse(Call call, Response response) throws IOException {
            String result = response.body().string();
            VLog.d((String)VHAPI.TAG, (String)result);
        }
    }
}

