package com.vhall.framework.utils;


import android.text.TextUtils;

import org.json.JSONArray;
import org.json.JSONObject;

/**
 * @author yuanzh
 * Json工具类
 */

public final class JsonUtil {

    /**
     * 严格校验是否为JSONObject字符串
     *
     * @param str 字符串
     * @return true=是 false=否
     * @since 2022/5/31
     */
    public static boolean isJsonObj(String str) {
        if (TextUtils.isEmpty(str)) {
            return false;
        }
        try {
            JSONObject obj = new JSONObject(str);
            return true;
        } catch (Exception e) {
            return false;
        }
    }

    /**
     * 严格校验是否为JSONArray字符串
     *
     * @param str 字符串
     * @return true=是 false=否
     * @since 2022/5/31
     */
    public static boolean isJsonArray(String str) {
        if (TextUtils.isEmpty(str)) {
            return false;
        }
        try {
            JSONArray obj = new JSONArray(str);
            return true;
        } catch (Exception e) {
            return false;
        }
    }

//    /**
//     * 校验是否为JSON字符串
//     *
//     * @param str 字符串
//     * @return true=是 false=否
//     * @since 2022/5/31
//     */
//    public static boolean isJson(String str) {
//        if (TextUtils.isEmpty(str)) {
//            return false;
//        }
//        try {
//            JSON.parse(str);
//            return true;
//        } catch (Exception e) {
//            return false;
//        }
//    }

    /**
     * 更为严格的校验是否为JSON字符串
     *
     * @param str 字符串
     * @return true=是 false=否
     * @since 2024/5/28
     */
    public static boolean isStrictJson(String str) {
        return isJsonObj(str) || isJsonArray(str);
    }
}
