package com.vhall.framework.utils;



//import lombok.experimental.UtilityClass;
//import lombok.extern.slf4j.Slf4j;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

/**
 * @author yuanzh
 * @since 2024/4/28
 */

public class GzipUtil {

    /**
     * 压缩字节数组
     *
     * @param bytes 字节数组
     * @return byte[]
     */
    public static byte[] compress(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return new byte[0];
        }
        ByteArrayOutputStream bos = null;
        GZIPOutputStream gos = null;
        try {
            bos = new ByteArrayOutputStream();
            gos = new GZIPOutputStream(bos);
            gos.write(bytes);
        } catch (Exception e) {
            //log.error("压缩异常，errorMessage={}", e.getMessage(), e);
            return new byte[0];
        } finally {
            closeStream(gos);
            closeStream(bos);
        }
        return bos.toByteArray();
    }

    /**
     * 解压缩字节数组
     *
     * @param bytes Gzip压缩的字节数组
     * @return byte[]
     */
    public static byte[] unCompress(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return new byte[0];
        }

        try (ByteArrayInputStream bin = new ByteArrayInputStream(bytes);
             GZIPInputStream gzipIn = new GZIPInputStream(bin);
             ByteArrayOutputStream bos = new ByteArrayOutputStream()) {

            byte[] b = new byte[4096];
            int temp;
            while ((temp = gzipIn.read(b)) > 0) {
                bos.write(b, 0, temp);
            }
            return bos.toByteArray();
        } catch (Exception e) {
            //log.error("解压缩异常，errorMessage={}", e.getMessage(), e);
            return new byte[0];
        }
    }

    /**
     * 关闭流
     *
     * @param stream 流
     */
    private static void closeStream(Closeable stream) {
        if (null != stream) {
            try {
                stream.close();
            } catch (IOException e) {
                //log.error("流关闭异常，errorMessage={}", e.getMessage(), e);
            }
        }
    }
}
