package com.vhall.framework.utils;

import android.content.Context;
import android.os.AsyncTask;

import com.vhall.framework.VHAPI;
import com.vhall.logmanager.VLog;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

import okhttp3.Request;
import okhttp3.Response;

/**
 * Created by Hank on 2017/12/19.
 */
public class FileUtil {

    private static final String TAG = "FileUtil";

    public interface FileCallback {
        void onFile(File file);
    }

    public static void getCuePointFile(String url, Context context, FileCallback callback) {
        try {
            String cachePath = context.getCacheDir().getPath();
            VLog.d(TAG, cachePath);
            String[] marks = url.split("/");
            File file = new File(cachePath + File.separator + marks[marks.length - 2]);
            if (file.exists()) {//文件已下载
                file.delete();
            }
            ImageDownloadTask task = new ImageDownloadTask(url, file.getAbsolutePath(), callback);
            task.execute();
        } catch (Exception e) {
            e.printStackTrace();
            callback.onFile(null);
        }

    }

    public static void getSubtitleFile(String url, Context context, FileCallback callback) {
        try {
            String cachePath = context.getCacheDir().getPath();
            VLog.d(TAG, cachePath);
            String[] marks = url.split("/");
            String directory = cachePath + File.separator + marks[marks.length - 2];
            File dir_file = new File(directory);
            if (!dir_file.exists()) {
                dir_file.mkdirs();
            }
            File file = new File(directory + File.separator + marks[marks.length - 1]);
            if (file.exists() && file.length() > 0) {//文件已下载
                file.delete();
            }
            ImageDownloadTask task = new ImageDownloadTask(url, file.getAbsolutePath(), callback);
            task.execute();
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    public static class ImageDownloadTask extends AsyncTask<Void, Void, File> {

        private String remoteURL;
        private String localURL;
        private FileCallback mCallback;

        ImageDownloadTask(String remote, String local, FileCallback callback) {
            remoteURL = remote;
            localURL = local;
            mCallback = callback;
            VLog.d(TAG, remote + ":" + local);
        }

        @Override
        protected void onPreExecute() {
            super.onPreExecute();
        }

        @Override
        protected File doInBackground(Void... params) {
            File file = null;
            try {
                Request request = new Request.Builder().url(remoteURL).build();
                Response response = VHAPI.getOkHttpClient().newCall(request).execute();
                InputStream is = response.body().byteStream();
                byte[] buf = new byte[2048];
                int len = 0;
                FileOutputStream fos = null;
                try {
                    file = new File(localURL);
                    fos = new FileOutputStream(file);
                    while ((len = is.read(buf)) != -1) {
                        fos.write(buf, 0, len);
                    }
                    fos.flush();
                } catch (Exception e) {
                } finally {
                    try {
                        if (is != null)
                            is.close();
                    } catch (IOException e) {
                    }
                    try {
                        if (fos != null)
                            fos.close();
                    } catch (IOException e) {
                    }
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
            return file;
        }

        @Override
        protected void onPostExecute(File file) {
            super.onPostExecute(file);
            mCallback.onFile(file);
        }

        @Override
        protected void onCancelled() {
            mCallback.onFile(null);
        }
    }

    public static String readFile2String(File file) {
        String text = "";
        try {
            if (file.isFile() && file.exists()) { // 判断文件是否存在
                ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                FileInputStream fis = new FileInputStream(file);
                byte[] buffer = new byte[1024];
                int length = 0;
                while ((length = fis.read(buffer)) != -1) {//4
                    outStream.write(buffer, 0, length);
                }
                byte[] b = outStream.toByteArray();

                fis.close();
                outStream.flush();
                outStream.close();
                text = new String(b);
            } else {
                VLog.e(TAG, "找不到指定的文件");
            }
        } catch (Exception e) {
            VLog.e(TAG, "读取文件内容出错");
            e.printStackTrace();
        }
        return text;
    }

    public static String readFile2ByteArray(File file) {
        try {
            if (file.isFile() && file.exists()) { // 判断文件是否存在
                ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                FileInputStream fis = new FileInputStream(file);
                byte[] buffer = new byte[1024];
                int length = 0;
                while ((length = fis.read(buffer)) != -1) {//4
                    outStream.write(buffer, 0, length);
                }
                byte[] b = outStream.toByteArray();

                fis.close();
                outStream.flush();
                outStream.close();
                String code = "UTF-8";
                if ((b[0] == (byte) 0xFF) && (b[1] == (byte) 0xFE)) {
                    code = "UTF-16LE";
                } else if ((b[0] == (byte) 0xFE) && (b[1] == (byte) 0xFF)) {
                    code = "UTF-16BE";
                }
                return new String(b, code);
            } else {
                VLog.e(TAG, "找不到指定的文件");
            }
        } catch (Exception e) {
            VLog.e(TAG, "读取文件内容出错");
            e.printStackTrace();
        }
        return null;
    }

    /**
     * 将dp值转换为px值
     */
    public static int dp2px(Context context, float dpValue) {
        final float scale = context.getResources().getDisplayMetrics().density;
        return (int) (dpValue * scale + 0.5f);
    }

    public static int px2dp(Context context, float pxValue) {
        final float scale = context.getResources().getDisplayMetrics().density;
        return (int) (pxValue / scale + 0.5f);
    }


}
