package com.vhall.framework;

import android.annotation.SuppressLint;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Build;
import android.os.IBinder;
import android.text.TextUtils;
import android.util.Base64;

import com.vhall.beautify.IVHBeautifyInitListener;
import com.vhall.framework.beautify.BeautifyRegServiceImpl;
import com.vhall.framework.common.ICallback;
import com.vhall.framework.connect.IVHService;
import com.vhall.framework.connect.VhallConnectService;
import com.vhall.framework.lssv2.VHV2PusherServiceImpl;
import com.vhall.framework.utils.InternalUtils;
import com.vhall.framework.utils.Md5Encode;
import com.vhall.framework.utils.SignatureUtil;
import com.vhall.logmanager.L;
import com.vhall.logmanager.LogInfo;
import com.vhall.logmanager.LogReporter;
import com.vhall.logmanager.VLog;
import com.vhall.logmanager.VhallDeviceId;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.concurrent.CopyOnWriteArraySet;

/**
 * Created by Hank on 2017/11/27.
 * 基础鉴权和通讯模块
 */
public class VhallBaseSDK {
    private static final String TAG = "VhallBaseSDK";
    private static VhallBaseSDK mInstance = null;
    protected String APP_ID = "";//应用ID
    protected String packageCheck = "";//包名签名校验
    private Context mContext;//上下文
    private String mVersion = getVersionImpl();//SDK版本号
    public String mUserId = "";//第三方账号信息
    private String mUserInfo = "";
    protected String mAtom = "";
    public String mIMEI = "";
    public String mAPIHost = "https://api.vhallyun.com/sdk/";
    public String mDocHost = "";//文档域名
    public String mLogHost = "https://dc.e.vhall.com/login";//日志域名
    private VhallConnectService mService = null;
    private BaseConnection mConnection = null;
    private boolean startService = true;//是否开启service服务
    private String packageName;
    private String signature;
    private boolean hide = false;
    private InitCallback initCallback;

    public String mLicenseUrl = "";
    public String mLicenseKey = "";

    /**
     * 文档配置
     */
    public String documentExt = "[\"txt\",\"doc\",\"docx\",\"xls\",\"xlsx\",\"ppt\",\"pptx\",\"pdf\",\"gif\",\"jpeg\",\"jpg\",\"png\",\"bmp\"]";
    public int documentMaxSize = 52428800;

    public interface InitCallback {
        void onSuccess();

        void onFailure(String msg);
    }

    protected VhallBaseSDK() {
    }

    private String getVersionImpl() {
        return String.format("v%s", BuildConfig.VERSION_NAME);
    }

    public static VhallBaseSDK getInstance() {
        if (mInstance == null)
            mInstance = new VhallBaseSDK();
        return mInstance;
    }

    protected static VhallBaseSDK newInstance(VhallBaseSDK baseSDK) {
        if (mInstance == null)
            mInstance = baseSDK;
        return mInstance;
    }

    public void setStartService(boolean startService) {
        this.startService = startService;
    }

    public void setInitCallback(InitCallback initCallback) {
        this.initCallback = initCallback;
        if (mService != null) {
            mService.setInitCallback(initCallback);
        }
    }

    public void init(Context context, String appid, String userid, InitCallback initCallback) {
        initImpl(context, appid, userid, null, initCallback);

    }

    public void init(Context context, String appid, String userid, String host) {
        initImpl(context, appid, userid, host, null);
    }

    public void init(Context context, String appid, String userid) {
        initImpl(context, appid, userid, null, null);
    }

    /**
     * 调用区间[init()后, 预览页面前]
     * @param accessToken
     * @param beautifyInitListener
     */
    public void initBeautify(String accessToken, IVHBeautifyInitListener beautifyInitListener) {
        if (null == mContext || null == mService) {
            throw new IllegalStateException("please call VhallBaseSDK#init(...) before this method!");
        }
        if (null == accessToken) {
            throw new IllegalArgumentException("accessToken must not be null!");
        }

        mService.setBeautifyInitCallback(beautifyInitListener);
        join(new BeautifyRegServiceImpl(accessToken));
    }


    /**
     * 调用区间[init()后, 初始化lss_v2 认证]
     * @param accessToken
     * @param initListener
     */
    public void initLssV2(String accessToken, VhallBaseSDK.InitCallback initListener) {
        if (null == mContext || null == mService) {
            throw new IllegalStateException("please call VhallBaseSDK#init(...) before this method!");
        }
        if (null == accessToken) {
            throw new IllegalArgumentException("accessToken must not be null!");
        }

        mService.setInitCallback(initListener);
        join(new VHV2PusherServiceImpl(accessToken));
    }

    private void initImpl(Context context, String appid, String userid, String host, InitCallback initCallback) {
        if (InternalUtils.isMainProcess(context)) {
            if (!TextUtils.isEmpty(host)) {
                mAPIHost = "https://" + host + "/sdk/";
            }
            this.initCallback = initCallback;

            APP_ID = appid;
            mContext = context;
            mUserId = TextUtils.isEmpty(userid) ? String.valueOf(System.currentTimeMillis()) : userid;
            refreshAtom();
            /**
             *hkl  没有设置用户信息的时候 把用户id设置进去
             * 8/30
             */
            if (TextUtils.isEmpty(mUserInfo)){
                try {
                    JSONObject userInfo = new JSONObject();
                    userInfo.put("third_party_user_id", mUserId);
                    mUserInfo = userInfo.toString();
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            packageCheck = getPackageCheck();
            mAtom = getAtom();
            LogReporter.getInstance().init(mContext, mLogHost, mVersion, LogReporter.UNIT_PAAS, APP_ID, mUserId);
            LogInfo.getInstance().setBiz("01", "11", "des01", "des02");
            if (startService) {
                startService();
            } else {
                if (null != this.initCallback) {
                    this.initCallback.onSuccess();
                }
            }
        } else {
//            VLog.e(TAG, String.format("error process %s! please init sdk in your main process", InternalUtils.getCurrentProcessName(context)));
        }
    }

    public void setBiz(String biz_role, String biz_id, String biz_des01, String biz_des02) {
        LogInfo.getInstance().setBiz(biz_role, biz_id, biz_des01, biz_des02);
    }

    public void startService() {
        Intent connectService = new Intent(mContext, VhallConnectService.class);
        connectService.putExtra("third_party_user_id", this.mUserId);
        connectService.putExtra("userInfo", this.mUserInfo);
        connectService.putExtra("hint", this.hide);
        mConnection = new BaseConnection();
        mContext.bindService(connectService, mConnection, Context.BIND_AUTO_CREATE);
    }

    public void stopService() {
        if(mConnection != null) {
            try {
                mContext.unbindService(mConnection);
                mConnection = null;
                if (mService != null) {
                    mService.onDestroy();
                    mService = null;
                }
            } catch (Exception e) {
            }
        }
    }

    private class BaseConnection implements ServiceConnection {

        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            VhallConnectService.ConnectBinder mBinder;
            try {
                mBinder = (VhallConnectService.ConnectBinder) service;
            } catch (Exception e) {
                if (null != VhallBaseSDK.this.initCallback) {
                    VhallBaseSDK.this.initCallback.onFailure(e.getMessage());
                }
                e.printStackTrace();
                return;
            }
            CopyOnWriteArraySet<IVHService> services = null;
            if(mService != null){
                services = mService.getServices();
            }
            mService = mBinder.getService();
            mService.setInitCallback(VhallBaseSDK.this.initCallback);
            if (null != VhallBaseSDK.this.initCallback) {
                VhallBaseSDK.this.initCallback.onSuccess();
            }
            //重连成功后设置原有services
            if(services != null && !services.isEmpty()){
                for (IVHService lastService:services) {
                    join(lastService);
                }
            }
        }

        @Override
        public void onServiceDisconnected(ComponentName name) {//意外关闭
            /**
             * 处理消息异常关闭
             */
            VLog.e(TAG, "消息服务 意外关闭");
            if (mService != null)
                mService.onDestroy();
            startService();
        }
    }

    public boolean join(IVHService service) {
        if (!isEnable()) {
            VLog.e(TAG, "SDK初始化失败，消息服务将不可用！");
            return false;
        }
        mService.join(service);
        return true;
    }

    public boolean leave(IVHService service) {
        if (!isEnable()) {
            VLog.e(TAG, "SDK初始化失败，消息服务将不可用！");
            return false;
        }
        mService.leave(service);
        return true;
    }

    public boolean setUserId(String userid) {
        return setUserId(userid, null);
    }

    public boolean setUserId(String userid, InitCallback callback) {
        LogReporter.getInstance().setUserid(userid);
        LogReporter.getInstance().onCollection("2008", (JSONObject) null);
        setInitCallback(callback);
        if (TextUtils.isEmpty(userid)) {
            return false;
        } else if (!this.isEnable()) {
            VLog.e(TAG, "SDK初始化失败，消息服务将不可用！");
            return false;
        } else {
            this.mUserId = userid;
            refreshAtom();
            this.mService.setUserId(this.mUserId);
            return true;
        }
    }

    public void setHide(boolean hide) {
        this.hide = hide;
        if (!this.isEnable()) {
            VLog.e(TAG, "SDK初始化失败，消息服务将不可用！");
            return;
        }
        this.mService.setHide(hide);
    }

    public boolean setUserInfo(String userInfo) {
        return setUserInfo(userInfo, null);
    }

    public boolean setUserInfo(String userInfo, InitCallback initCallback) {
        this.mUserInfo = userInfo;
        //by wxx 2023.11.20 解决为空会覆盖原有回调问题
        if(initCallback != null)
            setInitCallback(initCallback);
        try {
            JSONObject info = new JSONObject(this.mUserInfo);
            String userId = info.optString("third_party_user_id");
            if (TextUtils.isEmpty(this.mUserId)) {
                return false;
            } else if (!this.isEnable()) {
                VLog.e("VhallSDK", "SDK初始化失败，消息服务将不可用！");
                return false;
            } else {
                if (this.mUserId.equals(userId)) {
                    this.mService.updateUserInfo(userInfo);
                } else {
                    this.mUserId = userId;
                    refreshAtom();
                    LogReporter.getInstance().setUserid(userId);
                    LogReporter.getInstance().onCollection("2008", (JSONObject) null);
                    this.mService.setUserInfo(userInfo);
                }
                return true;
            }
        } catch (JSONException var4) {
            var4.printStackTrace();
            return false;
        }
    }

    public String getmUserInfo() {
        return this.mUserInfo;
    }

    public boolean updateUserInfo(String userInfo) {
        return updateUserInfo(userInfo, null);
    }

    public boolean updateUserInfo(String userInfo, InitCallback initCallback) {
        setInitCallback(initCallback);
        try {
            JSONObject obj = new JSONObject(userInfo);
            String userId = obj.optString("third_party_user_id");
            if (this.mUserId.equals(userId)) {
                this.mUserInfo = userInfo;
                this.mService.updateUserInfo(userInfo);
                return true;
            } else {
                return false;
            }
        } catch (JSONException var4) {
            var4.printStackTrace();
            return false;
        }
    }

    public String getmUserId() {
        return mUserId;
    }

    public boolean sendMsg(String msg) {
        if (!isEnable()) {
            VLog.e(TAG, "SDK初始化失败，消息服务将不可用！");
            return false;
        }
        mService.disPatchMsg(msg);
        return true;
    }

    private String getPackageCheck() {
        if (packageName == null) {
            packageName = SignatureUtil.getPackageName(mContext);
        }
        if (signature == null) {
            signature = SignatureUtil.getSignatureSHA1(mContext, packageName);
        }
        StringBuilder builder = new StringBuilder();
        builder.append(APP_ID).append("|").append(signature).append("|").append(packageName);
        String unSignStr = builder.toString();
        try {
            unSignStr = SignatureUtil.sha256Signature(unSignStr).subSequence(0,16).toString();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return unSignStr;
    }

    public void setPackageCheck(String packageName, String signature) {
        this.packageName = packageName;
        this.signature = signature;
    }

    @SuppressLint("MissingPermission")
    private String getIMEI(Context context) {
        return VhallDeviceId.getVhallDeviceId(context);
    }

    private static final String atomFormat = "cv=%s&dt=%s&pf=%s&uid=%s&cn=%s&imei=%s";

    private void refreshAtom(){
        mAtom = getAtom();
        mIMEI = getIMEI(mContext);
    }

    protected String getAtom() {
        String mPhone = Build.BRAND + "  " + Build.MANUFACTURER;
        mIMEI = getIMEI(mContext);
        String mNetType = "";
        String atom = String.format(atomFormat, mVersion, mPhone, 5, mUserId, mNetType, mIMEI);
        VLog.d(TAG, "atom:" + atom);
        return Base64.encodeToString(atom.getBytes(), Base64.NO_WRAP);
    }

    public void destory() {
        mContext.unbindService(mConnection);
        VLog.d(TAG, "SDK destory！");
    }

    public String getVersion() {
        return mVersion;
    }

    /**
     * 改用:setLogLevel(VLog.LogLevel logLevel)
     * @param level
     */
    @Deprecated
    public void setLogLevel(L.LogLevel level) {
        L.setLogLevel(level);
    }

    public void setLogLevel(VLog.LogLevel logLevel) {
        VLog.setLogLevel(logLevel);
    }

    public String getAPP_ID() {
        return APP_ID;
    }

    public String getLicenseUrl(){return mLicenseUrl;}

    public String getLicenseKey(){return mLicenseKey;}
    /**
     * 删除初始化判断 允许消息没初始化也可以设置用户信息
     * @return
     */
    public boolean isEnable() {
        return mService != null ;
    }
}