/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.beautifykit.widget;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;

public class TouchStateImageView
extends AppCompatImageView {
    private OnTouchStateListener mOnTouchStateListener;

    public TouchStateImageView(Context context) {
        super(context);
    }

    public TouchStateImageView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public TouchStateImageView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void setOnTouchStateListener(OnTouchStateListener onTouchStateListener) {
        this.mOnTouchStateListener = onTouchStateListener;
    }

    public void setOnTouchListener(final View.OnTouchListener l) {
        View.OnTouchListener onTouchListener = new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                TouchStateImageView.this.setState(event);
                boolean ret = l.onTouch(v, event);
                if (!ret && TouchStateImageView.this.mOnTouchStateListener != null) {
                    return TouchStateImageView.this.mOnTouchStateListener.onTouch(v, event);
                }
                return ret;
            }
        };
        super.setOnTouchListener(onTouchListener);
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.setState(event);
        if (this.mOnTouchStateListener != null) {
            return this.mOnTouchStateListener.onTouch((View)this, event);
        }
        return super.onTouchEvent(event);
    }

    private void setState(MotionEvent event) {
        int action = event.getAction();
        if (action == 0) {
            this.setSelected(true);
        } else if (action == 1 || action == 3) {
            this.setSelected(false);
        }
    }

    public static interface OnTouchStateListener {
        public boolean onTouch(View var1, MotionEvent var2);
    }
}

