/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.beautifykit.seekbar.internal.drawable;

import android.content.res.ColorStateList;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;

public abstract class StateDrawable
extends Drawable {
    private ColorStateList mTintStateList;
    private final Paint mPaint;
    private int mCurrentColor;
    private int mAlpha = 255;

    public StateDrawable(@NonNull ColorStateList tintStateList) {
        this.setColorStateList(tintStateList);
        this.mPaint = new Paint(1);
    }

    public boolean isStateful() {
        return this.mTintStateList.isStateful() || super.isStateful();
    }

    public boolean setState(int[] stateSet) {
        boolean handled = super.setState(stateSet);
        handled = this.updateTint(stateSet) || handled;
        return handled;
    }

    public int getOpacity() {
        return -3;
    }

    private boolean updateTint(int[] state) {
        int color2 = this.mTintStateList.getColorForState(state, this.mCurrentColor);
        if (color2 != this.mCurrentColor) {
            this.mCurrentColor = color2;
            this.invalidateSelf();
            return true;
        }
        return false;
    }

    public void draw(Canvas canvas) {
        this.mPaint.setColor(this.mCurrentColor);
        int alpha = this.modulateAlpha(Color.alpha((int)this.mCurrentColor));
        this.mPaint.setAlpha(alpha);
        this.doDraw(canvas, this.mPaint);
    }

    public void setColorStateList(@NonNull ColorStateList tintStateList) {
        this.mTintStateList = tintStateList;
        this.mCurrentColor = tintStateList.getDefaultColor();
    }

    abstract void doDraw(Canvas var1, Paint var2);

    public void setAlpha(int alpha) {
        this.mAlpha = alpha;
        this.invalidateSelf();
    }

    int modulateAlpha(int alpha) {
        int scale = this.mAlpha + (this.mAlpha >> 7);
        return alpha * scale >> 8;
    }

    public int getAlpha() {
        return this.mAlpha;
    }

    public void setColorFilter(ColorFilter cf) {
        this.mPaint.setColorFilter(cf);
    }
}

