/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.beautifykit.seekbar;

import android.content.Context;
import android.graphics.Canvas;
import android.support.v7.widget.AppCompatSeekBar;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewParent;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B#\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u001b\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\tB\u0011\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\u0018\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u0007H\u0014J(\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u0007H\u0014J\u0006\u0010&\u001a\u00020\u001aJ\u0006\u0010'\u001a\u00020\u001aJ\u0010\u0010(\u001a\u00020\f2\u0006\u0010)\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020\u0007H\u0016J\u0010\u0010-\u001a\u00020\u001a2\u0006\u0010)\u001a\u00020*H\u0002R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006."}, d2={"Lcom/vhall/beautifykit/seekbar/VerticalSeekBar;", "Landroid/support/v7/widget/AppCompatSeekBar;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyle", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "(Landroid/content/Context;)V", "isInScrollingContainer", "", "()Z", "setInScrollingContainer", "(Z)V", "mIsDragging", "mScaledTouchSlop", "mTouchDownY", "", "mTouchProgressOffset", "getMTouchProgressOffset", "()F", "setMTouchProgressOffset", "(F)V", "attemptClaimDrag", "", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onSizeChanged", "w", "h", "oldw", "oldh", "onStartTrackingTouch", "onStopTrackingTouch", "onTouchEvent", "event", "Landroid/view/MotionEvent;", "setProgress", "progress", "trackTouchEvent", "vhall-beautify-kit_release"})
public final class VerticalSeekBar
extends AppCompatSeekBar {
    private float mTouchProgressOffset;
    private boolean mIsDragging;
    private float mTouchDownY;
    private int mScaledTouchSlop;
    private boolean isInScrollingContainer;
    private HashMap _$_findViewCache;

    public final float getMTouchProgressOffset() {
        return this.mTouchProgressOffset;
    }

    public final void setMTouchProgressOffset(float f) {
        this.mTouchProgressOffset = f;
    }

    public final boolean isInScrollingContainer() {
        return this.isInScrollingContainer;
    }

    public final void setInScrollingContainer(boolean bl) {
        this.isInScrollingContainer = bl;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(h, w, oldh, oldw);
    }

    protected synchronized void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(heightMeasureSpec, widthMeasureSpec);
        this.setMeasuredDimension(this.getMeasuredHeight(), this.getMeasuredWidth());
    }

    protected synchronized void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        canvas.rotate(-90.0f);
        canvas.translate(-((float)this.getHeight()), 0.0f);
        super.onDraw(canvas);
    }

    public boolean onTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        if (!this.isEnabled()) {
            return false;
        }
        switch (event.getAction()) {
            case 0: {
                if (this.isInScrollingContainer) {
                    this.mTouchDownY = event.getY();
                    break;
                }
                this.setPressed(true);
                this.invalidate();
                this.onStartTrackingTouch();
                this.trackTouchEvent(event);
                this.attemptClaimDrag();
                this.onSizeChanged(this.getWidth(), this.getHeight(), 0, 0);
                break;
            }
            case 2: {
                if (this.mIsDragging) {
                    this.trackTouchEvent(event);
                } else {
                    float y = event.getY();
                    if (Math.abs(y - this.mTouchDownY) > (float)this.mScaledTouchSlop) {
                        this.setPressed(true);
                        this.invalidate();
                        this.onStartTrackingTouch();
                        this.trackTouchEvent(event);
                        this.attemptClaimDrag();
                    }
                }
                this.onSizeChanged(this.getWidth(), this.getHeight(), 0, 0);
                break;
            }
            case 1: {
                if (this.mIsDragging) {
                    this.trackTouchEvent(event);
                    this.onStopTrackingTouch();
                    this.setPressed(false);
                } else {
                    this.onStartTrackingTouch();
                    this.trackTouchEvent(event);
                    this.onStopTrackingTouch();
                }
                this.onSizeChanged(this.getWidth(), this.getHeight(), 0, 0);
                this.invalidate();
                break;
            }
        }
        return true;
    }

    private final void trackTouchEvent(MotionEvent event) {
        int height = this.getHeight();
        int top = this.getPaddingTop();
        int bottom = this.getPaddingBottom();
        int available = height - top - bottom;
        int y = (int)event.getY();
        float scale = 0.0f;
        float progress = 0.0f;
        if (y > height - bottom) {
            scale = 0.0f;
        } else if (y < top) {
            scale = 1.0f;
        } else {
            scale = (float)(available - y + top) / (float)available;
            progress = this.mTouchProgressOffset;
        }
        int max = this.getMax();
        this.setProgress((int)(progress += scale * (float)max));
    }

    public final void onStartTrackingTouch() {
        this.mIsDragging = true;
    }

    public final void onStopTrackingTouch() {
        this.mIsDragging = false;
    }

    private final void attemptClaimDrag() {
        block0: {
            ViewParent p;
            ViewParent viewParent = p = this.getParent();
            if (viewParent == null) break block0;
            viewParent.requestDisallowInterceptTouchEvent(true);
        }
    }

    public synchronized void setProgress(int progress) {
        super.setProgress(progress);
        this.onSizeChanged(this.getWidth(), this.getHeight(), 0, 0);
    }

    public VerticalSeekBar(@Nullable Context context, @Nullable AttributeSet attrs, int defStyle) {
        Context context2 = context;
        if (context2 == null) {
            Intrinsics.throwNpe();
        }
        super(context2, attrs, defStyle);
        ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)context);
        Intrinsics.checkExpressionValueIsNotNull((Object)viewConfiguration, (String)"ViewConfiguration.get(context)");
        this.mScaledTouchSlop = viewConfiguration.getScaledTouchSlop();
    }

    public VerticalSeekBar(@Nullable Context context, @Nullable AttributeSet attrs) {
        Context context2 = context;
        if (context2 == null) {
            Intrinsics.throwNpe();
        }
        super(context2, attrs);
    }

    public VerticalSeekBar(@Nullable Context context) {
        Context context2 = context;
        if (context2 == null) {
            Intrinsics.throwNpe();
        }
        super(context2);
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }
}

