/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.beautifykit.circle;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import com.vhall.beautifykit.R;
import com.vhall.beautifykit.utils.BitmapUtils;

public class RingCircleView
extends View {
    private static final String TAG = "RingCircleView";
    private int mDefaultSize;
    private Paint mPaintOuter;
    private Paint mPaintInner;
    private Paint mPaintBitmap;
    private int mFillColor = -16711936;
    private int mInnerPadding;
    private Bitmap mBitmapPick;
    private Bitmap mBitmapBg;
    private Rect mBitmapRect = new Rect();
    private int mDrawType = 1;
    public static final int TYPE_NORMAL = 1;
    public static final int TYPE_TRANSPARENT = 2;
    public static final int TYPE_PICK_TRANSPARENT = 3;
    public static final int TYPE_PICK_COLOR = 4;

    public RingCircleView(@NonNull Context context) {
        this(context, null);
    }

    public RingCircleView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RingCircleView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        if (attrs != null) {
            TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.RingCircleView);
            this.mInnerPadding = (int)typedArray.getDimension(R.styleable.RingCircleView_inner_padding, (float)this.getResources().getDimensionPixelSize(R.dimen.x20));
            typedArray.recycle();
        }
        this.mDefaultSize = this.getResources().getDimensionPixelSize(R.dimen.x88);
        this.mPaintOuter = new Paint(1);
        this.mPaintOuter.setStyle(Paint.Style.STROKE);
        this.mPaintOuter.setStrokeWidth((float)this.getResources().getDimensionPixelSize(R.dimen.x4));
        this.mPaintOuter.setColor(-1);
        this.mPaintInner = new Paint(1);
        this.mPaintInner.setStyle(Paint.Style.FILL);
        this.mPaintInner.setColor(this.mFillColor);
        this.mPaintBitmap = new Paint(1);
    }

    public void setFillColor(int fillColor) {
        this.mFillColor = fillColor;
        this.mPaintInner.setColor(this.mFillColor);
        this.invalidate();
    }

    public void setDrawType(int drawType) {
        this.mDrawType = drawType;
        this.invalidate();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int measuredWidth = this.getMeasuredWidth();
        int measuredHeight = this.getMeasuredHeight();
        if (widthMode == Integer.MIN_VALUE && heightMode == Integer.MIN_VALUE) {
            measuredWidth = this.mDefaultSize;
            measuredHeight = this.mDefaultSize;
        } else if (widthMode == Integer.MIN_VALUE) {
            measuredWidth = this.mDefaultSize;
            measuredHeight = heightSize;
        } else if (heightMode == Integer.MIN_VALUE) {
            measuredHeight = this.mDefaultSize;
            measuredWidth = widthSize;
        }
        int minSize = Math.min(measuredWidth, measuredHeight);
        this.setMeasuredDimension(minSize, minSize);
    }

    protected void onDraw(Canvas canvas) {
        int maxPadding;
        super.onDraw(canvas);
        int width = this.getMeasuredWidth();
        int centerX = width / 2;
        int height = this.getMeasuredHeight();
        int centerY = height / 2;
        int paddingLeft = this.getPaddingLeft();
        int paddingRight = this.getPaddingRight();
        int paddingTop = this.getPaddingTop();
        int paddingBottom = this.getPaddingBottom();
        paddingLeft = maxPadding = Math.max(Math.max(paddingLeft, paddingTop), Math.max(paddingRight, paddingBottom));
        paddingRight = maxPadding;
        paddingTop = maxPadding;
        paddingBottom = maxPadding;
        boolean selected = this.isSelected();
        int diameter = Math.min(width - paddingLeft - paddingRight, height - paddingTop - paddingBottom);
        float radius = (float)diameter / 2.0f;
        switch (this.mDrawType) {
            case 1: {
                if (selected) {
                    float innerRadius = ((float)diameter - (float)this.mInnerPadding) / 2.0f;
                    canvas.drawCircle((float)centerX, (float)centerY, radius, this.mPaintOuter);
                    canvas.drawCircle((float)centerX, (float)centerX, innerRadius, this.mPaintInner);
                    break;
                }
                canvas.drawCircle((float)centerX, (float)centerY, radius, this.mPaintInner);
                break;
            }
            case 4: {
                float innerRadius = ((float)diameter - (float)this.mInnerPadding) / 2.0f;
                canvas.drawCircle((float)centerX, (float)centerY, radius, this.mPaintOuter);
                canvas.drawCircle((float)centerX, (float)centerX, innerRadius, this.mPaintInner);
                break;
            }
            case 3: {
                if (this.mBitmapPick == null) {
                    this.mBitmapPick = BitmapUtils.INSTANCE.decodeSampledBitmapFromResource(this.getResources(), R.mipmap.icon_green_straw, diameter, diameter);
                }
                if (this.mBitmapBg == null) {
                    this.mBitmapBg = BitmapUtils.INSTANCE.decodeSampledBitmapFromResource(this.getResources(), R.mipmap.icon_green_transparent, diameter, diameter);
                }
                this.mBitmapRect.left = paddingLeft;
                this.mBitmapRect.top = paddingTop;
                this.mBitmapRect.right = width - paddingRight;
                this.mBitmapRect.bottom = height - paddingBottom;
                canvas.drawBitmap(this.mBitmapBg, null, this.mBitmapRect, this.mPaintBitmap);
                canvas.drawBitmap(this.mBitmapPick, null, this.mBitmapRect, this.mPaintBitmap);
                break;
            }
            case 2: {
                canvas.drawCircle((float)centerX, (float)centerY, radius, this.mPaintOuter);
                int padding = this.mInnerPadding / 2;
                this.mBitmapRect.left = paddingLeft + padding;
                this.mBitmapRect.top = paddingTop + padding;
                this.mBitmapRect.right = width - paddingRight - padding;
                this.mBitmapRect.bottom = height - paddingBottom - padding;
                canvas.drawBitmap(this.mBitmapBg, null, this.mBitmapRect, this.mPaintBitmap);
                break;
            }
        }
    }
}

