/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.beautifykit.circle;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.RectF;
import android.os.Build;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewOutlineProvider;
import com.vhall.beautifykit.R;
import com.vhall.beautifykit.circle.CircleFilledColor;

public class ColorfulCircleView
extends View {
    private static final int DEFAULT_COLOR = 0xFFFFFF;
    private Paint mPaint1;
    private Paint mPaint2;
    private Paint mPaint4;
    private Paint mPaint3;
    private RectF mBoundRectF;
    private CircleFilledColor mCircleFillColor;
    private int mDefaultSize;

    public ColorfulCircleView(Context context) {
        super(context);
        this.init();
    }

    public ColorfulCircleView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
        this.init();
    }

    public ColorfulCircleView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ColorfulCircleView);
        int fillColor1 = typedArray.getColor(R.styleable.ColorfulCircleView_fill_color_1, 0xFFFFFF);
        int fillColor2 = typedArray.getColor(R.styleable.ColorfulCircleView_fill_color_2, 0xFFFFFF);
        int fillColor3 = typedArray.getColor(R.styleable.ColorfulCircleView_fill_color_3, 0xFFFFFF);
        int fillColor4 = typedArray.getColor(R.styleable.ColorfulCircleView_fill_color_4, 0xFFFFFF);
        int fillMode = typedArray.getInt(R.styleable.ColorfulCircleView_fill_mode, CircleFilledColor.FillMode.SINGLE.getValue());
        this.mCircleFillColor = new CircleFilledColor(fillColor1, fillColor2, fillColor3, fillColor4, CircleFilledColor.FillMode.ofValue(fillMode));
        typedArray.recycle();
        this.init();
    }

    private void init() {
        this.mPaint1 = new Paint(1);
        this.mPaint1.setStyle(Paint.Style.FILL);
        this.mPaint1.setColor(this.mCircleFillColor.getFillColor1());
        this.mPaint2 = new Paint(1);
        this.mPaint2.setStyle(Paint.Style.FILL);
        this.mPaint2.setColor(this.mCircleFillColor.getFillColor2());
        this.mPaint3 = new Paint(1);
        this.mPaint3.setStyle(Paint.Style.FILL);
        this.mPaint3.setColor(this.mCircleFillColor.getFillColor3());
        this.mPaint4 = new Paint(1);
        this.mPaint4.setStyle(Paint.Style.FILL);
        this.mPaint4.setColor(this.mCircleFillColor.getFillColor4());
        this.mBoundRectF = new RectF();
        this.mDefaultSize = this.getResources().getDimensionPixelSize(R.dimen.x80);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int measuredWidth = this.getMeasuredWidth();
        int measuredHeight = this.getMeasuredHeight();
        if (widthMode == Integer.MIN_VALUE && heightMode == Integer.MIN_VALUE) {
            measuredWidth = this.mDefaultSize;
            measuredHeight = this.mDefaultSize;
        } else if (widthMode == Integer.MIN_VALUE) {
            measuredWidth = this.mDefaultSize;
            measuredHeight = heightSize;
        } else if (heightMode == Integer.MIN_VALUE) {
            measuredHeight = this.mDefaultSize;
            measuredWidth = widthSize;
        }
        int minSize = Math.min(measuredWidth, measuredHeight);
        this.setMeasuredDimension(minSize, minSize);
    }

    protected void onDraw(Canvas canvas) {
        int maxPadding;
        super.onDraw(canvas);
        int width = this.getMeasuredWidth();
        int height = this.getMeasuredHeight();
        int paddingLeft = this.getPaddingLeft();
        int paddingRight = this.getPaddingRight();
        int paddingTop = this.getPaddingTop();
        int paddingBottom = this.getPaddingBottom();
        paddingLeft = maxPadding = Math.max(Math.max(paddingLeft, paddingTop), Math.max(paddingRight, paddingBottom));
        paddingRight = maxPadding;
        paddingTop = maxPadding;
        paddingBottom = maxPadding;
        final int left = paddingLeft;
        final int top = paddingTop;
        final int right = width - paddingRight;
        final int bottom = height - paddingBottom;
        this.mBoundRectF.set((float)paddingLeft, (float)paddingTop, (float)right, (float)bottom);
        if (Build.VERSION.SDK_INT >= 21) {
            ViewOutlineProvider viewOutlineProvider = new ViewOutlineProvider(){

                public void getOutline(View view, Outline outline) {
                    outline.setOval(left, top, right, bottom);
                }
            };
            this.setOutlineProvider(viewOutlineProvider);
        }
        switch (this.mCircleFillColor.getFillMode()) {
            case SINGLE: {
                canvas.drawArc(this.mBoundRectF, 0.0f, 360.0f, true, this.mPaint1);
                break;
            }
            case DOUBLE: {
                canvas.drawArc(this.mBoundRectF, 0.0f, 180.0f, true, this.mPaint2);
                canvas.drawArc(this.mBoundRectF, 180.0f, 180.0f, true, this.mPaint1);
                break;
            }
            case TRIPLE: {
                canvas.drawArc(this.mBoundRectF, 0.0f, 360.0f, true, this.mPaint2);
                canvas.drawArc(this.mBoundRectF, 20.0f, 140.0f, false, this.mPaint3);
                canvas.drawArc(this.mBoundRectF, 200.0f, 140.0f, false, this.mPaint1);
                break;
            }
            case QUADRUPLE: {
                canvas.drawArc(this.mBoundRectF, 0.0f, 90.0f, true, this.mPaint4);
                canvas.drawArc(this.mBoundRectF, 90.0f, 90.0f, true, this.mPaint3);
                canvas.drawArc(this.mBoundRectF, 180.0f, 90.0f, true, this.mPaint2);
                canvas.drawArc(this.mBoundRectF, 270.0f, 90.0f, true, this.mPaint1);
                break;
            }
        }
    }

    public void setCircleFillColor(CircleFilledColor circleFillColor) {
        this.mCircleFillColor = circleFillColor;
        this.mPaint1.setColor(circleFillColor.getFillColor1());
        this.mPaint2.setColor(circleFillColor.getFillColor2());
        this.mPaint3.setColor(circleFillColor.getFillColor3());
        this.mPaint4.setColor(circleFillColor.getFillColor4());
        this.invalidate();
    }

    public CircleFilledColor getCircleFillColor() {
        return this.mCircleFillColor;
    }
}

