/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.beautifykit.utils;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0002J*\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004J&\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004\u00a8\u0006\u0016"}, d2={"Lcom/vhall/beautifykit/utils/BitmapUtils;", "", "()V", "calculateInSampleSize", "", "options", "Landroid/graphics/BitmapFactory$Options;", "reqWidth", "reqHeight", "decodeSampledBitmapFromResource", "Landroid/graphics/Bitmap;", "resource", "Landroid/content/res/Resources;", "resId", "encodeYUV420SP", "", "yuv420sp", "", "argb", "", "width", "height", "vhall-beautify-kit_release"})
public final class BitmapUtils {
    public static final BitmapUtils INSTANCE;

    /*
     * WARNING - void declaration
     */
    public final void encodeYUV420SP(@NotNull byte[] yuv420sp, @NotNull int[] argb, int width, int height) {
        Intrinsics.checkParameterIsNotNull((Object)yuv420sp, (String)"yuv420sp");
        Intrinsics.checkParameterIsNotNull((Object)argb, (String)"argb");
        int frameSize = width * height;
        int yIndex = 0;
        int uvIndex = frameSize;
        int A = 0;
        int R2 = 0;
        int G = 0;
        int B = 0;
        int Y = 0;
        int U = 0;
        int V = 0;
        int index = 0;
        int n = 0;
        int n2 = height;
        while (n < n2) {
            void j;
            int n3 = 0;
            int n4 = width;
            while (n3 < n4) {
                void i;
                A = (argb[index] & 0xFF000000) >> 24;
                R2 = (argb[index] & 0xFF0000) >> 16;
                G = (argb[index] & 0xFF00) >> 8;
                B = (argb[index] & 0xFF) >> 0;
                Y = (66 * R2 + 129 * G + 25 * B + 128 >> 8) + 16;
                U = (-38 * R2 - 74 * G + 112 * B + 128 >> 8) + 128;
                V = (112 * R2 - 94 * G - 18 * B + 128 >> 8) + 128;
                yuv420sp[yIndex++] = (byte)(Y < 0 ? 0 : (Y > 255 ? 255 : Y));
                if (j % 2 == false && index % 2 == 0) {
                    yuv420sp[uvIndex++] = (byte)(V < 0 ? 0 : (V > 255 ? 255 : V));
                    yuv420sp[uvIndex++] = (byte)(U < 0 ? 0 : (U > 255 ? 255 : U));
                }
                ++index;
                ++i;
            }
            ++j;
        }
    }

    @Nullable
    public final Bitmap decodeSampledBitmapFromResource(@Nullable Resources resource, int resId, int reqWidth, int reqHeight) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeResource((Resources)resource, (int)resId, (BitmapFactory.Options)options);
        options.inSampleSize = this.calculateInSampleSize(options, reqWidth, reqHeight);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeResource((Resources)resource, (int)resId, (BitmapFactory.Options)options);
    }

    private final int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            int halfHeight = height / 2;
            int halfWidth = width / 2;
            while (halfHeight / inSampleSize >= reqHeight && halfWidth / inSampleSize >= reqWidth) {
                inSampleSize *= 2;
            }
        }
        return inSampleSize;
    }

    private BitmapUtils() {
    }

    static {
        BitmapUtils bitmapUtils;
        INSTANCE = bitmapUtils = new BitmapUtils();
    }
}

