/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.beautifykit.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.IdRes;
import android.support.annotation.IntRange;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.v7.widget.RecyclerView;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.vhall.beautifykit.listener.OnMultiClickListener;
import java.util.List;

public abstract class BaseRecyclerAdapter<T>
extends RecyclerView.Adapter<BaseViewHolder> {
    public static final int NO_CHOICE_MODE = 0;
    public static final int SINGLE_CHOICE_MODE = 1;
    public static final int MULTI_CHOICE_MODE = 2;
    private static final int DEFAULT_SELECTED_POSITION = Integer.MIN_VALUE;
    protected int mLastSelected = Integer.MIN_VALUE;
    protected List<T> mData;
    protected int mLayoutResId;
    private OnItemClickListener<T> mOnItemClickListener;
    private OnItemLongClickListener<T> mOnItemLongClickListener;
    private SparseArray<T> mSelectedItems;

    public BaseRecyclerAdapter(@NonNull List<T> data, @LayoutRes int layoutResId) {
        this.mData = data;
        this.mLayoutResId = layoutResId;
        this.mSelectedItems = new SparseArray();
    }

    @NonNull
    public BaseViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        BaseViewHolder viewHolder = BaseViewHolder.createViewHolder(parent, this.mLayoutResId);
        View itemView = viewHolder.getItemView();
        itemView.setOnClickListener((View.OnClickListener)new InnerItemViewClickListener(viewHolder));
        itemView.setOnLongClickListener((View.OnLongClickListener)new InnerItemLongClickListener(viewHolder));
        return viewHolder;
    }

    public void onBindViewHolder(@NonNull BaseViewHolder viewHolder, int position) {
        T data = this.mData.get(position);
        this.bindViewHolder(viewHolder, data);
        int choiceMode = this.choiceMode();
        if (choiceMode == 1) {
            this.handleSelectedState(viewHolder, data, position == this.mLastSelected);
        } else if (choiceMode == 2) {
            boolean selected = this.mSelectedItems.get(position) != null;
            this.handleSelectedState(viewHolder, data, selected);
        }
    }

    public int getItemCount() {
        return this.mData.size();
    }

    public List<T> getData() {
        return this.mData;
    }

    @Nullable
    public T getItem(@IntRange(from=0L) int position) {
        if (this.isValidPosition(position)) {
            return this.mData.get(position);
        }
        return null;
    }

    @ChoiceMode
    protected int choiceMode() {
        return 1;
    }

    protected void handleSelectedState(BaseViewHolder viewHolder, T data, boolean selected) {
        viewHolder.setViewSelected(selected);
    }

    protected abstract void bindViewHolder(BaseViewHolder var1, T var2);

    public OnItemClickListener<T> getOnItemClickListener() {
        return this.mOnItemClickListener;
    }

    public void setOnItemClickListener(OnItemClickListener<T> onItemClickListener) {
        this.mOnItemClickListener = onItemClickListener;
    }

    public void setOnItemLongClickListener(OnItemLongClickListener<T> onItemLongClickListener) {
        this.mOnItemLongClickListener = onItemLongClickListener;
    }

    public void setItemSelected(@NonNull T data) {
        int lastSelected = this.mLastSelected;
        this.mLastSelected = this.indexOf(data);
        if (this.mLastSelected >= 0) {
            this.mSelectedItems.put(this.mLastSelected, data);
            this.notifyItemChanged(this.mLastSelected);
        }
        if (lastSelected != this.mLastSelected) {
            this.mSelectedItems.remove(lastSelected);
        }
        if (lastSelected >= 0) {
            this.notifyItemChanged(lastSelected);
        }
    }

    public void setItemSelected(@IntRange(from=0L) int pos) {
        if (this.isValidPosition(pos)) {
            this.setItemSelected(this.mData.get(pos));
        }
    }

    public void setItemsSelected(@NonNull List<T> data) {
        if (data.size() > 0) {
            for (T datum : data) {
                this.setItemSelected(datum);
            }
        }
    }

    public void setAllItemSelected() {
        if (this.choiceMode() == 2) {
            for (T item : this.mData) {
                int index = this.indexOf(item);
                this.mSelectedItems.put(index, item);
                this.notifyItemChanged(index);
            }
        }
    }

    public void clearSingleItemSelected() {
        this.mSelectedItems.clear();
        if (this.isValidPosition(this.mLastSelected)) {
            this.notifyItemChanged(this.mLastSelected);
        }
        this.mLastSelected = Integer.MIN_VALUE;
    }

    public void clearMultiItemSelected() {
        int size = this.mSelectedItems.size();
        for (int i = 0; i < size; ++i) {
            Object t = this.mSelectedItems.valueAt(i);
            int index = this.indexOf(t);
            if (index < 0) continue;
            this.notifyItemChanged(index);
        }
        this.mSelectedItems.clear();
    }

    public void add(@NonNull T data) {
        this.mData.add(data);
        int index = this.lastIndexOf(data);
        this.notifyItemInserted(index);
    }

    public void addAll(@NonNull List<T> data) {
        this.mData.addAll(data);
        for (T datum : data) {
            int index = this.indexOf(datum);
            this.notifyItemInserted(index);
        }
    }

    public void replaceAll(@NonNull List<T> data) {
        this.mSelectedItems.clear();
        this.mData.clear();
        this.mData.addAll(data);
        this.mLastSelected = Integer.MIN_VALUE;
        this.notifyDataSetChanged();
    }

    public void add(@IntRange(from=0L) int position, @NonNull T data) {
        this.mData.add(position, data);
        this.notifyItemInserted(position);
    }

    public void update(@NonNull T data) {
        int index = this.indexOf(data);
        if (index >= 0) {
            this.mData.set(index, data);
            if (this.mSelectedItems.get(index) != null) {
                this.mSelectedItems.put(index, data);
            }
            this.notifyItemChanged(index);
        }
    }

    public void removeAll() {
        this.mData.clear();
        this.mSelectedItems.clear();
        this.notifyDataSetChanged();
    }

    public void update(@IntRange(from=0L) int position, @NonNull T data) {
        this.mData.set(position, data);
        if (this.mSelectedItems.get(position) != null) {
            this.mSelectedItems.put(position, data);
        }
        this.notifyItemChanged(position);
    }

    public void remove(@NonNull T data) {
        int index = this.indexOf(data);
        if (this.isValidPosition(index)) {
            this.mSelectedItems.remove(index);
            this.mData.remove(index);
            this.notifyItemRemoved(index);
        }
    }

    public void remove(@IntRange(from=0L) int position) {
        if (this.isValidPosition(position)) {
            this.mData.remove(position);
            this.mSelectedItems.remove(position);
            this.notifyItemRemoved(position);
        }
    }

    public boolean isAllItemSelected() {
        return this.mSelectedItems.size() == this.mData.size();
    }

    public SparseArray<T> getSelectedItems() {
        return this.mSelectedItems;
    }

    private boolean isValidPosition(int position) {
        return position >= 0 && position < this.mData.size();
    }

    public int indexOf(@NonNull T data) {
        return this.mData.indexOf(data);
    }

    public int lastIndexOf(@NonNull T data) {
        return this.mData.lastIndexOf(data);
    }

    public class InnerItemViewClickListener
    extends OnMultiClickListener {
        private BaseViewHolder mViewHolder;

        public InnerItemViewClickListener(BaseViewHolder viewHolder) {
            this.mViewHolder = viewHolder;
        }

        @Override
        protected void onMultiClick(View view) {
            int position = this.mViewHolder.getAdapterPosition();
            if (position < 0) {
                return;
            }
            int choiceMode = BaseRecyclerAdapter.this.choiceMode();
            Object selectedData = BaseRecyclerAdapter.this.getItem(position);
            if (choiceMode == 1) {
                BaseRecyclerAdapter.this.mSelectedItems.put(position, selectedData);
                if (BaseRecyclerAdapter.this.isValidPosition(BaseRecyclerAdapter.this.mLastSelected) && BaseRecyclerAdapter.this.mLastSelected != position) {
                    BaseRecyclerAdapter.this.mSelectedItems.remove(BaseRecyclerAdapter.this.mLastSelected);
                }
                BaseRecyclerAdapter.this.notifyItemChanged(BaseRecyclerAdapter.this.mLastSelected);
                BaseRecyclerAdapter.this.notifyItemChanged(position);
                BaseRecyclerAdapter.this.mLastSelected = position;
            } else if (choiceMode == 2) {
                boolean isClicked;
                boolean bl = isClicked = !view.isSelected();
                if (isClicked) {
                    BaseRecyclerAdapter.this.mSelectedItems.put(position, selectedData);
                } else {
                    BaseRecyclerAdapter.this.mSelectedItems.remove(position);
                }
                BaseRecyclerAdapter.this.notifyItemChanged(position);
            }
            if (BaseRecyclerAdapter.this.mOnItemClickListener != null) {
                BaseRecyclerAdapter.this.mOnItemClickListener.onItemClick(BaseRecyclerAdapter.this, view, position);
            }
        }
    }

    public class InnerItemLongClickListener
    implements View.OnLongClickListener {
        private BaseViewHolder mViewHolder;

        public InnerItemLongClickListener(BaseViewHolder viewHolder) {
            this.mViewHolder = viewHolder;
        }

        public boolean onLongClick(View v) {
            if (BaseRecyclerAdapter.this.mOnItemLongClickListener != null) {
                return BaseRecyclerAdapter.this.mOnItemLongClickListener.onItemLongClick(BaseRecyclerAdapter.this, v, this.mViewHolder.getAdapterPosition());
            }
            return false;
        }
    }

    public static class BaseViewHolder
    extends RecyclerView.ViewHolder {
        private SparseArray<View> mViews = new SparseArray();

        private BaseViewHolder(View itemView) {
            super(itemView);
        }

        public static BaseViewHolder createViewHolder(ViewGroup parent, int layoutResId) {
            LayoutInflater layoutInflater = LayoutInflater.from((Context)parent.getContext());
            View view = layoutInflater.inflate(layoutResId, parent, false);
            return new BaseViewHolder(view);
        }

        public View getItemView() {
            return this.itemView;
        }

        public <T extends View> T getViewById(@IdRes int viewId) {
            View view = (View)this.mViews.get(viewId);
            if (view == null) {
                view = this.itemView.findViewById(viewId);
                this.mViews.put(viewId, (Object)view);
            }
            return (T)view;
        }

        public BaseViewHolder setViewSelected(boolean selected) {
            this.getItemView().setSelected(selected);
            return this;
        }

        public BaseViewHolder setText(@IdRes int id2, @StringRes int strId) {
            Object view = this.getViewById(id2);
            if (view instanceof TextView) {
                ((TextView)view).setText(strId);
            }
            return this;
        }

        public BaseViewHolder setText(@IdRes int id2, String text) {
            Object view = this.getViewById(id2);
            if (view instanceof TextView) {
                ((TextView)view).setText((CharSequence)text);
            }
            return this;
        }

        public BaseViewHolder setImageBitmap(@IdRes int id2, Bitmap bitmap) {
            Object view = this.getViewById(id2);
            if (view instanceof ImageView) {
                ((ImageView)view).setImageBitmap(bitmap);
            }
            return this;
        }

        public BaseViewHolder setImageResource(@IdRes int id2, @DrawableRes int drawable2) {
            Object view = this.getViewById(id2);
            if (view instanceof ImageView) {
                ((ImageView)view).setImageResource(drawable2);
            }
            return this;
        }

        public BaseViewHolder setImageDrawable(@IdRes int id2, Drawable drawable2) {
            Object view = this.getViewById(id2);
            if (view instanceof ImageView) {
                ((ImageView)view).setImageDrawable(drawable2);
            }
            return this;
        }

        public BaseViewHolder setOnClickListener(@IdRes int id2, View.OnClickListener listener) {
            this.getViewById(id2).setOnClickListener(listener);
            return this;
        }

        public BaseViewHolder setVisibility(@IdRes int id2, int visible) {
            Object view = this.getViewById(id2);
            if (view != null && view.getVisibility() != visible) {
                view.setVisibility(visible);
            }
            return this;
        }

        public BaseViewHolder setTag(@IdRes int id2, Object obj) {
            this.getViewById(id2).setTag(obj);
            return this;
        }

        public BaseViewHolder setTag(Object obj) {
            this.getItemView().setTag(obj);
            return this;
        }

        public BaseViewHolder setViewSelected(@IdRes int id2, boolean selected) {
            Object view = this.getViewById(id2);
            view.setSelected(selected);
            return this;
        }

        public BaseViewHolder setEnabled(@IdRes int id2, boolean enabled) {
            Object view = this.getViewById(id2);
            view.setEnabled(enabled);
            return this;
        }

        public BaseViewHolder setTextStyle(@IdRes int id2, int textStype) {
            Object view = this.getViewById(id2);
            if (view instanceof TextView) {
                ((TextView)view).setTypeface(null, textStype);
            }
            return this;
        }

        public BaseViewHolder setTextColor(@IdRes int id2, @ColorInt int color2) {
            Object view = this.getViewById(id2);
            if (view instanceof TextView) {
                ((TextView)view).setTextColor(color2);
            }
            return this;
        }

        public BaseViewHolder setBackground(@IdRes int id2, @DrawableRes int drawable2) {
            Object view = this.getViewById(id2);
            view.setBackgroundResource(drawable2);
            return this;
        }
    }

    public static interface OnItemLongClickListener<T> {
        public boolean onItemLongClick(BaseRecyclerAdapter<T> var1, View var2, int var3);
    }

    public static interface OnItemClickListener<T> {
        public void onItemClick(BaseRecyclerAdapter<T> var1, View var2, int var3);
    }

    public static @interface ChoiceMode {
    }
}

