/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.beautifykit.seekbar.internal;

import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.IBinder;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import com.vhall.beautifykit.seekbar.internal.Marker;
import com.vhall.beautifykit.seekbar.internal.compat.SeekBarCompat;
import com.vhall.beautifykit.seekbar.internal.drawable.MarkerDrawable;

public class PopupIndicator {
    private final WindowManager mWindowManager;
    private boolean mShowing;
    private Floater mPopupView;
    private MarkerDrawable.MarkerAnimationListener mListener;
    private int[] mDrawingLocation = new int[2];
    Point screenSize = new Point();

    public PopupIndicator(Context context, AttributeSet attrs, int defStyleAttr, String maxValue, int thumbSize, int separation) {
        this.mWindowManager = (WindowManager)context.getSystemService("window");
        this.mPopupView = new Floater(context, attrs, defStyleAttr, maxValue, thumbSize, separation);
    }

    public void updateSizes(String maxValue) {
        this.dismissComplete();
        if (this.mPopupView != null) {
            this.mPopupView.mMarker.resetSizes(maxValue);
        }
    }

    public void setListener(MarkerDrawable.MarkerAnimationListener listener) {
        this.mListener = listener;
    }

    private void measureFloater() {
        int specWidth = View.MeasureSpec.makeMeasureSpec((int)this.screenSize.x, (int)0x40000000);
        int specHeight = View.MeasureSpec.makeMeasureSpec((int)this.screenSize.y, (int)Integer.MIN_VALUE);
        this.mPopupView.measure(specWidth, specHeight);
    }

    public void setValue(CharSequence value) {
        this.mPopupView.mMarker.setValue(value);
    }

    public boolean isShowing() {
        return this.mShowing;
    }

    public void showIndicator(View parent, Rect touchBounds) {
        if (this.isShowing()) {
            this.mPopupView.mMarker.animateOpen();
            return;
        }
        IBinder windowToken = parent.getWindowToken();
        if (windowToken != null) {
            WindowManager.LayoutParams p = this.createPopupLayout(windowToken);
            p.gravity = 0x800033;
            this.updateLayoutParamsForPosiion(parent, p, touchBounds.bottom);
            this.mShowing = true;
            this.translateViewIntoPosition(touchBounds.centerX());
            this.invokePopup(p);
        }
    }

    public void move(int x) {
        if (!this.isShowing()) {
            return;
        }
        this.translateViewIntoPosition(x);
    }

    public void setColors(int startColor, int endColor) {
        this.mPopupView.setColors(startColor, endColor);
    }

    public void dismiss() {
        this.mPopupView.mMarker.animateClose();
    }

    public void dismissComplete() {
        if (this.isShowing()) {
            this.mShowing = false;
            this.mWindowManager.removeViewImmediate((View)this.mPopupView);
        }
    }

    private void updateLayoutParamsForPosiion(View anchor, WindowManager.LayoutParams p, int yOffset) {
        DisplayMetrics displayMetrics = anchor.getResources().getDisplayMetrics();
        this.screenSize.set(displayMetrics.widthPixels, displayMetrics.heightPixels);
        this.measureFloater();
        int measuredHeight = this.mPopupView.getMeasuredHeight();
        int paddingBottom = this.mPopupView.mMarker.getPaddingBottom();
        anchor.getLocationInWindow(this.mDrawingLocation);
        p.x = 0;
        p.y = this.mDrawingLocation[1] - measuredHeight + yOffset + paddingBottom;
        p.width = this.screenSize.x;
        p.height = measuredHeight;
    }

    private void translateViewIntoPosition(int x) {
        this.mPopupView.setFloatOffset(x + this.mDrawingLocation[0]);
    }

    private void invokePopup(WindowManager.LayoutParams p) {
        this.mWindowManager.addView((View)this.mPopupView, (ViewGroup.LayoutParams)p);
        this.mPopupView.mMarker.animateOpen();
    }

    private WindowManager.LayoutParams createPopupLayout(IBinder token) {
        WindowManager.LayoutParams p = new WindowManager.LayoutParams();
        p.gravity = 0x800033;
        p.width = -1;
        p.height = -1;
        p.format = -3;
        p.flags = this.computeFlags(p.flags);
        p.type = 1000;
        p.token = token;
        p.softInputMode = 3;
        p.setTitle((CharSequence)("DiscreteSeekBar Indicator:" + Integer.toHexString(this.hashCode())));
        return p;
    }

    private int computeFlags(int curFlags) {
        curFlags &= 0xFFF97DE7;
        curFlags |= 0x8000;
        curFlags |= 8;
        curFlags |= 0x10;
        return curFlags |= 0x200;
    }

    private class Floater
    extends FrameLayout
    implements MarkerDrawable.MarkerAnimationListener {
        private Marker mMarker;
        private int mOffset;

        public Floater(Context context, AttributeSet attrs, int defStyleAttr, String maxValue, int thumbSize, int separation) {
            super(context);
            this.mMarker = new Marker(context, attrs, defStyleAttr, maxValue, thumbSize, separation);
            this.addView((View)this.mMarker, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2, 51));
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            this.measureChildren(widthMeasureSpec, heightMeasureSpec);
            int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int heightSie = this.mMarker.getMeasuredHeight();
            this.setMeasuredDimension(widthSize, heightSie);
        }

        protected void onLayout(boolean changed, int l, int t, int r, int b) {
            int centerDiffX = this.mMarker.getMeasuredWidth() / 2;
            int offset = this.mOffset - centerDiffX;
            this.mMarker.layout(offset, 0, offset + this.mMarker.getMeasuredWidth(), this.mMarker.getMeasuredHeight());
        }

        public void setFloatOffset(int x) {
            this.mOffset = x;
            int centerDiffX = this.mMarker.getMeasuredWidth() / 2;
            int offset = x - centerDiffX;
            this.mMarker.offsetLeftAndRight(offset - this.mMarker.getLeft());
            if (!SeekBarCompat.isHardwareAccelerated((View)this)) {
                this.invalidate();
            }
        }

        @Override
        public void onClosingComplete() {
            if (PopupIndicator.this.mListener != null) {
                PopupIndicator.this.mListener.onClosingComplete();
            }
            PopupIndicator.this.dismissComplete();
        }

        @Override
        public void onOpeningComplete() {
            if (PopupIndicator.this.mListener != null) {
                PopupIndicator.this.mListener.onOpeningComplete();
            }
        }

        public void setColors(int startColor, int endColor) {
            this.mMarker.setColors(startColor, endColor);
        }
    }
}

