/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.beautifykit.control;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Color;
import android.graphics.Path;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.SimpleItemAnimator;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.resource.bitmap.CenterCrop;
import com.bumptech.glide.load.resource.bitmap.RoundedCorners;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestOptions;
import com.vhall.beautifykit.R;
import com.vhall.beautifykit.base.BaseDelegate;
import com.vhall.beautifykit.base.BaseListAdapter;
import com.vhall.beautifykit.base.BaseViewHolder;
import com.vhall.beautifykit.circle.CircleFilledColor;
import com.vhall.beautifykit.circle.ColorfulCircleView;
import com.vhall.beautifykit.control.BaseControlView;
import com.vhall.beautifykit.control.MakeupControlView;
import com.vhall.beautifykit.dialog.ToastHelper;
import com.vhall.beautifykit.entity.MakeupCombinationBean;
import com.vhall.beautifykit.entity.MakeupCustomBean;
import com.vhall.beautifykit.entity.MakeupCustomClassBean;
import com.vhall.beautifykit.infe.AbstractMakeupDataFactory;
import com.vhall.beautifykit.listener.OnBottomAnimatorChangeListener;
import com.vhall.beautifykit.seekbar.DiscreteSeekBar;
import com.vhall.beautifykit.utils.DecimalUtils;
import com.wuyr.pathlayoutmanager.PathLayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0000\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0019J\b\u0010\u001f\u001a\u00020\u001dH\u0003J\b\u0010 \u001a\u00020\u001dH\u0002J\b\u0010!\u001a\u00020\u001dH\u0002J\b\u0010\"\u001a\u00020\u001dH\u0002J\b\u0010#\u001a\u00020\u001dH\u0002J\b\u0010$\u001a\u00020\u001dH\u0002J\b\u0010%\u001a\u00020\u001dH\u0002J\b\u0010&\u001a\u00020\u001dH\u0002J\b\u0010'\u001a\u00020\u001dH\u0002J\u0010\u0010(\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020\u001bH\u0002J\u0010\u0010*\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020\u001bH\u0002J$\u0010,\u001a\u00020\u001d2\u001a\u0010-\u001a\u0016\u0012\u0004\u0012\u00020\u0017\u0018\u00010.j\n\u0012\u0004\u0012\u00020\u0017\u0018\u0001`/H\u0002J\u0010\u00100\u001a\u00020\u001d2\u0006\u00101\u001a\u00020\u000eH\u0002J\u0018\u00102\u001a\u00020\u001d2\u0006\u00103\u001a\u00020\u00072\u0006\u00104\u001a\u000205H\u0002R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/vhall/beautifykit/control/MakeupControlView;", "Lcom/vhall/beautifykit/control/BaseControlView;", "mContext", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "combinationAnimator1", "Landroid/animation/ValueAnimator;", "combinationAnimator2", "mCombinationAdapter", "Lcom/vhall/beautifykit/base/BaseListAdapter;", "Lcom/vhall/beautifykit/entity/MakeupCombinationBean;", "mCurrentCustomClassKey", "", "mCustomAdapter", "Lcom/vhall/beautifykit/entity/MakeupCustomBean;", "mCustomClassAdapter", "Lcom/vhall/beautifykit/entity/MakeupCustomClassBean;", "mCustomClassIndex", "mCustomColorAdapter", "", "mDataFactory", "Lcom/vhall/beautifykit/infe/AbstractMakeupDataFactory;", "needUpdateView", "", "bindDataFactory", "", "dataFactory", "bindListener", "bindSeekBarListener", "initAdapter", "initColorRecycleView", "initCombinationAdapter", "initCustomBeanAdapter", "initCustomClassAdapter", "initCustomColorAdapter", "initView", "openCustomBottomAnimator", "isOpenCustom", "setCustomEnable", "enable", "showColorRecycleView", "doubleList", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "showCombinationSeekBar", "data", "showCustomSeekBar", "current", "intensity", "", "vhall-beautify-kit_release"})
public final class MakeupControlView
extends BaseControlView {
    private AbstractMakeupDataFactory mDataFactory;
    private BaseListAdapter<MakeupCombinationBean> mCombinationAdapter;
    private BaseListAdapter<MakeupCustomClassBean> mCustomClassAdapter;
    private int mCustomClassIndex;
    private String mCurrentCustomClassKey;
    private BaseListAdapter<MakeupCustomBean> mCustomAdapter;
    private BaseListAdapter<double[]> mCustomColorAdapter;
    private boolean needUpdateView;
    private ValueAnimator combinationAnimator1;
    private ValueAnimator combinationAnimator2;
    private final Context mContext;
    private HashMap _$_findViewCache;

    public final void bindDataFactory(@NotNull AbstractMakeupDataFactory dataFactory) {
        Intrinsics.checkParameterIsNotNull((Object)dataFactory, (String)"dataFactory");
        this.mDataFactory = dataFactory;
        BaseListAdapter<MakeupCustomClassBean> baseListAdapter = this.mCustomClassAdapter;
        if (baseListAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mCustomClassAdapter");
        }
        baseListAdapter.setData(dataFactory.getMakeupCustomClass());
        BaseListAdapter<MakeupCombinationBean> baseListAdapter2 = this.mCombinationAdapter;
        if (baseListAdapter2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mCombinationAdapter");
        }
        baseListAdapter2.setData(dataFactory.getMakeupCombinations());
        BaseListAdapter<MakeupCombinationBean> baseListAdapter3 = this.mCombinationAdapter;
        if (baseListAdapter3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mCombinationAdapter");
        }
        this.showCombinationSeekBar(baseListAdapter3.getData(dataFactory.getCurrentCombinationIndex()));
        this.mCurrentCustomClassKey = dataFactory.getMakeupCustomClass().get(this.mCustomClassIndex).getKey();
    }

    private final void initView() {
        RecyclerView recyclerView = (RecyclerView)this._$_findCachedViewById(R.id.recycler_combination);
        Intrinsics.checkExpressionValueIsNotNull((Object)recyclerView, (String)"recycler_combination");
        this.initHorizontalRecycleView(recyclerView);
        RecyclerView recyclerView2 = (RecyclerView)this._$_findCachedViewById(R.id.recycler_custom_class);
        Intrinsics.checkExpressionValueIsNotNull((Object)recyclerView2, (String)"recycler_custom_class");
        this.initHorizontalRecycleView(recyclerView2);
        RecyclerView recyclerView3 = (RecyclerView)this._$_findCachedViewById(R.id.recycler_custom);
        Intrinsics.checkExpressionValueIsNotNull((Object)recyclerView3, (String)"recycler_custom");
        this.initHorizontalRecycleView(recyclerView3);
        this.initColorRecycleView();
    }

    private final void initAdapter() {
        this.initCombinationAdapter();
        this.initCustomClassAdapter();
        this.initCustomBeanAdapter();
        this.initCustomColorAdapter();
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    private final void bindListener() {
        ((LinearLayout)this._$_findCachedViewById(R.id.cyt_combination_makeup)).setOnTouchListener((View.OnTouchListener)bindListener.1.INSTANCE);
        ((LinearLayout)this._$_findCachedViewById(R.id.cyt_custom_makeup)).setOnTouchListener((View.OnTouchListener)bindListener.2.INSTANCE);
        this.bindSeekBarListener();
        ((ImageView)this._$_findCachedViewById(R.id.iv_combination_makeup)).setOnClickListener(new View.OnClickListener(this){
            final /* synthetic */ MakeupControlView this$0;

            public final void onClick(View it) {
                MakeupControlView.access$getMDataFactory$p(this.this$0).enterCustomMakeup();
                if (MakeupControlView.access$getNeedUpdateView$p(this.this$0)) {
                    MakeupControlView.access$setMCustomClassIndex$p(this.this$0, 0);
                    MakeupControlView.access$setMCurrentCustomClassKey$p(this.this$0, MakeupControlView.access$getMDataFactory$p(this.this$0).getMakeupCustomClass().get(MakeupControlView.access$getMCustomClassIndex$p(this.this$0)).getKey());
                    ArrayList<MakeupCustomBean> arrayList = MakeupControlView.access$getMDataFactory$p(this.this$0).getMakeupCustomItemParams().get(MakeupControlView.access$getMCurrentCustomClassKey$p(this.this$0));
                    if (arrayList == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull(arrayList, (String)"mDataFactory.makeupCusto\u2026mCurrentCustomClassKey]!!");
                    ArrayList<MakeupCustomBean> beans = arrayList;
                    int current = MakeupControlView.access$getMDataFactory$p(this.this$0).getCurrentCustomItemIndex(MakeupControlView.access$getMCurrentCustomClassKey$p(this.this$0));
                    MakeupControlView.access$getMCustomClassAdapter$p(this.this$0).notifyDataSetChanged();
                    ((RecyclerView)this.this$0._$_findCachedViewById(R.id.recycler_custom_class)).scrollToPosition(MakeupControlView.access$getMCustomClassIndex$p(this.this$0));
                    MakeupControlView.access$getMCustomAdapter$p(this.this$0).setData(beans);
                    ((RecyclerView)this.this$0._$_findCachedViewById(R.id.recycler_custom)).scrollToPosition(current);
                    MakeupCustomBean makeupCustomBean = beans.get(current);
                    Intrinsics.checkExpressionValueIsNotNull((Object)makeupCustomBean, (String)"beans[current]");
                    MakeupCustomBean data = makeupCustomBean;
                    ArrayList<double[]> doubleList = data.getDoubleArray();
                    double intensity = MakeupControlView.access$getMDataFactory$p(this.this$0).getCurrentCustomIntensity(MakeupControlView.access$getMCurrentCustomClassKey$p(this.this$0), current);
                    MakeupControlView.access$showCustomSeekBar(this.this$0, current, intensity);
                    MakeupControlView.access$showColorRecycleView(this.this$0, doubleList);
                    MakeupControlView.access$setNeedUpdateView$p(this.this$0, false);
                } else if (MakeupControlView.access$getMCustomColorAdapter$p(this.this$0).getItemCount() > 0) {
                    RelativeLayout relativeLayout = (RelativeLayout)this.this$0._$_findCachedViewById(R.id.cyt_makeup_color);
                    Intrinsics.checkExpressionValueIsNotNull((Object)relativeLayout, (String)"cyt_makeup_color");
                    relativeLayout.setVisibility(0);
                }
                this.this$0.changeAdapterSelected(MakeupControlView.access$getMCombinationAdapter$p(this.this$0), MakeupControlView.access$getMDataFactory$p(this.this$0).getCurrentCombinationIndex(), -1);
                MakeupControlView.access$getMDataFactory$p(this.this$0).setCurrentCombinationIndex(-1);
                DiscreteSeekBar discreteSeekBar = (DiscreteSeekBar)this.this$0._$_findCachedViewById(R.id.seek_bar_combination);
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)discreteSeekBar), (String)"seek_bar_combination");
                discreteSeekBar.setVisibility(4);
                MakeupControlView.access$openCustomBottomAnimator(this.this$0, true);
            }
            {
                this.this$0 = makeupControlView;
            }
        });
        ((Button)this._$_findCachedViewById(R.id.iv_custom_back)).setOnClickListener(new View.OnClickListener(this){
            final /* synthetic */ MakeupControlView this$0;

            public final void onClick(View it) {
                RelativeLayout relativeLayout = (RelativeLayout)this.this$0._$_findCachedViewById(R.id.cyt_makeup_color);
                Intrinsics.checkExpressionValueIsNotNull((Object)relativeLayout, (String)"cyt_makeup_color");
                relativeLayout.setVisibility(8);
                MakeupControlView.access$openCustomBottomAnimator(this.this$0, false);
            }
            {
                this.this$0 = makeupControlView;
            }
        });
    }

    private final void initColorRecycleView() {
        RecyclerView recyclerView = (RecyclerView)this._$_findCachedViewById(R.id.recycler_makeup_color);
        Intrinsics.checkExpressionValueIsNotNull((Object)recyclerView, (String)"recycler_makeup_color");
        RecyclerView.ItemAnimator itemAnimator = recyclerView.getItemAnimator();
        if (itemAnimator == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.support.v7.widget.SimpleItemAnimator");
        }
        ((SimpleItemAnimator)itemAnimator).setSupportsChangeAnimations(false);
        int xOffset = this.getResources().getDimensionPixelSize(R.dimen.x100);
        Path path = new Path();
        int xAxis = this.getResources().getDimensionPixelSize(R.dimen.x40);
        path.moveTo((float)xAxis, 0.0f);
        path.lineTo((float)xAxis, (float)this.getResources().getDimensionPixelSize(R.dimen.x540));
        PathLayoutManager mPathLayoutManager = new PathLayoutManager(path, xOffset, 1);
        mPathLayoutManager.setScrollMode(0);
        mPathLayoutManager.setItemDirectionFixed(true);
        mPathLayoutManager.setFlingEnable(true);
        mPathLayoutManager.setCacheCount(5);
        mPathLayoutManager.setAutoSelect(true);
        mPathLayoutManager.setAutoSelectFraction(0.5f);
        mPathLayoutManager.setFixingAnimationDuration(250L);
        mPathLayoutManager.setItemScaleRatio(new float[]{1.0f, 0.0f, 1.5f, 0.25f, 2.0f, 0.5f, 1.5f, 0.75f, 1.0f, 1.0f});
        mPathLayoutManager.setOnItemSelectedListener(new PathLayoutManager.OnItemSelectedListener(this){
            final /* synthetic */ MakeupControlView this$0;

            public final void onSelected(int position) {
                RecyclerView recyclerView = (RecyclerView)this.this$0._$_findCachedViewById(R.id.recycler_makeup_color);
                Intrinsics.checkExpressionValueIsNotNull((Object)recyclerView, (String)"recycler_makeup_color");
                RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
                if (layoutManager == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.wuyr.pathlayoutmanager.PathLayoutManager");
                }
                PathLayoutManager layoutManager2 = (PathLayoutManager)layoutManager;
                layoutManager2.setFixingAnimationDuration(250L);
                MakeupControlView.access$getMDataFactory$p(this.this$0).updateCustomColor(MakeupControlView.access$getMCurrentCustomClassKey$p(this.this$0), position);
            }
            {
                this.this$0 = makeupControlView;
            }
        });
        RecyclerView recyclerView2 = (RecyclerView)this._$_findCachedViewById(R.id.recycler_makeup_color);
        Intrinsics.checkExpressionValueIsNotNull((Object)recyclerView2, (String)"recycler_makeup_color");
        recyclerView2.setLayoutManager((RecyclerView.LayoutManager)mPathLayoutManager);
    }

    private final void initCombinationAdapter() {
        this.mCombinationAdapter = new BaseListAdapter(new ArrayList(), new BaseDelegate<MakeupCombinationBean>(this){
            final /* synthetic */ MakeupControlView this$0;

            public void convert(int viewType, @NotNull BaseViewHolder helper, @NotNull MakeupCombinationBean data, int position) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)helper), (String)"helper");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                helper.setText(R.id.tv_control, data.getDesRes());
                helper.setImageResource(R.id.iv_control, data.getImageRes());
                View view = helper.itemView;
                Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"helper.itemView");
                view.setSelected(position == MakeupControlView.access$getMDataFactory$p(this.this$0).getCurrentCombinationIndex());
            }

            public void onItemClickListener(@NotNull View view, @NotNull MakeupCombinationBean data, int position) {
                Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                if (position != MakeupControlView.access$getMDataFactory$p(this.this$0).getCurrentCombinationIndex()) {
                    MakeupControlView.access$setNeedUpdateView$p(this.this$0, true);
                    this.this$0.changeAdapterSelected(MakeupControlView.access$getMCombinationAdapter$p(this.this$0), MakeupControlView.access$getMDataFactory$p(this.this$0).getCurrentCombinationIndex(), position);
                    MakeupControlView.access$getMDataFactory$p(this.this$0).setCurrentCombinationIndex(position);
                    MakeupControlView.access$getMDataFactory$p(this.this$0).onMakeupCombinationSelected(data);
                    MakeupControlView.access$showCombinationSeekBar(this.this$0, data);
                }
            }
            {
                this.this$0 = $outer;
            }
        }, R.layout.list_item_control_title_image_square);
        RecyclerView recyclerView = (RecyclerView)this._$_findCachedViewById(R.id.recycler_combination);
        Intrinsics.checkExpressionValueIsNotNull((Object)recyclerView, (String)"recycler_combination");
        BaseListAdapter<MakeupCombinationBean> baseListAdapter = this.mCombinationAdapter;
        if (baseListAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mCombinationAdapter");
        }
        recyclerView.setAdapter((RecyclerView.Adapter)baseListAdapter);
    }

    private final void initCustomClassAdapter() {
        this.mCustomClassAdapter = new BaseListAdapter(new ArrayList(), new BaseDelegate<MakeupCustomClassBean>(this){
            final /* synthetic */ MakeupControlView this$0;

            public void convert(int viewType, @NotNull BaseViewHolder helper, @NotNull MakeupCustomClassBean data, int position) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)helper), (String)"helper");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                helper.setText(R.id.tv_control, data.getNameRes());
                int current = MakeupControlView.access$getMDataFactory$p(this.this$0).getCurrentCustomItemIndex(data.getKey());
                helper.setVisible(R.id.iv_indicator, current > 0);
                View view = helper.itemView;
                Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"helper.itemView");
                view.setSelected(position == MakeupControlView.access$getMCustomClassIndex$p(this.this$0));
            }

            public void onItemClickListener(@NotNull View view, @NotNull MakeupCustomClassBean data, int position) {
                Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                if (MakeupControlView.access$getMCustomClassIndex$p(this.this$0) != position) {
                    this.this$0.changeAdapterSelected(MakeupControlView.access$getMCustomClassAdapter$p(this.this$0), MakeupControlView.access$getMCustomClassIndex$p(this.this$0), position);
                    MakeupControlView.access$setMCustomClassIndex$p(this.this$0, position);
                    MakeupControlView.access$setMCurrentCustomClassKey$p(this.this$0, data.getKey());
                    ArrayList<MakeupCustomBean> arrayList = MakeupControlView.access$getMDataFactory$p(this.this$0).getMakeupCustomItemParams().get(MakeupControlView.access$getMCurrentCustomClassKey$p(this.this$0));
                    if (arrayList == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull(arrayList, (String)"mDataFactory.makeupCusto\u2026mCurrentCustomClassKey]!!");
                    ArrayList<MakeupCustomBean> makeupCustomBeans = arrayList;
                    MakeupControlView.access$getMCustomAdapter$p(this.this$0).setData(makeupCustomBeans);
                    int current = MakeupControlView.access$getMDataFactory$p(this.this$0).getCurrentCustomItemIndex(MakeupControlView.access$getMCurrentCustomClassKey$p(this.this$0));
                    double intensity = MakeupControlView.access$getMDataFactory$p(this.this$0).getCurrentCustomIntensity(MakeupControlView.access$getMCurrentCustomClassKey$p(this.this$0), current);
                    MakeupControlView.access$showCustomSeekBar(this.this$0, current, intensity);
                    ((RecyclerView)this.this$0._$_findCachedViewById(R.id.recycler_custom)).scrollToPosition(current);
                    MakeupControlView.access$showColorRecycleView(this.this$0, makeupCustomBeans.get(current).getDoubleArray());
                }
            }
            {
                this.this$0 = $outer;
            }
        }, R.layout.list_item_control_title);
        RecyclerView recyclerView = (RecyclerView)this._$_findCachedViewById(R.id.recycler_custom_class);
        Intrinsics.checkExpressionValueIsNotNull((Object)recyclerView, (String)"recycler_custom_class");
        BaseListAdapter<MakeupCustomClassBean> baseListAdapter = this.mCustomClassAdapter;
        if (baseListAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mCustomClassAdapter");
        }
        recyclerView.setAdapter((RecyclerView.Adapter)baseListAdapter);
    }

    private final void initCustomBeanAdapter() {
        this.mCustomAdapter = new BaseListAdapter(new ArrayList(), new BaseDelegate<MakeupCustomBean>(this){
            final /* synthetic */ MakeupControlView this$0;

            public void convert(int viewType, @NotNull BaseViewHolder helper, @NotNull MakeupCustomBean item, int position) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)helper), (String)"helper");
                Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                BaseRequestOptions baseRequestOptions = new RequestOptions().transform(new Transformation[]{(Transformation)new CenterCrop(), (Transformation)new RoundedCorners(this.this$0.getResources().getDimensionPixelSize(R.dimen.x5))});
                Intrinsics.checkExpressionValueIsNotNull((Object)baseRequestOptions, (String)"RequestOptions().transfo\u2026onPixelSize(R.dimen.x5)))");
                RequestOptions requestOptions = (RequestOptions)baseRequestOptions;
                RequestBuilder requestBuilder = Glide.with((Context)MakeupControlView.access$getMContext$p(this.this$0)).applyDefaultRequestOptions(requestOptions).load(item.getDrawable());
                T t = helper.getView(R.id.iv_control);
                if (t == null) {
                    Intrinsics.throwNpe();
                }
                requestBuilder.into((ImageView)t);
                int current = MakeupControlView.access$getMDataFactory$p(this.this$0).getCurrentCustomItemIndex(MakeupControlView.access$getMCurrentCustomClassKey$p(this.this$0));
                View view = helper.itemView;
                Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"helper.itemView");
                view.setSelected(position == current);
            }

            public void onItemClickListener(@NotNull View view, @NotNull MakeupCustomBean data, int position) {
                block2: {
                    int oldIndex;
                    Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
                    Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                    if (data.getNameRes() > 0 && position > 0) {
                        Context context = this.this$0.getContext();
                        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
                        ToastHelper.showWhiteTextToast(context, data.getNameRes());
                    }
                    if (position == (oldIndex = MakeupControlView.access$getMDataFactory$p(this.this$0).getCurrentCustomItemIndex(MakeupControlView.access$getMCurrentCustomClassKey$p(this.this$0)))) break block2;
                    this.this$0.changeAdapterSelected(MakeupControlView.access$getMCustomAdapter$p(this.this$0), oldIndex, position);
                    MakeupControlView.access$getMDataFactory$p(this.this$0).onCustomBeanSelected(MakeupControlView.access$getMCurrentCustomClassKey$p(this.this$0), position);
                    double intensity = MakeupControlView.access$getMDataFactory$p(this.this$0).getCurrentCustomIntensity(MakeupControlView.access$getMCurrentCustomClassKey$p(this.this$0), position);
                    MakeupControlView.access$showCustomSeekBar(this.this$0, position, intensity);
                    MakeupControlView.access$showColorRecycleView(this.this$0, data.getDoubleArray());
                    View view2 = MakeupControlView.access$getMCustomClassAdapter$p(this.this$0).getViewByPosition(MakeupControlView.access$getMCustomClassIndex$p(this.this$0));
                    if (view2 != null && (view2 = view2.findViewById(R.id.iv_indicator)) != null) {
                        view2.setVisibility(position == 0 ? 4 : 0);
                    }
                }
            }
            {
                this.this$0 = $outer;
            }
        }, R.layout.list_item_control_image_square);
        RecyclerView recyclerView = (RecyclerView)this._$_findCachedViewById(R.id.recycler_custom);
        Intrinsics.checkExpressionValueIsNotNull((Object)recyclerView, (String)"recycler_custom");
        BaseListAdapter<MakeupCustomBean> baseListAdapter = this.mCustomAdapter;
        if (baseListAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mCustomAdapter");
        }
        recyclerView.setAdapter((RecyclerView.Adapter)baseListAdapter);
    }

    private final void initCustomColorAdapter() {
        this.mCustomColorAdapter = new BaseListAdapter(new ArrayList(), new BaseDelegate<double[]>(this){
            final /* synthetic */ MakeupControlView this$0;

            /*
             * WARNING - void declaration
             */
            public void convert(int viewType, @NotNull BaseViewHolder helper, @NotNull double[] item, int position) {
                ColorfulCircleView view;
                Intrinsics.checkParameterIsNotNull((Object)((Object)helper), (String)"helper");
                Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                ColorfulCircleView colorfulCircleView = view = (ColorfulCircleView)((Object)helper.getView(R.id.iv_colorful));
                CircleFilledColor circleFillColor = colorfulCircleView != null ? colorfulCircleView.getCircleFillColor() : null;
                int count = item.length / 4;
                CircleFilledColor.FillMode fillMode = CircleFilledColor.FillMode.SINGLE;
                int n = 0;
                int n2 = count;
                while (n < n2) {
                    void i;
                    int color2 = Color.argb((int)((int)(item[i * 4 + 3] * (double)255)), (int)((int)(item[i * 4] * (double)255)), (int)((int)(item[i * 4 + true] * (double)255)), (int)((int)(item[i * 4 + 2] * (double)255)));
                    if (i == false) {
                        CircleFilledColor circleFilledColor = circleFillColor;
                        if (circleFilledColor == null) {
                            Intrinsics.throwNpe();
                        }
                        circleFilledColor.setFillColor1(color2);
                        fillMode = CircleFilledColor.FillMode.SINGLE;
                    } else if (i == true) {
                        CircleFilledColor circleFilledColor = circleFillColor;
                        if (circleFilledColor == null) {
                            Intrinsics.throwNpe();
                        }
                        circleFilledColor.setFillColor2(color2);
                        if (item[7] == 1.0) {
                            fillMode = CircleFilledColor.FillMode.DOUBLE;
                        }
                    } else if (i == 2) {
                        CircleFilledColor circleFilledColor = circleFillColor;
                        if (circleFilledColor == null) {
                            Intrinsics.throwNpe();
                        }
                        circleFilledColor.setFillColor3(color2);
                        if (item[7] == 1.0) {
                            fillMode = CircleFilledColor.FillMode.DOUBLE;
                        }
                        if (item[11] == 1.0) {
                            fillMode = CircleFilledColor.FillMode.TRIPLE;
                        }
                    } else if (i == 3) {
                        CircleFilledColor circleFilledColor = circleFillColor;
                        if (circleFilledColor == null) {
                            Intrinsics.throwNpe();
                        }
                        circleFilledColor.setFillColor4(color2);
                        if (item[15] == 1.0) {
                            fillMode = CircleFilledColor.FillMode.QUADRUPLE;
                        }
                        if (item[11] == 1.0) {
                            fillMode = CircleFilledColor.FillMode.TRIPLE;
                        }
                        if (item[7] == 1.0) {
                            fillMode = CircleFilledColor.FillMode.DOUBLE;
                        }
                    }
                    ++i;
                }
                CircleFilledColor circleFilledColor = circleFillColor;
                if (circleFilledColor == null) {
                    Intrinsics.throwNpe();
                }
                circleFilledColor.setFillMode(fillMode);
                view.setCircleFillColor(circleFillColor);
            }

            public void onItemClickListener(@NotNull View view, @NotNull double[] data, int position) {
                Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                int current = MakeupControlView.access$getMDataFactory$p(this.this$0).getCurrentCustomItemIndex(MakeupControlView.access$getMCurrentCustomClassKey$p(this.this$0));
                int oldIndex = MakeupControlView.access$getMDataFactory$p(this.this$0).getCurrentCustomColorIndex(MakeupControlView.access$getMCurrentCustomClassKey$p(this.this$0), current);
                if (position < 3 || position >= 8 || oldIndex == position) {
                    return;
                }
                RecyclerView recyclerView = (RecyclerView)this.this$0._$_findCachedViewById(R.id.recycler_makeup_color);
                Intrinsics.checkExpressionValueIsNotNull((Object)recyclerView, (String)"recycler_makeup_color");
                RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
                if (layoutManager == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.wuyr.pathlayoutmanager.PathLayoutManager");
                }
                PathLayoutManager layoutManager2 = (PathLayoutManager)layoutManager;
                int n = oldIndex - position;
                boolean bl = false;
                if (Math.abs(n) > 1) {
                    layoutManager2.setFixingAnimationDuration(250L);
                } else {
                    layoutManager2.setFixingAnimationDuration(125L);
                }
                layoutManager2.smoothScrollToPosition(position);
            }
            {
                this.this$0 = $outer;
            }
        }, R.layout.list_item_control_colorful_circle);
        RecyclerView recyclerView = (RecyclerView)this._$_findCachedViewById(R.id.recycler_makeup_color);
        Intrinsics.checkExpressionValueIsNotNull((Object)recyclerView, (String)"recycler_makeup_color");
        BaseListAdapter<double[]> baseListAdapter = this.mCustomColorAdapter;
        if (baseListAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mCustomColorAdapter");
        }
        recyclerView.setAdapter((RecyclerView.Adapter)baseListAdapter);
    }

    private final void showCombinationSeekBar(MakeupCombinationBean data) {
        DiscreteSeekBar discreteSeekBar = (DiscreteSeekBar)this._$_findCachedViewById(R.id.seek_bar_combination);
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)discreteSeekBar), (String)"seek_bar_combination");
        discreteSeekBar.setVisibility(data.getType() == MakeupCombinationBean.TypeEnum.TYPE_NONE ? 4 : 0);
        DiscreteSeekBar discreteSeekBar2 = (DiscreteSeekBar)this._$_findCachedViewById(R.id.seek_bar_combination);
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)discreteSeekBar2), (String)"seek_bar_combination");
        discreteSeekBar2.setProgress((int)(data.getIntensity() * (double)100));
        this.setCustomEnable(data.getType() == MakeupCombinationBean.TypeEnum.TYPE_DAILY || data.getType() == MakeupCombinationBean.TypeEnum.TYPE_NONE);
    }

    private final void setCustomEnable(boolean enable) {
        ImageView imageView = (ImageView)this._$_findCachedViewById(R.id.iv_combination_makeup);
        Intrinsics.checkExpressionValueIsNotNull((Object)imageView, (String)"iv_combination_makeup");
        imageView.setEnabled(enable);
        float alpha = enable ? 1.0f : 0.6f;
        TextView textView = (TextView)this._$_findCachedViewById(R.id.tv_combination_makeup);
        Intrinsics.checkExpressionValueIsNotNull((Object)textView, (String)"tv_combination_makeup");
        textView.setAlpha(alpha);
        ImageView imageView2 = (ImageView)this._$_findCachedViewById(R.id.iv_combination_makeup);
        Intrinsics.checkExpressionValueIsNotNull((Object)imageView2, (String)"iv_combination_makeup");
        imageView2.setAlpha(alpha);
    }

    private final void showCustomSeekBar(int current, double intensity) {
        DiscreteSeekBar discreteSeekBar = (DiscreteSeekBar)this._$_findCachedViewById(R.id.seek_bar_custom);
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)discreteSeekBar), (String)"seek_bar_custom");
        discreteSeekBar.setVisibility(current == 0 ? 4 : 0);
        DiscreteSeekBar discreteSeekBar2 = (DiscreteSeekBar)this._$_findCachedViewById(R.id.seek_bar_custom);
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)discreteSeekBar2), (String)"seek_bar_custom");
        discreteSeekBar2.setProgress((int)(intensity * (double)100));
    }

    private final void showColorRecycleView(ArrayList<double[]> doubleList) {
        Collection collection = doubleList;
        boolean bl = false;
        boolean bl2 = false;
        if (collection == null || collection.isEmpty()) {
            BaseListAdapter<double[]> baseListAdapter = this.mCustomColorAdapter;
            if (baseListAdapter == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mCustomColorAdapter");
            }
            baseListAdapter.setData(new ArrayList());
            RelativeLayout relativeLayout = (RelativeLayout)this._$_findCachedViewById(R.id.cyt_makeup_color);
            Intrinsics.checkExpressionValueIsNotNull((Object)relativeLayout, (String)"cyt_makeup_color");
            relativeLayout.setVisibility(8);
        } else {
            BaseListAdapter<double[]> baseListAdapter = this.mCustomColorAdapter;
            if (baseListAdapter == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mCustomColorAdapter");
            }
            baseListAdapter.setData(doubleList);
            RelativeLayout relativeLayout = (RelativeLayout)this._$_findCachedViewById(R.id.cyt_makeup_color);
            Intrinsics.checkExpressionValueIsNotNull((Object)relativeLayout, (String)"cyt_makeup_color");
            relativeLayout.setVisibility(0);
            AbstractMakeupDataFactory abstractMakeupDataFactory = this.mDataFactory;
            if (abstractMakeupDataFactory == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mDataFactory");
            }
            String string2 = this.mCurrentCustomClassKey;
            if (string2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mCurrentCustomClassKey");
            }
            int current = abstractMakeupDataFactory.getCurrentCustomItemIndex(string2);
            AbstractMakeupDataFactory abstractMakeupDataFactory2 = this.mDataFactory;
            if (abstractMakeupDataFactory2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mDataFactory");
            }
            String string3 = this.mCurrentCustomClassKey;
            if (string3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mCurrentCustomClassKey");
            }
            int colorIndex = abstractMakeupDataFactory2.getCurrentCustomColorIndex(string3, current);
            RecyclerView recyclerView = (RecyclerView)this._$_findCachedViewById(R.id.recycler_makeup_color);
            Intrinsics.checkExpressionValueIsNotNull((Object)recyclerView, (String)"recycler_makeup_color");
            RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
            if (layoutManager == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.wuyr.pathlayoutmanager.PathLayoutManager");
            }
            ((PathLayoutManager)layoutManager).scrollToPosition(colorIndex);
        }
    }

    private final void bindSeekBarListener() {
        ((DiscreteSeekBar)this._$_findCachedViewById(R.id.seek_bar_combination)).setOnProgressChangeListener(new DiscreteSeekBar.OnSimpleProgressChangeListener(this){
            final /* synthetic */ MakeupControlView this$0;

            public void onProgressChanged(@Nullable DiscreteSeekBar seekBar, int value, boolean fromUser) {
                MakeupCombinationBean combination;
                float valueF;
                if (!fromUser) {
                    return;
                }
                DiscreteSeekBar discreteSeekBar = seekBar;
                if (discreteSeekBar == null) {
                    Intrinsics.throwNpe();
                }
                if (!DecimalUtils.doubleEquals(valueF = 1.0f * (float)(value - discreteSeekBar.getMin()) / (float)100, (combination = (MakeupCombinationBean)MakeupControlView.access$getMCombinationAdapter$p(this.this$0).getData(MakeupControlView.access$getMDataFactory$p(this.this$0).getCurrentCombinationIndex())).getIntensity())) {
                    combination.setIntensity(valueF);
                    combination.setFilterIntensity(valueF);
                    MakeupControlView.access$getMDataFactory$p(this.this$0).updateCombinationIntensity(valueF);
                }
            }
            {
                this.this$0 = $outer;
            }
        });
        ((DiscreteSeekBar)this._$_findCachedViewById(R.id.seek_bar_custom)).setOnProgressChangeListener(new DiscreteSeekBar.OnSimpleProgressChangeListener(this){
            final /* synthetic */ MakeupControlView this$0;

            public void onProgressChanged(@Nullable DiscreteSeekBar seekBar, int value, boolean fromUser) {
                if (!fromUser) {
                    return;
                }
                DiscreteSeekBar discreteSeekBar = seekBar;
                if (discreteSeekBar == null) {
                    Intrinsics.throwNpe();
                }
                float valueF = 1.0f * (float)(value - discreteSeekBar.getMin()) / (float)100;
                int current = MakeupControlView.access$getMDataFactory$p(this.this$0).getCurrentCustomItemIndex(MakeupControlView.access$getMCurrentCustomClassKey$p(this.this$0));
                double intensity = MakeupControlView.access$getMDataFactory$p(this.this$0).getCurrentCustomIntensity(MakeupControlView.access$getMCurrentCustomClassKey$p(this.this$0), current);
                if (!DecimalUtils.doubleEquals(intensity, valueF)) {
                    MakeupControlView.access$getMDataFactory$p(this.this$0).updateCustomItemIntensity(MakeupControlView.access$getMCurrentCustomClassKey$p(this.this$0), current, valueF);
                }
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    private final void openCustomBottomAnimator(boolean isOpenCustom) {
        if (this.combinationAnimator1 != null) {
            ValueAnimator valueAnimator = this.combinationAnimator1;
            if (valueAnimator == null) {
                Intrinsics.throwNpe();
            }
            if (valueAnimator.isRunning()) {
                ValueAnimator valueAnimator2 = this.combinationAnimator1;
                if (valueAnimator2 == null) {
                    Intrinsics.throwNpe();
                }
                valueAnimator2.cancel();
            }
        }
        if (this.combinationAnimator2 != null) {
            ValueAnimator valueAnimator = this.combinationAnimator2;
            if (valueAnimator == null) {
                Intrinsics.throwNpe();
            }
            if (valueAnimator.isRunning()) {
                ValueAnimator valueAnimator3 = this.combinationAnimator2;
                if (valueAnimator3 == null) {
                    Intrinsics.throwNpe();
                }
                valueAnimator3.cancel();
            }
        }
        int start = isOpenCustom ? this.getResources().getDimensionPixelSize(R.dimen.x290) : this.getResources().getDimensionPixelSize(R.dimen.x366);
        int mid = 1;
        int end = isOpenCustom ? this.getResources().getDimensionPixelSize(R.dimen.x366) : this.getResources().getDimensionPixelSize(R.dimen.x290);
        ValueAnimator valueAnimator = this.combinationAnimator1 = ValueAnimator.ofInt((int[])new int[]{start, mid});
        if (valueAnimator == null) {
            Intrinsics.throwNpe();
        }
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this, isOpenCustom, start, mid){
            final /* synthetic */ MakeupControlView this$0;
            final /* synthetic */ boolean $isOpenCustom;
            final /* synthetic */ int $start;
            final /* synthetic */ int $mid;

            public final void onAnimationUpdate(ValueAnimator animation) {
                block2: {
                    LinearLayout view;
                    ValueAnimator valueAnimator = animation;
                    Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator, (String)"animation");
                    Object object = valueAnimator.getAnimatedValue();
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
                    }
                    int height = (Integer)object;
                    LinearLayout linearLayout = view = this.$isOpenCustom ? (LinearLayout)this.this$0._$_findCachedViewById(R.id.cyt_combination_makeup) : (LinearLayout)this.this$0._$_findCachedViewById(R.id.cyt_custom_makeup);
                    Intrinsics.checkExpressionValueIsNotNull((Object)linearLayout, (String)"view");
                    ViewGroup.LayoutParams layoutParams = linearLayout.getLayoutParams();
                    if (layoutParams == null) {
                        throw new TypeCastException("null cannot be cast to non-null type android.widget.FrameLayout.LayoutParams");
                    }
                    FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)layoutParams;
                    params.height = height;
                    view.setLayoutParams((ViewGroup.LayoutParams)params);
                    float showRate = 0.5f * (float)(height - this.$start) / (float)(this.$mid - this.$start);
                    OnBottomAnimatorChangeListener onBottomAnimatorChangeListener = this.this$0.getOnBottomAnimatorChangeListener();
                    if (onBottomAnimatorChangeListener == null) break block2;
                    onBottomAnimatorChangeListener.onBottomAnimatorChangeListener(this.$isOpenCustom ? showRate : 1.0f - showRate);
                }
            }
            {
                this.this$0 = makeupControlView;
                this.$isOpenCustom = bl;
                this.$start = n;
                this.$mid = n2;
            }
        });
        ValueAnimator valueAnimator4 = this.combinationAnimator1;
        if (valueAnimator4 == null) {
            Intrinsics.throwNpe();
        }
        valueAnimator4.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(this){
            final /* synthetic */ MakeupControlView this$0;

            public void onAnimationEnd(@Nullable Animator animation) {
                ValueAnimator valueAnimator = MakeupControlView.access$getCombinationAnimator2$p(this.this$0);
                if (valueAnimator == null) {
                    Intrinsics.throwNpe();
                }
                valueAnimator.start();
            }
            {
                this.this$0 = $outer;
            }
        });
        ValueAnimator valueAnimator5 = this.combinationAnimator1;
        if (valueAnimator5 == null) {
            Intrinsics.throwNpe();
        }
        valueAnimator5.setDuration(150L);
        ValueAnimator valueAnimator6 = this.combinationAnimator2 = ValueAnimator.ofInt((int[])new int[]{mid, end});
        if (valueAnimator6 == null) {
            Intrinsics.throwNpe();
        }
        valueAnimator6.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this, isOpenCustom, mid, end){
            final /* synthetic */ MakeupControlView this$0;
            final /* synthetic */ boolean $isOpenCustom;
            final /* synthetic */ int $mid;
            final /* synthetic */ int $end;

            public final void onAnimationUpdate(ValueAnimator animation) {
                block2: {
                    LinearLayout view;
                    ValueAnimator valueAnimator = animation;
                    Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator, (String)"animation");
                    Object object = valueAnimator.getAnimatedValue();
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
                    }
                    int height = (Integer)object;
                    LinearLayout linearLayout = view = !this.$isOpenCustom ? (LinearLayout)this.this$0._$_findCachedViewById(R.id.cyt_combination_makeup) : (LinearLayout)this.this$0._$_findCachedViewById(R.id.cyt_custom_makeup);
                    Intrinsics.checkExpressionValueIsNotNull((Object)linearLayout, (String)"view");
                    ViewGroup.LayoutParams layoutParams = linearLayout.getLayoutParams();
                    if (layoutParams == null) {
                        throw new TypeCastException("null cannot be cast to non-null type android.widget.FrameLayout.LayoutParams");
                    }
                    FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)layoutParams;
                    params.height = height;
                    view.setLayoutParams((ViewGroup.LayoutParams)params);
                    float showRate = 0.5f * (float)(height - this.$mid) / (float)(this.$end - this.$mid) + 0.5f;
                    OnBottomAnimatorChangeListener onBottomAnimatorChangeListener = this.this$0.getOnBottomAnimatorChangeListener();
                    if (onBottomAnimatorChangeListener == null) break block2;
                    onBottomAnimatorChangeListener.onBottomAnimatorChangeListener(this.$isOpenCustom ? showRate : 1.0f - showRate);
                }
            }
            {
                this.this$0 = makeupControlView;
                this.$isOpenCustom = bl;
                this.$mid = n;
                this.$end = n2;
            }
        });
        ValueAnimator valueAnimator7 = this.combinationAnimator2;
        if (valueAnimator7 == null) {
            Intrinsics.throwNpe();
        }
        valueAnimator7.setDuration(150L);
        ValueAnimator valueAnimator8 = this.combinationAnimator1;
        if (valueAnimator8 == null) {
            Intrinsics.throwNpe();
        }
        valueAnimator8.start();
    }

    @JvmOverloads
    public MakeupControlView(@NotNull Context mContext, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)mContext, (String)"mContext");
        super(mContext, attrs, defStyleAttr);
        this.mContext = mContext;
        this.needUpdateView = true;
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.layout_make_up_control, (ViewGroup)this);
        this.initView();
        this.initAdapter();
        this.bindListener();
    }

    public /* synthetic */ MakeupControlView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public MakeupControlView(@NotNull Context mContext, @Nullable AttributeSet attrs) {
        this(mContext, attrs, 0, 4, null);
    }

    @JvmOverloads
    public MakeupControlView(@NotNull Context mContext) {
        this(mContext, null, 0, 6, null);
    }

    public static final /* synthetic */ AbstractMakeupDataFactory access$getMDataFactory$p(MakeupControlView $this) {
        AbstractMakeupDataFactory abstractMakeupDataFactory = $this.mDataFactory;
        if (abstractMakeupDataFactory == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mDataFactory");
        }
        return abstractMakeupDataFactory;
    }

    public static final /* synthetic */ void access$setMDataFactory$p(MakeupControlView $this, AbstractMakeupDataFactory abstractMakeupDataFactory) {
        $this.mDataFactory = abstractMakeupDataFactory;
    }

    public static final /* synthetic */ boolean access$getNeedUpdateView$p(MakeupControlView $this) {
        return $this.needUpdateView;
    }

    public static final /* synthetic */ void access$setNeedUpdateView$p(MakeupControlView $this, boolean bl) {
        $this.needUpdateView = bl;
    }

    public static final /* synthetic */ int access$getMCustomClassIndex$p(MakeupControlView $this) {
        return $this.mCustomClassIndex;
    }

    public static final /* synthetic */ void access$setMCustomClassIndex$p(MakeupControlView $this, int n) {
        $this.mCustomClassIndex = n;
    }

    public static final /* synthetic */ String access$getMCurrentCustomClassKey$p(MakeupControlView $this) {
        String string2 = $this.mCurrentCustomClassKey;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mCurrentCustomClassKey");
        }
        return string2;
    }

    public static final /* synthetic */ void access$setMCurrentCustomClassKey$p(MakeupControlView $this, String string2) {
        $this.mCurrentCustomClassKey = string2;
    }

    public static final /* synthetic */ BaseListAdapter access$getMCustomClassAdapter$p(MakeupControlView $this) {
        BaseListAdapter<MakeupCustomClassBean> baseListAdapter = $this.mCustomClassAdapter;
        if (baseListAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mCustomClassAdapter");
        }
        return baseListAdapter;
    }

    public static final /* synthetic */ void access$setMCustomClassAdapter$p(MakeupControlView $this, BaseListAdapter baseListAdapter) {
        $this.mCustomClassAdapter = baseListAdapter;
    }

    public static final /* synthetic */ BaseListAdapter access$getMCustomAdapter$p(MakeupControlView $this) {
        BaseListAdapter<MakeupCustomBean> baseListAdapter = $this.mCustomAdapter;
        if (baseListAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mCustomAdapter");
        }
        return baseListAdapter;
    }

    public static final /* synthetic */ void access$setMCustomAdapter$p(MakeupControlView $this, BaseListAdapter baseListAdapter) {
        $this.mCustomAdapter = baseListAdapter;
    }

    public static final /* synthetic */ void access$showCustomSeekBar(MakeupControlView $this, int current, double intensity) {
        $this.showCustomSeekBar(current, intensity);
    }

    public static final /* synthetic */ void access$showColorRecycleView(MakeupControlView $this, ArrayList doubleList) {
        $this.showColorRecycleView(doubleList);
    }

    public static final /* synthetic */ BaseListAdapter access$getMCustomColorAdapter$p(MakeupControlView $this) {
        BaseListAdapter<double[]> baseListAdapter = $this.mCustomColorAdapter;
        if (baseListAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mCustomColorAdapter");
        }
        return baseListAdapter;
    }

    public static final /* synthetic */ void access$setMCustomColorAdapter$p(MakeupControlView $this, BaseListAdapter baseListAdapter) {
        $this.mCustomColorAdapter = baseListAdapter;
    }

    public static final /* synthetic */ BaseListAdapter access$getMCombinationAdapter$p(MakeupControlView $this) {
        BaseListAdapter<MakeupCombinationBean> baseListAdapter = $this.mCombinationAdapter;
        if (baseListAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mCombinationAdapter");
        }
        return baseListAdapter;
    }

    public static final /* synthetic */ void access$setMCombinationAdapter$p(MakeupControlView $this, BaseListAdapter baseListAdapter) {
        $this.mCombinationAdapter = baseListAdapter;
    }

    public static final /* synthetic */ void access$openCustomBottomAnimator(MakeupControlView $this, boolean isOpenCustom) {
        $this.openCustomBottomAnimator(isOpenCustom);
    }

    public static final /* synthetic */ void access$showCombinationSeekBar(MakeupControlView $this, MakeupCombinationBean data) {
        $this.showCombinationSeekBar(data);
    }

    public static final /* synthetic */ Context access$getMContext$p(MakeupControlView $this) {
        return $this.mContext;
    }

    public static final /* synthetic */ ValueAnimator access$getCombinationAnimator2$p(MakeupControlView $this) {
        return $this.combinationAnimator2;
    }

    public static final /* synthetic */ void access$setCombinationAnimator2$p(MakeupControlView $this, ValueAnimator valueAnimator) {
        $this.combinationAnimator2 = valueAnimator;
    }

    @Override
    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    @Override
    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }
}

