/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.beautifykit.circle;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import com.vhall.beautifykit.R;

public class ShadowCircleRingView
extends View {
    private Paint mBorderPaint;
    private int mBorderWidth;
    private int mDefaultSize;

    public ShadowCircleRingView(Context context) {
        super(context);
        this.init();
    }

    public ShadowCircleRingView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public ShadowCircleRingView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.mBorderPaint = new Paint(1);
        this.mBorderPaint.setStyle(Paint.Style.STROKE);
        this.mBorderPaint.setColor(-1);
        this.mBorderWidth = this.getResources().getDimensionPixelSize(R.dimen.x8);
        this.mBorderPaint.setStrokeWidth((float)this.mBorderWidth);
        int shaRadius = this.getResources().getDimensionPixelSize(R.dimen.x4);
        this.mBorderPaint.setShadowLayer((float)shaRadius, 0.0f, 0.0f, Color.parseColor((String)"#80000000"));
        this.mDefaultSize = this.getResources().getDimensionPixelSize(R.dimen.x96);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int measuredWidth = this.getMeasuredWidth();
        int measuredHeight = this.getMeasuredHeight();
        if (widthMode == Integer.MIN_VALUE && heightMode == Integer.MIN_VALUE) {
            measuredWidth = this.mDefaultSize;
            measuredHeight = this.mDefaultSize;
        } else if (widthMode == Integer.MIN_VALUE) {
            measuredWidth = this.mDefaultSize;
            measuredHeight = heightSize;
        } else if (heightMode == Integer.MIN_VALUE) {
            measuredHeight = this.mDefaultSize;
            measuredWidth = widthSize;
        }
        int minSize = Math.min(measuredWidth, measuredHeight);
        this.setMeasuredDimension(minSize, minSize);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int w = this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
        float cx = (float)w / 2.0f;
        int h = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
        float cy = (float)h / 2.0f;
        float radius = (float)Math.min(w, h) / 2.0f - (float)this.mBorderWidth;
        canvas.drawCircle(cx, cy, radius, this.mBorderPaint);
    }
}

