/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.beautifykit.checkbox;

import android.content.Context;
import android.support.annotation.IdRes;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.LinearLayout;

public class CheckGroup
extends LinearLayout {
    private static final String LOG_TAG = CheckGroup.class.getSimpleName();
    private int mCheckedId = -1;
    private CompoundButton.OnCheckedChangeListener mChildOnCheckedChangeListener;
    private boolean mProtectFromCheckedChange = false;
    private OnCheckedChangeListener mOnCheckedChangeListener;
    private PassThroughHierarchyChangeListener mPassThroughListener;
    private OnDispatchActionUpListener mOnDispatchActionUpListener;

    public CheckGroup(Context context) {
        super(context);
        this.setOrientation(1);
        this.init();
    }

    public CheckGroup(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        this.mChildOnCheckedChangeListener = new CheckedStateTracker();
        this.mPassThroughListener = new PassThroughHierarchyChangeListener();
        super.setOnHierarchyChangeListener((ViewGroup.OnHierarchyChangeListener)this.mPassThroughListener);
    }

    public void setOnDispatchActionUpListener(OnDispatchActionUpListener onDispatchActionUpListener) {
        this.mOnDispatchActionUpListener = onDispatchActionUpListener;
    }

    public void setOnHierarchyChangeListener(ViewGroup.OnHierarchyChangeListener listener) {
        this.mPassThroughListener.mOnHierarchyChangeListener = listener;
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (ev.getAction() == 1 && this.mOnDispatchActionUpListener != null) {
            this.mOnDispatchActionUpListener.onDispatchActionUp((int)ev.getX());
        }
        return super.dispatchTouchEvent(ev);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        if (this.mCheckedId != -1) {
            this.mProtectFromCheckedChange = true;
            this.setCheckedStateForView(this.mCheckedId, true);
            this.mProtectFromCheckedChange = false;
            this.setCheckedId(this.mCheckedId);
        }
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        CheckBox button;
        if (child instanceof CheckBox && (button = (CheckBox)child).isChecked()) {
            this.mProtectFromCheckedChange = true;
            if (this.mCheckedId != -1) {
                this.setCheckedStateForView(this.mCheckedId, false);
            }
            this.mProtectFromCheckedChange = false;
            this.setCheckedId(button.getId());
        }
        super.addView(child, index, params);
    }

    public void check(@IdRes int id2) {
        if (id2 != -1 && id2 == this.mCheckedId) {
            return;
        }
        if (this.mCheckedId != -1) {
            this.setCheckedStateForView(this.mCheckedId, false);
        }
        if (id2 != -1) {
            this.setCheckedStateForView(id2, true);
        }
        this.setCheckedId(id2);
    }

    private void setCheckedId(@IdRes int id2) {
        this.mCheckedId = id2;
        if (this.mOnCheckedChangeListener != null) {
            this.mOnCheckedChangeListener.onCheckedChanged(this, this.mCheckedId);
        }
    }

    private void setCheckedStateForView(int viewId, boolean checked) {
        View checkedView = this.findViewById(viewId);
        if (checkedView != null && checkedView instanceof CheckBox) {
            ((CheckBox)checkedView).setChecked(checked);
        }
    }

    @IdRes
    public int getCheckedCheckBoxId() {
        return this.mCheckedId;
    }

    public void clearCheck() {
        this.check(-1);
    }

    public void setOnCheckedChangeListener(OnCheckedChangeListener listener) {
        this.mOnCheckedChangeListener = listener;
    }

    public CharSequence getAccessibilityClassName() {
        return CheckGroup.class.getName();
    }

    public static interface OnDispatchActionUpListener {
        public void onDispatchActionUp(int var1);
    }

    private class PassThroughHierarchyChangeListener
    implements ViewGroup.OnHierarchyChangeListener {
        private ViewGroup.OnHierarchyChangeListener mOnHierarchyChangeListener;

        private PassThroughHierarchyChangeListener() {
        }

        public void onChildViewAdded(View parent, View child) {
            if (parent == CheckGroup.this && child instanceof CheckBox) {
                int id2 = child.getId();
                if (id2 == -1) {
                    id2 = View.generateViewId();
                    child.setId(id2);
                }
                ((CheckBox)child).setOnCheckedChangeListener(CheckGroup.this.mChildOnCheckedChangeListener);
            }
            if (this.mOnHierarchyChangeListener != null) {
                this.mOnHierarchyChangeListener.onChildViewAdded(parent, child);
            }
        }

        public void onChildViewRemoved(View parent, View child) {
            if (parent == CheckGroup.this && child instanceof CheckBox) {
                ((CheckBox)child).setOnCheckedChangeListener(null);
            }
            if (this.mOnHierarchyChangeListener != null) {
                this.mOnHierarchyChangeListener.onChildViewRemoved(parent, child);
            }
        }
    }

    private class CheckedStateTracker
    implements CompoundButton.OnCheckedChangeListener {
        private CheckedStateTracker() {
        }

        public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
            if (CheckGroup.this.mProtectFromCheckedChange) {
                return;
            }
            int id2 = buttonView.getId();
            CheckGroup.this.mProtectFromCheckedChange = true;
            if (CheckGroup.this.mCheckedId != -1 && CheckGroup.this.mCheckedId != id2) {
                CheckGroup.this.setCheckedStateForView(CheckGroup.this.mCheckedId, false);
            }
            CheckGroup.this.mProtectFromCheckedChange = false;
            if (id2 == CheckGroup.this.mCheckedId) {
                isChecked = true;
                buttonView.setChecked(true);
            }
            CheckGroup.this.setCheckedId(isChecked ? id2 : -1);
        }
    }

    public static interface OnCheckedChangeListener {
        public void onCheckedChanged(CheckGroup var1, @IdRes int var2);
    }
}

