package com.vhall.beautifykit.control

import android.animation.ValueAnimator
import android.content.Context
import android.support.v4.app.FragmentActivity
import android.support.v7.widget.GridLayoutManager
import android.support.v7.widget.LinearLayoutManager
import android.util.AttributeSet
import android.widget.FrameLayout
import android.support.v7.widget.RecyclerView
import android.support.v7.widget.SimpleItemAnimator
import android.view.ViewGroup
import com.vhall.beautifykit.base.BaseListAdapter
import com.vhall.beautifykit.dialog.BaseDialogFragment
import com.vhall.beautifykit.dialog.ConfirmDialogFragment
import com.vhall.beautifykit.listener.OnBottomAnimatorChangeListener


/**
 *
 * DESC：
 * Created on 2020/12/8
 *
 */

abstract class BaseControlView @JvmOverloads constructor(private val mContext: Context, attrs: AttributeSet? = null, defStyleAttr: Int = 0) :
        FrameLayout(mContext, attrs, defStyleAttr) {

    /**
     * adapter单项点击，选中状态变更
     * @param adapter BaseListAdapter<T>
     * @param old Int
     * @param new Int
     */
    protected fun <T> changeAdapterSelected(adapter: BaseListAdapter<T>, old: Int, new: Int) {
        if (old >= 0) {
            adapter.getViewByPosition(old)?.isSelected = false
        }
        if (new >= 0) {
            adapter.getViewByPosition(new)?.isSelected = true
        }
    }

    protected var isVertical=true

    /**
     * adapter单项点击，选中状态变更 二次点击 清空选择
     * @param adapter BaseListAdapter<T>
     * @param old Int
     */
    protected fun <T> changeAdapterSelected(adapter: BaseListAdapter<T>, old: Int) {
        if (old >= 0) {
            adapter.getViewByPosition(old)?.isSelected = false
        }
    }


    protected fun showDialog(tip: String, unit: () -> Unit) {
        val confirmDialogFragment =
                ConfirmDialogFragment.newInstance(tip,
                        object : BaseDialogFragment.OnClickListener {
                            override fun onConfirm() { // recover params
                                unit.invoke()
                            }

                            override fun onCancel() {}
                        })
        confirmDialogFragment.show((mContext as FragmentActivity).supportFragmentManager, "ConfirmDialogFragmentReset")
    }

    protected fun initHorizontalRecycleView(recyclerView: RecyclerView) {
        recyclerView.setHasFixedSize(false)
        recyclerView.layoutManager = GridLayoutManager(mContext, 5)
        (recyclerView.itemAnimator as SimpleItemAnimator).supportsChangeAnimations = false
    }

    protected fun initVerticalRecycleView(recyclerView: RecyclerView) {
        recyclerView.setHasFixedSize(false)
        val linearLayoutManager = LinearLayoutManager(mContext, LinearLayoutManager.HORIZONTAL, false)
        recyclerView.layoutManager = linearLayoutManager
        recyclerView.apply {
            this.layoutParams.width =  ViewGroup.LayoutParams.MATCH_PARENT
            this.layoutParams.height = dpToPx(200)
        }
        (recyclerView.itemAnimator as SimpleItemAnimator).supportsChangeAnimations = false
    }

    fun dpToPx(dps: Int): Int {
        return Math.round(this.resources.displayMetrics.density * dps.toFloat())
    }

    /****************************************菜单动画*****************************************************/


    var isBottomShow = false
    var bottomLayoutAnimator: ValueAnimator? = null
    var onBottomAnimatorChangeListener: OnBottomAnimatorChangeListener? = null


}