/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.zxing.client.android.result.supplement;

import android.content.Context;
import android.widget.TextView;
import com.google.zxing.client.result.URIParsedResult;
import com.vhall.zxing.client.android.HttpHelper;
import com.vhall.zxing.client.android.R;
import com.vhall.zxing.client.android.history.HistoryManager;
import com.vhall.zxing.client.android.result.supplement.SupplementalInfoRetriever;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;

final class URIResultInfoRetriever
extends SupplementalInfoRetriever {
    private static final int MAX_REDIRECTS = 5;
    private final URIParsedResult result;
    private final String redirectString;

    URIResultInfoRetriever(TextView textView, URIParsedResult result, HistoryManager historyManager, Context context) {
        super(textView, historyManager);
        this.redirectString = context.getString(R.string.msg_redirect);
        this.result = result;
    }

    @Override
    void retrieveSupplementalInfo() throws IOException {
        URI oldURI;
        try {
            oldURI = new URI(this.result.getURI());
        }
        catch (URISyntaxException ignored) {
            return;
        }
        URI newURI = HttpHelper.unredirect(oldURI);
        int count = 0;
        while (count++ < 5 && !oldURI.equals(newURI)) {
            this.append(this.result.getDisplayResult(), null, new String[]{this.redirectString + " : " + newURI}, newURI.toString());
            oldURI = newURI;
            newURI = HttpHelper.unredirect(newURI);
        }
    }
}

